/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.cas.ICounterRepository;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.SharedDataStructure;
import java.util.concurrent.atomic.AtomicReference;

public class SharedDataStructure3
implements ICounterRepository {
    private final AtomicReference<ISharedElement> sharedValue = new AtomicReference();
    private static final int[] sleepTimes = new int[]{30, 50, 170, 370, 190, 10};
    private static final int sizeSleep = 5;
    private int sleepCount = 0;
    private final ISharedElement kInstancer;
    private volatile boolean fTouched;
    private volatile boolean fShutOff = false;

    public SharedDataStructure3(ISharedElement instance) {
        this.kInstancer = instance;
        this.reset();
    }

    @Override
    public void offer(ISharedElement offered) {
        while (!this.sharedValue.compareAndSet(null, offered)) {
            this.fTouched = true;
            ISharedElement tryGet = null;
            while ((tryGet = (ISharedElement)this.sharedValue.getAndSet(null)) == null) {
            }
            offered.merge(tryGet);
        }
    }

    public String toString() {
        return String.valueOf(Thread.currentThread().getName()) + " value = " + this.sharedValue.get();
    }

    @Override
    public ISharedElement get() {
        this.fTouched = true;
        ISharedElement tryGet = this.sharedValue.getAndSet(null);
        if (tryGet != null) {
            return tryGet;
        }
        return this.kInstancer.getSharedElementInstance();
    }

    @Override
    public void reset() {
        this.fTouched = true;
        this.sharedValue.set(this.kInstancer.getSharedElementInstance());
    }

    @Override
    public ISharedElement read() {
        ISharedElement result = this.kInstancer.getSharedElementInstance();
        return this.read(result);
    }

    @Override
    public ISharedElement read(ISharedElement result) {
        ISharedElement tryGet = null;
        while ((tryGet = (ISharedElement)this.sharedValue.getAndSet(null)) == null) {
        }
        this.fTouched = false;
        result.merge(tryGet);
        if (tryGet.shouldBeConsumendOnRead()) {
            tryGet.reset();
        } else {
            tryGet.resetMinMax();
        }
        this.offer(tryGet);
        return result;
    }

    public IRepository getInstance(ISharedElement instance) {
        return new SharedDataStructure(instance);
    }

    @Override
    public void update(IUpdater updater, long value, long startTime, int hashcode) {
        this.fTouched = true;
        ISharedElement element = this.sharedValue.getAndSet(null);
        if (element == null) {
            element = this.kInstancer.getSharedElementInstance();
        }
        updater.update(element, value, startTime);
        this.offer(element);
    }

    @Override
    public boolean hasNotChanged() {
        return !this.fTouched;
    }

    @Override
    public void update(IUpdater updater, long value, long startTime, long endTime) {
        this.update(updater, value, startTime, 0);
    }

    @Override
    public ISharedElement read(IRepository.IRepositorySustainabilityCallback callback) {
        return this.read();
    }

    @Override
    public boolean shouldBeHarvested() {
        return !this.kInstancer.shouldBeConsumendOnRead() || this.fTouched;
    }

    @Override
    public void increase(long time) {
        this.fTouched = true;
        ISharedElement element = this.sharedValue.getAndSet(null);
        if (element == null) {
            element = this.kInstancer.getSharedElementInstance();
        }
        element.increase(time);
        this.offer(element);
    }

    @Override
    public void decrease(long time) {
        this.fTouched = true;
        ISharedElement element = this.sharedValue.getAndSet(null);
        if (element == null) {
            element = this.kInstancer.getSharedElementInstance();
        }
        element.decrease(time);
        this.offer(element);
    }

    @Override
    public ISharedElement getSharedElementInstance() {
        return this.kInstancer.getSharedElementInstance();
    }

    @Override
    public void cleanup(boolean offerBack) {
        if (!offerBack) {
            this.reset();
        }
    }

    @Override
    public void setShutOff(boolean shutOff) {
        this.fShutOff = shutOff;
    }

    @Override
    public boolean isShutOff() {
        return this.fShutOff;
    }
}

