/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentIntervalCounter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;

public class HighPerformanceIntelligentTransactionTraceFilter {
    public static String kTransactionTraceClampKey = "introscope.agent.ttClamp";
    public static int kIntelligentInstrumentationComponentSingleMax_default = Integer.MAX_VALUE;
    public static String kIntelligentInstrumentationComponentSingleMaxKey = "introscope.agent.deep.instrumentation.transaction.componentcount.single.max";
    public static String kIntelligentInstrumentationComponentSingleMaxDesp = "IntelligentInstrumentationComponentCountSingleMax";
    public static int kIntelligentInstrumentationComponentTotalMax_default = Integer.MAX_VALUE;
    public static String kIntelligentInstrumentationComponentTotalMaxKey = "introscope.agent.deep.instrumentation.transaction.componentcount.total.max";
    public static String kIntelligentInstrumentationComponentTotalMaxDesp = "IntelligentInstrumentationComponentCountTotalMax";
    public static int kIntelligentInstrumentationResposeThresholdFactor_default = 10;
    public static String kIntelligentInstrumentationResposeThresholdFactorKey = "introscope.agent.deep.instrumentation.transaction.response.threshold.factor";
    public static String kIntelligentInstrumentationResposeThresholdFactorDesp = "IntelligentInstrumentationTransactionResponseThresholdFactor";
    public static int kIntelligentInstrumentationMaxTransactionDepth_default = 800;
    public static String kIntelligentInstrumentationMaxTTDepthDesp = "IntelligentInstrumentationTransactionMaxTransactionDepth";
    public static String kIntelligentInstrumentationMaxTTDepthKey = "introscope.agent.deep.transaction.max.depth";
    private static final HighPerformanceIntelligentTransactionTraceFilter fTTFilter = new HighPerformanceIntelligentTransactionTraceFilter();
    private boolean fInitialized = false;
    private int fComponentCountSingleMax = kIntelligentInstrumentationComponentSingleMax_default;
    private int fComponentCountTotalMax = kIntelligentInstrumentationComponentTotalMax_default;
    private int fTransactionCountClamp = 200;
    private int fResponseThresholdFactor = kIntelligentInstrumentationResposeThresholdFactor_default;
    private int fMaxTransactionDepth = kIntelligentInstrumentationMaxTransactionDepth_default;
    private HighPerformanceIntelligentIntervalCounter fIntervalCounter = null;

    private HighPerformanceIntelligentTransactionTraceFilter() {
    }

    public static HighPerformanceIntelligentTransactionTraceFilter getInstance() {
        return fTTFilter;
    }

    public int getSingleTransactionTraceComponentsMax() {
        return this.fComponentCountSingleMax;
    }

    public void updateTransactionCounter(IAgent agent, TransactionComponentData root, int totalComponents) {
        if (this.fIntervalCounter != null) {
            this.fIntervalCounter.increaseCounter(1, totalComponents);
        }
    }

    public void initialize(IAgent agent) {
        if (agent == null) {
            return;
        }
        if (this.fInitialized) {
            return;
        }
        this.fTransactionCountClamp = agent.IAgent_getIndexedProperties().getIntProperty(kTransactionTraceClampKey);
        this.createComponentCountConfigParameters(agent);
        this.fIntervalCounter = new HighPerformanceIntelligentIntervalCounter("Transaction Trace", agent.IAgent_getCommonHeartbeat());
        this.fInitialized = true;
    }

    public int getTransactionTraceThrottleState() {
        if (!this.isInitialized()) {
            return 0;
        }
        if (this.fTransactionCountClamp <= 0) {
            return 2;
        }
        int throttleState = 0;
        int[] counts = this.fIntervalCounter.getCurrentCounts();
        int transactionCount = counts[0];
        int componentCount = counts[1];
        double expectedComponents = (double)transactionCount * (double)this.fComponentCountTotalMax / (double)this.fTransactionCountClamp;
        double extraComponents = ((double)transactionCount + 0.5) * (double)this.fComponentCountTotalMax / (double)this.fTransactionCountClamp;
        throttleState = (double)componentCount <= expectedComponents ? 0 : ((double)componentCount <= extraComponents ? 1 : 2);
        return throttleState;
    }

    public boolean isInitialized() {
        return this.fInitialized;
    }

    public void setComponentCountSingleMax(int inValue) {
        this.fComponentCountSingleMax = inValue;
    }

    public void setComponentCountTotalMax(int inValue) {
        this.fComponentCountTotalMax = inValue;
    }

    public int getTransactionResponseThresholdFactor() {
        return this.fResponseThresholdFactor;
    }

    public void setMaxTransactionDepth(int fMaxTransactionDepth) {
        this.fMaxTransactionDepth = fMaxTransactionDepth;
    }

    public int getMaxTransactionDepth() {
        return this.fMaxTransactionDepth;
    }

    public void setTransactionResponseThresholdFactor(int inValue) {
        this.fResponseThresholdFactor = inValue;
    }

    private void createComponentCountConfigParameters(IAgent agent) {
        ConfigurationManager configurationManager = agent.IAgent_getConfigurationManager();
        Module module = agent.IAgent_getModule();
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        PositiveIntegerConfigurationProperty singleMax = new PositiveIntegerConfigurationProperty(kIntelligentInstrumentationComponentSingleMaxKey, kIntelligentInstrumentationComponentSingleMax_default, kIntelligentInstrumentationComponentSingleMaxDesp, null, true, false, feedback, module, localizer){

            @Override
            public boolean validate(Object value) {
                if (value == null && this.isInitialized()) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Missing_II_ComponentCount_Single_Max", this.toString(value)));
                }
                if (value != null && this.getValue() != null && (Integer)value < 0) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Invalid_II_ComponentCount_Single_Max", this.toString(value)));
                }
                return true;
            }

            @Override
            public void set(Object value) {
                HighPerformanceIntelligentTransactionTraceFilter.this.setComponentCountSingleMax((Integer)value);
            }
        };
        configurationManager.add(singleMax, true);
        PositiveIntegerConfigurationProperty totalMax = new PositiveIntegerConfigurationProperty(kIntelligentInstrumentationComponentTotalMaxKey, kIntelligentInstrumentationComponentTotalMax_default, kIntelligentInstrumentationComponentTotalMaxDesp, null, true, false, feedback, module, localizer){

            @Override
            public boolean validate(Object value) {
                if (value == null && this.isInitialized()) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Missing_II_ComponentCount_Total_Max", this.toString(value)));
                }
                if (value != null && this.getValue() != null && (Integer)value < 0) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Invalid_II_ComponentCount_Total_Max", this.toString(value)));
                }
                return true;
            }

            @Override
            public void set(Object value) {
                HighPerformanceIntelligentTransactionTraceFilter.this.setComponentCountTotalMax((Integer)value);
            }
        };
        configurationManager.add(totalMax, true);
        PositiveIntegerConfigurationProperty thresholdFactor = new PositiveIntegerConfigurationProperty(kIntelligentInstrumentationResposeThresholdFactorKey, kIntelligentInstrumentationResposeThresholdFactor_default, kIntelligentInstrumentationResposeThresholdFactorDesp, null, true, false, feedback, module, localizer){

            @Override
            public boolean validate(Object value) {
                if (value == null && this.isInitialized()) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Missing_II_Transaction_Response_Threshold_Factor", this.toString(value)));
                }
                if (value != null && this.getValue() != null && (Integer)value <= 0) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Invalid_II_Transaction_Response_Threshold_Factor", this.toString(value)));
                }
                return true;
            }

            @Override
            public void set(Object value) {
                HighPerformanceIntelligentTransactionTraceFilter.this.setTransactionResponseThresholdFactor((Integer)value);
            }
        };
        configurationManager.add(thresholdFactor, true);
        PositiveIntegerConfigurationProperty maxTTDepth = new PositiveIntegerConfigurationProperty(kIntelligentInstrumentationMaxTTDepthKey, kIntelligentInstrumentationMaxTransactionDepth_default, kIntelligentInstrumentationMaxTTDepthDesp, null, true, false, feedback, module, localizer){

            @Override
            public boolean validate(Object value) {
                if (value == null && this.isInitialized()) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Missing_II_Transaction_Response_Threshold_Factor", this.toString(value)));
                }
                if (value != null && this.getValue() != null && (Integer)value <= 0) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getFormattedLocalizedString("Invalid_II_Transaction_Response_Threshold_Factor", this.toString(value)));
                }
                return true;
            }

            @Override
            public void set(Object value) {
                HighPerformanceIntelligentTransactionTraceFilter.this.setMaxTransactionDepth((Integer)value);
            }
        };
        configurationManager.add(maxTTDepth, true);
    }
}

