/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link;

import com.wily.isengard.api.TransportConfiguration;
import com.wily.isengard.postofficehub.link.IRemoteClientTransport;
import com.wily.isengard.postofficehub.link.v1.CaptureOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;

class ClientHandShaker {
    private final TransportConfiguration fTransportConfig;
    private static final String eol = System.getProperty("line.separator");
    private static final SimpleDateFormat format = new SimpleDateFormat("dd/MM/yy  HH:mm:ss.SSS");

    public ClientHandShaker() {
        this.fTransportConfig = null;
    }

    public ClientHandShaker(TransportConfiguration config) {
        this.fTransportConfig = config;
    }

    public void doInitialHandshake(IRemoteClientTransport transport) throws IOException {
        byte[] log;
        byte[] bytes;
        if (transport.isClosed()) {
            throw new IllegalArgumentException("The transport: " + transport + " is closed.");
        }
        DataOutputStream out = new DataOutputStream(transport.getRawOutputStream());
        DataInputStream in = new DataInputStream(transport.getRawInputStream());
        OutputStream logStream = null;
        if (this.fTransportConfig != null) {
            logStream = this.fTransportConfig.getCaptureLogStream();
        }
        if (logStream != null) {
            StringBuilder sb = new StringBuilder(transport.getType());
            sb.append(" V");
            sb.append(transport.getIsengardProtocolVersion());
            sb.append(" ");
            sb.append(transport.getRemoteHostName());
            sb.append(":");
            sb.append(transport.getRemotePort());
            sb.append(" ");
            sb.append(transport.getRouteConnectionInfo());
            byte[] log2 = CaptureOutputStream.formatTextEvent("St", sb.toString());
            logStream.write(log2);
        }
        byte greeting = in.readByte();
        if (logStream != null) {
            bytes = new byte[]{greeting};
            log = CaptureOutputStream.formatBinaryEvent("Rx", bytes);
            logStream.write(log);
        }
        if (greeting != 17) {
            throw new IOException("Unexpected handshake data from server");
        }
        out.writeByte(32);
        transport.writeVersion(out);
        if (logStream != null) {
            byte[] byArray = new byte[5];
            byArray[0] = 32;
            byArray[4] = (byte)transport.getIsengardProtocolVersion();
            bytes = byArray;
            log = CaptureOutputStream.formatBinaryEvent("Tx", bytes);
            logStream.write(log);
        }
    }
}

