/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.util.tree;

import com.wily.EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.wily.isengard.util.tree.DirectoryEntry;
import com.wily.isengard.util.tree.DirectoryPath;
import com.wily.isengard.util.tree.DirectoryPathAndEntry;
import com.wily.isengard.util.tree.DirectoryPathTokenizer;
import com.wily.isengard.util.tree.EntryAlreadyExistsException;
import com.wily.isengard.util.tree.EntryNotFoundException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.isengard.util.tree.NodeAlreadyExistsException;
import com.wily.wilyassert.Assertion;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class DirectoryTreeNode {
    private Map fChildren;
    private DirectoryTreeNode fParent;
    private String fName;
    private DirectoryEntry fEntry;

    public DirectoryTreeNode(DirectoryTreeNode parent, String name, DirectoryEntry entry) {
        this.fParent = parent;
        this.fName = name;
        this.fEntry = entry;
        this.fChildren = new ConcurrentHashMap();
    }

    public String getName() {
        return this.fName;
    }

    public String getPathString() {
        if (this.fParent == null) {
            return "";
        }
        return String.valueOf(this.fParent.getPathString()) + "/" + this.fName;
    }

    public DirectoryPath getPath() {
        return new DirectoryPath(this.getPathString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(DirectoryTreeNode node) throws NodeAlreadyExistsException {
        if (node == null) {
            return;
        }
        String nodeName = node.getName();
        Map map = this.fChildren;
        synchronized (map) {
            if (this.getChildNode(nodeName) != null) {
                throw new NodeAlreadyExistsException();
            }
            if (nodeName != null) {
                this.fChildren.put(nodeName, node);
            }
        }
    }

    private DirectoryTreeNode getChildNode(String nodeName) {
        return nodeName != null ? (DirectoryTreeNode)this.fChildren.get(nodeName) : null;
    }

    public Iterator getSubDirectoryIterator(DirectoryPathTokenizer tokenizer) throws InvalidPathException {
        if (tokenizer.hasNextPath()) {
            String nodeName = tokenizer.getNextPath();
            DirectoryTreeNode node = this.getChildNode(nodeName);
            if (node == null) {
                throw new InvalidPathException(String.valueOf(this.getPathString()) + "/" + nodeName);
            }
            return node.getSubDirectoryIterator(tokenizer);
        }
        return this.shallowIterator();
    }

    private void removePathFromParent() {
        if (this.fEntry == null && this.fChildren.size() == 0 && this.fParent != null) {
            if (this.fName != null) {
                this.fParent.fChildren.remove(this.fName);
            }
            this.fParent.removePathFromParent();
        }
    }

    public boolean hasEntry(DirectoryPathTokenizer tokenizer) {
        if (tokenizer.hasNextPath()) {
            String nodeName = tokenizer.getNextPath();
            DirectoryTreeNode node = this.getChildNode(nodeName);
            if (node == null) {
                return false;
            }
            return node.hasEntry(tokenizer);
        }
        return this.fEntry != null;
    }

    public DirectoryEntry getEntry(DirectoryPathTokenizer tokenizer) throws InvalidPathException, EntryNotFoundException {
        if (tokenizer.hasNextPath()) {
            String nodeName = tokenizer.getNextPath();
            DirectoryTreeNode node = this.getChildNode(nodeName);
            if (node == null) {
                throw new InvalidPathException(String.valueOf(this.getPathString()) + "/" + nodeName);
            }
            return node.getEntry(tokenizer);
        }
        if (this.fEntry == null) {
            throw new EntryNotFoundException(this.getPathString());
        }
        return this.fEntry;
    }

    public DirectoryEntry deleteEntry(DirectoryPathTokenizer tokenizer) throws InvalidPathException {
        if (tokenizer.hasNextPath()) {
            String nodeName = tokenizer.getNextPath();
            DirectoryTreeNode node = this.getChildNode(nodeName);
            if (node == null) {
                throw new InvalidPathException(String.valueOf(this.getPathString()) + "/" + nodeName);
            }
            return node.deleteEntry(tokenizer);
        }
        DirectoryEntry entry = this.fEntry;
        this.fEntry = null;
        this.removePathFromParent();
        return entry;
    }

    public void addIfNotExists(DirectoryPathTokenizer tokenizer, DirectoryEntry entry) throws EntryAlreadyExistsException {
        if (tokenizer.hasNextPath()) {
            String nodeName = tokenizer.getNextPath();
            DirectoryTreeNode node = this.getChildNode(nodeName);
            if (node == null) {
                node = new DirectoryTreeNode(this, nodeName, null);
                try {
                    this.addChild(node);
                }
                catch (NodeAlreadyExistsException nodeAlreadyExistsException) {}
            }
            node.addIfNotExists(tokenizer, entry);
        } else {
            if (this.fEntry != null) {
                String path = this.getPathString();
                throw new EntryAlreadyExistsException(path, this.fEntry);
            }
            this.fEntry = entry;
        }
    }

    public Iterator iterator() {
        return new DirectoryTreeIterator(this, true);
    }

    public Collection values() {
        return this.fChildren.values();
    }

    public Iterator shallowIterator() {
        return new DirectoryTreeIterator(this, false);
    }

    public void clear() {
        this.fChildren.clear();
    }

    public static class DirectoryTreeIterator
    implements Iterator {
        private Stack fIteratorStack;
        private boolean fNextIsPositioned;
        private final boolean fGoDeep;
        private Object fNextObject;

        private DirectoryTreeIterator(DirectoryTreeNode currentNode, boolean goDeep) {
            this.fGoDeep = goDeep;
            this.fNextIsPositioned = false;
            this.fNextObject = null;
            this.fIteratorStack = new Stack();
            this.fIteratorStack.push(currentNode.fChildren.values().iterator());
        }

        private void positionNext() {
            if (this.fNextIsPositioned) {
                return;
            }
            if (this.fIteratorStack.empty()) {
                return;
            }
            Iterator i = (Iterator)this.fIteratorStack.pop();
            if (!i.hasNext()) {
                this.positionNext();
                return;
            }
            DirectoryTreeNode node = (DirectoryTreeNode)i.next();
            if (this.fGoDeep && !node.fChildren.isEmpty()) {
                this.fIteratorStack.push(node.fChildren.values().iterator());
            }
            this.fIteratorStack.push(i);
            this.fNextObject = new DirectoryPathAndEntry(node.getPath(), node.fEntry);
            this.fNextIsPositioned = true;
        }

        @Override
        public boolean hasNext() {
            this.positionNext();
            return this.fNextObject != null;
        }

        public Object next() {
            this.positionNext();
            Object result = this.fNextObject;
            this.fNextIsPositioned = false;
            this.fNextObject = null;
            return result;
        }

        @Override
        public void remove() {
            Assertion.wilyAssert(false, "Unsupported");
        }
    }
}

