/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt.primitive;

import com.wily.util.adt.primitive.ObjIntMapEntry;
import com.wily.util.adt.primitive.PrimitiveObjIntMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ObjIntHashMap<V>
implements PrimitiveObjIntMap<V>,
Serializable {
    private static final long serialVersionUID = 6498530643795940168L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient ObjIntMapEntry<V>[] table;
    private transient int size;
    private int threshold;
    private final float loadFactor;

    public ObjIntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        int capacity = 1;
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new ObjIntMapEntry[capacity];
    }

    public ObjIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ObjIntHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new ObjIntMapEntry[16];
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        ObjIntMapEntry<V>[] objIntMapEntryArray = this.table;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            ObjIntMapEntry<V> vEntry;
            ObjIntMapEntry<V> e = vEntry = objIntMapEntryArray[n2];
            while (e != null) {
                Object key = e.key;
                int value = e.getValue();
                buf.append(key).append("=").append(value);
                e = e.next;
            }
            ++n2;
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    static int hash(Object key) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = key.hashCode();
            n = h ^ h >>> 16;
        }
        return n;
    }

    @Override
    public Integer get(V key) {
        int i = ObjIntHashMap.hash(key) & this.table.length - 1;
        ObjIntMapEntry<V> e = this.table[i];
        while (e != null) {
            if (key.equals(e.key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(V key) {
        int i = ObjIntHashMap.hash(key) & this.table.length - 1;
        ObjIntMapEntry<V> e = this.table[i];
        while (e != null) {
            if (key.equals(e.key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public Integer put(V key, int value) {
        int i = ObjIntHashMap.hash(key) & this.table.length - 1;
        ObjIntMapEntry<V> e = this.table[i];
        while (e != null) {
            if (key.equals(e.key)) {
                int oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        this.addEntry(key, value, i);
        return null;
    }

    private void putForCreate(V key, int value) {
        int i = ObjIntHashMap.hash(key) & this.table.length - 1;
        ObjIntMapEntry<V> e = this.table[i];
        while (e != null) {
            if (key.equals(e.key)) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(key, value, i);
    }

    private void resize(int newCapacity) {
        ObjIntMapEntry<V>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        ObjIntMapEntry[] newTable = new ObjIntMapEntry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    private void transfer(ObjIntMapEntry<V>[] newTable) {
        ObjIntMapEntry<V>[] src = this.table;
        int newCapacity = newTable.length;
        int j = 0;
        while (j < src.length) {
            ObjIntMapEntry<V> e = src[j];
            if (e != null) {
                ObjIntMapEntry next;
                src[j] = null;
                do {
                    next = e.next;
                    int i = ObjIntHashMap.hash(e.key) & newCapacity - 1;
                    e.next = newTable[i];
                    newTable[i] = e;
                } while ((e = next) != null);
            }
            ++j;
        }
    }

    @Override
    public Integer remove(V key) {
        ObjIntMapEntry<V> e = this.removeEntryForKey(key);
        return e == null ? null : Integer.valueOf(e.value);
    }

    private ObjIntMapEntry<V> removeEntryForKey(V key) {
        ObjIntMapEntry<V> prev;
        int i = ObjIntHashMap.hash(key) & this.table.length - 1;
        ObjIntMapEntry<V> e = prev = this.table[i];
        while (e != null) {
            ObjIntMapEntry next = e.next;
            if (key.equals(e.key)) {
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    @Override
    public void clear() {
        ObjIntMapEntry<V>[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            tab[i] = null;
            ++i;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(int value) {
        ObjIntMapEntry<V>[] tab;
        ObjIntMapEntry<V>[] objIntMapEntryArray = tab = this.table;
        int n = tab.length;
        int n2 = 0;
        while (n2 < n) {
            ObjIntMapEntry<V> vEntry;
            ObjIntMapEntry<V> e = vEntry = objIntMapEntryArray[n2];
            while (e != null) {
                if (value == e.value) {
                    return true;
                }
                e = e.next;
            }
            ++n2;
        }
        return false;
    }

    private void addEntry(V key, int value, int bucketIndex) {
        this.table[bucketIndex] = new ObjIntMapEntry<V>(key, value, this.table[bucketIndex]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    private void createEntry(V key, int value, int bucketIndex) {
        this.table[bucketIndex] = new ObjIntMapEntry<V>(key, value, this.table[bucketIndex]);
        ++this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        int c = 0;
        int i = 0;
        while (c < this.size && i < this.table.length) {
            ObjIntMapEntry<V> e = this.table[i];
            while (e != null) {
                s.writeObject(e.key);
                s.writeInt(e.getValue());
                e = e.next;
                ++c;
            }
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new ObjIntMapEntry[numBuckets];
        int size = s.readInt();
        int i = 0;
        while (i < size) {
            Object key = s.readObject();
            int value = s.readInt();
            this.putForCreate(key, value);
            ++i;
        }
    }

    @Override
    public Iterator<ObjIntMapEntry<V>> iterator() {
        return new ObjIntHashMapEntryIterator();
    }

    private class ObjIntHashMapEntryIterator
    implements Iterator<ObjIntMapEntry<V>> {
        int index = -1;
        ObjIntMapEntry<V> cur = null;
        ObjIntMapEntry<V> next = null;

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                while (++this.index < ObjIntHashMap.this.table.length) {
                    this.next = ObjIntHashMap.this.table[this.index];
                    if (this.next != null) break;
                }
            }
            return this.next != null;
        }

        @Override
        public ObjIntMapEntry<V> next() {
            if (this.next == null) {
                if (this.hasNext()) {
                    return this.next();
                }
                throw new NoSuchElementException("No more entries");
            }
            this.cur = this.next;
            this.next = this.next.next;
            this.hasNext();
            return this.cur;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void remove() {
            block1: {
                if (this.index <= -1 || this.index >= ObjIntHashMap.access$0(ObjIntHashMap.this).length) break block1;
                curNode = ObjIntHashMap.access$0(ObjIntHashMap.this)[this.index];
                prev = null;
                if (this.cur == null) break block1;
                if (curNode != this.cur) ** GOTO lbl14
                ObjIntHashMap.access$0((ObjIntHashMap)ObjIntHashMap.this)[this.index] = this.cur.next;
                return;
lbl-1000:
                // 1 sources

                {
                    prev = curNode;
                    curNode = curNode.next;
                    if (curNode != this.cur) continue;
                    prev.next = curNode.next;
                    this.cur = null;
                    break;
lbl14:
                    // 2 sources

                    ** while (curNode != null)
                }
            }
        }
    }
}

