/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.commandline;

import com.wily.util.text.IStringLocalizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class CommandLinePrompt {
    private static final int kInvalidInteger = -1;
    private static final char kInvalidChar = '\u0000';
    private final LineNumberReader fInput;
    private final PrintWriter fOutput;
    private final IStringLocalizer fLocalizer;

    public CommandLinePrompt(InputStream input, PrintWriter output, IStringLocalizer localizer) {
        this.fInput = new LineNumberReader(new InputStreamReader(input));
        this.fOutput = output;
        this.fLocalizer = localizer;
    }

    private char readCharacter(char[] options) {
        try {
            char ch;
            String line = this.fInput.readLine();
            if (line != null && line.length() > 0 && this.linearSearch(options, ch = Character.toLowerCase(line.charAt(0))) >= 0) {
                return ch;
            }
        }
        catch (IOException iOException) {}
        return '\u0000';
    }

    private int linearSearch(char[] options, char ch) {
        if (options != null) {
            int i = 0;
            while (i < options.length) {
                if (options[i] == ch) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private int readInteger(int min, int max) {
        try {
            String line = this.fInput.readLine();
            int value = Integer.parseInt(line);
            if (value >= min && value <= max) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IOException iOException) {}
        return -1;
    }

    public char showPrompt(String localizedPrompt, char[] validResponses) {
        String[] arr = new String[]{localizedPrompt};
        return this.showPrompt(arr, validResponses);
    }

    public char showPrompt(String[] localizedPrompt, char[] validResponses) {
        if (localizedPrompt == null) {
            throw new IllegalArgumentException("a prompt must be specified");
        }
        if (validResponses == null || validResponses.length == 0) {
            throw new IllegalArgumentException("at least one response must be specified!");
        }
        char choice = '\u0000';
        int i = 0;
        while (i < validResponses.length) {
            validResponses[i] = Character.toLowerCase(validResponses[i]);
            ++i;
        }
        while (choice == '\u0000') {
            i = 0;
            while (i < localizedPrompt.length) {
                this.fOutput.print(localizedPrompt[i]);
                if (i < localizedPrompt.length - 1) {
                    this.fOutput.println();
                } else {
                    this.fOutput.print(" ");
                }
                ++i;
            }
            this.fOutput.flush();
            choice = this.readCharacter(validResponses);
        }
        return choice;
    }

    public int showPrompt(String promptKey, String[] optionKeys) {
        if (optionKeys == null || optionKeys.length == 0) {
            throw new IllegalArgumentException("at least one option must be specified!");
        }
        String locPrompt = this.fLocalizer.IStringLocalizer_getLocalizedString(promptKey);
        String[] locOptions = this.fLocalizer.IStringLocalizer_getLocalizedStrings(optionKeys);
        int choice = -1;
        int max = locOptions.length;
        String maxStr = String.valueOf(max);
        while (choice == -1) {
            this.fOutput.println(locPrompt);
            int i = 0;
            while (i < locOptions.length) {
                this.fOutput.println(String.valueOf(i + 1) + ". " + locOptions[i]);
                ++i;
            }
            this.fOutput.print("(1-" + maxStr + ")> ");
            this.fOutput.flush();
            choice = this.readInteger(1, max);
        }
        return choice - 1;
    }
}

