/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.metric.InternalException;
import com.wily.introscope.spec.metric.TypeInquisitor;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.gatherer.CumulativeCounterGatherer;
import com.wily.introscope.stat.gatherer.IGatherer;
import com.wily.introscope.stat.gatherer.IntegerAggregatingFluctuatingCounterGatherer;
import com.wily.introscope.stat.gatherer.IntegerAverageGatherer;
import com.wily.introscope.stat.gatherer.IntegerConstantGatherer;
import com.wily.introscope.stat.gatherer.IntegerFluctuatingCounterGatherer;
import com.wily.introscope.stat.gatherer.IntegerFluctuatingMaxGatherer;
import com.wily.introscope.stat.gatherer.IntegerFluctuatingMinGatherer;
import com.wily.introscope.stat.gatherer.IntegerMaxGatherer;
import com.wily.introscope.stat.gatherer.IntegerMonotonicallyIncreasingCounterGatherer;
import com.wily.introscope.stat.gatherer.IntegerSummingGatherer;
import com.wily.introscope.stat.gatherer.IntervalCounterGatherer;
import com.wily.introscope.stat.gatherer.LongAverageGatherer;
import com.wily.introscope.stat.gatherer.LongConstantGatherer;
import com.wily.introscope.stat.gatherer.LongFluctuatingCounterGatherer;
import com.wily.introscope.stat.gatherer.LongFluctuatingMaxGatherer;
import com.wily.introscope.stat.gatherer.LongFluctuatingMinGatherer;
import com.wily.introscope.stat.gatherer.LongMonotonicallyIncreasingCounterGatherer;
import com.wily.introscope.stat.gatherer.LongSummingGatherer;
import com.wily.introscope.stat.gatherer.RateGatherer;
import com.wily.introscope.stat.gatherer.StringConstantGatherer;
import com.wily.introscope.stat.gatherer.StringEveryEventGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import java.util.HashMap;
import java.util.Map;

public class GathererFactory {
    private static final int kPowerOfTwoForMapCount = 8;
    private static final int kMetricGroupMapCount = (int)Math.pow(2.0, 8.0);
    private static final int kMask = kMetricGroupMapCount - 1;
    public static Map[] BlameStackSnapshotCache = new HashMap[kMetricGroupMapCount];

    static {
        int i = 0;
        while (i < kMetricGroupMapCount) {
            GathererFactory.BlameStackSnapshotCache[i] = new HashMap();
            ++i;
        }
    }

    private GathererFactory() {
    }

    public static IGatherer newGathererByTypeSafe(int typeCookie, long when) {
        return GathererFactory.newGathererByType(typeCookie, when);
    }

    public static IGatherer newGathererByType(int typeCookie, long when, boolean dataIsInitiallyPresent, ATimeslicedValue initialValue) throws IncompatibleTypesException {
        return GathererFactory.newGathererByType(typeCookie, when);
    }

    public static IGatherer newGathererByType(int typeCookie, long when) {
        TypeInquisitor typeInfo = new TypeInquisitor(typeCookie);
        if (typeInfo.isConstant()) {
            if (typeInfo.isString()) {
                return new StringConstantGatherer(typeCookie, when);
            }
            if (typeInfo.isInteger()) {
                return new IntegerConstantGatherer(typeCookie, when);
            }
            if (typeInfo.isLong()) {
                return new LongConstantGatherer(typeCookie, when);
            }
            throw new InternalException("unsupported type in newGathererByType");
        }
        if (typeInfo.isInteger()) {
            if (typeInfo.isFluctuatingCounter()) {
                return typeInfo.isAdditiveAggregator() ? new IntegerAggregatingFluctuatingCounterGatherer(typeCookie, when) : new IntegerFluctuatingCounterGatherer(typeCookie, when);
            }
            if (typeInfo.isDuration() || typeInfo.isPercentage()) {
                return new IntegerAverageGatherer(typeCookie, when);
            }
            if (typeInfo.isRate()) {
                return new RateGatherer(typeCookie, when);
            }
            if (typeInfo.isSaturation()) {
                return new IntegerMaxGatherer(typeCookie, when);
            }
            if (typeInfo.isMonotonicallyIncreasingCounter() || typeInfo.isTimestamp()) {
                return new IntegerMonotonicallyIncreasingCounterGatherer(typeCookie, when);
            }
            throw new InternalException("unsupported changing integer type in newGathererByType");
        }
        if (typeInfo.isLong()) {
            if (typeInfo.isFluctuatingCounter()) {
                return new LongFluctuatingCounterGatherer(typeCookie, when);
            }
            if (typeInfo.isDuration() || typeInfo.isPercentage()) {
                return new LongAverageGatherer(typeCookie, when);
            }
            if (typeInfo.isIntervalCounter()) {
                return new IntervalCounterGatherer(typeCookie, when);
            }
            if (typeInfo.isMonotonicallyIncreasingCounter() || typeInfo.isTimestamp()) {
                return new LongMonotonicallyIncreasingCounterGatherer(typeCookie, when);
            }
            if (typeInfo.isCumulativeCounter()) {
                return new CumulativeCounterGatherer(typeCookie, when);
            }
            throw new InternalException("unsupported changing long type in newGathererByType");
        }
        if (typeInfo.isString()) {
            return new StringEveryEventGatherer(typeCookie, when);
        }
        throw new InternalException("unsupported changing type in newGathererByType");
    }

    public static IGatherer newTimeAggregatingGathererByType(int typeCookie, long when, boolean dataIsInitiallyPresent) {
        return GathererFactory.newTimeAggregatingGathererByType(typeCookie, when);
    }

    public static IGatherer newTimeAggregatingGathererByType(int typeCookie, long when) {
        TypeInquisitor typeInfo = new TypeInquisitor(typeCookie);
        if (typeInfo.isConstant()) {
            if (typeInfo.isString()) {
                return new StringConstantGatherer(typeCookie, when);
            }
            if (typeInfo.isInteger()) {
                return new IntegerConstantGatherer(typeCookie, when);
            }
            if (typeInfo.isLong()) {
                return new LongConstantGatherer(typeCookie, when);
            }
            throw new InternalException("unsupported type in newGathererByType");
        }
        if (typeInfo.isInteger()) {
            if (typeInfo.isFluctuatingCounter()) {
                return typeInfo.isTimeAggregatingByMin() ? new IntegerFluctuatingMinGatherer(typeCookie, when) : new IntegerFluctuatingMaxGatherer(typeCookie, when);
            }
            if (typeInfo.isDuration() || typeInfo.isPercentage()) {
                return new IntegerAverageGatherer(typeCookie, when);
            }
            if (typeInfo.isRate()) {
                return new RateGatherer(typeCookie, when);
            }
            if (typeInfo.isSaturation()) {
                return new IntegerMaxGatherer(typeCookie, when);
            }
            if (typeInfo.isMonotonicallyIncreasingCounter() || typeInfo.isTimestamp()) {
                return new IntegerMonotonicallyIncreasingCounterGatherer(typeCookie, when);
            }
            throw new InternalException("unsupported changing integer type in newGathererByType");
        }
        if (typeInfo.isLong()) {
            if (typeInfo.isFluctuatingCounter()) {
                return typeInfo.isTimeAggregatingByMin() ? new LongFluctuatingMinGatherer(typeCookie, when) : new LongFluctuatingMaxGatherer(typeCookie, when);
            }
            if (typeInfo.isDuration() || typeInfo.isPercentage()) {
                return new LongAverageGatherer(typeCookie, when);
            }
            if (typeInfo.isIntervalCounter()) {
                return new IntervalCounterGatherer(typeCookie, when);
            }
            if (typeInfo.isMonotonicallyIncreasingCounter() || typeInfo.isTimestamp()) {
                return new LongMonotonicallyIncreasingCounterGatherer(typeCookie, when);
            }
            if (typeInfo.isCumulativeCounter()) {
                return new CumulativeCounterGatherer(typeCookie, when);
            }
            throw new InternalException("unsupported changing long type in newGathererByType");
        }
        if (typeInfo.isString()) {
            return new StringEveryEventGatherer(typeCookie, when);
        }
        throw new InternalException("unsupported changing type in newGathererByType");
    }

    public static IGatherer newSpaceAggregatingGathererByType(int typeCookie, long when, boolean dataIsInitiallyPresent) throws IncompatibleTypesException {
        return GathererFactory.newSpaceAggregatingGathererByType(typeCookie, when);
    }

    public static IGatherer newSpaceAggregatingGathererByType(int typeCookie, long when) {
        TypeInquisitor typeInfo = new TypeInquisitor(typeCookie);
        if (typeInfo.isConstant()) {
            if (typeInfo.isString()) {
                return new StringConstantGatherer(typeCookie, when);
            }
            if (typeInfo.isInteger()) {
                return new IntegerConstantGatherer(typeCookie, when);
            }
            if (typeInfo.isLong()) {
                return new LongConstantGatherer(typeCookie, when);
            }
            throw new InternalException("unsupported constant type in newGathererByType");
        }
        if (typeInfo.isInteger()) {
            if (typeInfo.isFluctuatingCounter()) {
                return new IntegerSummingGatherer(typeCookie, when);
            }
            if (typeInfo.isDuration() || typeInfo.isPercentage()) {
                return new IntegerAverageGatherer(typeCookie, when);
            }
            if (typeInfo.isRate()) {
                return new RateGatherer(typeCookie, when);
            }
            if (typeInfo.isSaturation()) {
                return new IntegerMaxGatherer(typeCookie, when);
            }
            if (typeInfo.isMonotonicallyIncreasingCounter() || typeInfo.isTimestamp()) {
                return new IntegerSummingGatherer(typeCookie, when);
            }
            throw new InternalException("unsupported changing integer type in newGathererByType");
        }
        if (typeInfo.isLong()) {
            if (typeInfo.isFluctuatingCounter()) {
                return new LongSummingGatherer(typeCookie, when);
            }
            if (typeInfo.isDuration() || typeInfo.isPercentage()) {
                return new LongAverageGatherer(typeCookie, when);
            }
            if (typeInfo.isIntervalCounter()) {
                return new IntervalCounterGatherer(typeCookie, when);
            }
            if (typeInfo.isMonotonicallyIncreasingCounter() || typeInfo.isTimestamp()) {
                return new LongMonotonicallyIncreasingCounterGatherer(typeCookie, when);
            }
            throw new InternalException("unsupported changing long type in newGathererByType");
        }
        if (typeInfo.isString()) {
            return new StringEveryEventGatherer(typeCookie, when);
        }
        throw new InternalException("unsupported changing type in newGathererByType");
    }

    private static IMetricDataValue genericAggregateByTime(IMetricDataValue value1, IMetricDataValue value2) throws IncompatibleTypesException {
        IGatherer gatherer = GathererFactory.newTimeAggregatingGathererByType(value1.getType(), value1.getStartTimestampInMillis());
        gatherer.acceptValueNonSync(value1);
        gatherer.acceptValueNonSync(value2);
        IMetricDataValue result = gatherer.harvestAndAbandonNonSync(value2.getStopTimestampInMillis());
        return result;
    }

    private static IMetricDataValue genericAggregateBySpace(IMetricDataValue value1, IMetricDataValue value2) throws IncompatibleTypesException {
        IGatherer gatherer = GathererFactory.newSpaceAggregatingGathererByType(value1.getType(), value1.getStartTimestampInMillis());
        gatherer.acceptValueNonSync(value1);
        gatherer.acceptValueNonSync(value2);
        IMetricDataValue result = gatherer.harvestAndAbandonNonSync(value2.getStopTimestampInMillis());
        return result;
    }

    public static IMetricDataValue aggregateBySpace(IMetricDataValue value1, IMetricDataValue value2) throws IncompatibleTypesException {
        return GathererFactory.genericAggregateBySpace(value1, value2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IMetricDataValue aggregateByTime(IMetricDataValue value1, IMetricDataValue value2) throws IncompatibleTypesException {
        TypeInquisitor typeInfo = new TypeInquisitor(value1.getType());
        if (typeInfo.isConstant()) {
            if (typeInfo.isString()) {
                return GathererFactory.genericAggregateByTime(value1, value2);
            }
            if (typeInfo.isInteger()) {
                return GathererFactory.genericAggregateByTime(value1, value2);
            }
            if (!typeInfo.isLong()) throw new InternalException("unsupported type in newGathererByType");
            return GathererFactory.genericAggregateByTime(value1, value2);
        }
        if (typeInfo.isInteger()) {
            if (typeInfo.isFluctuatingCounter()) {
                if (!typeInfo.isTimeAggregatingByMin()) return IntegerFluctuatingMaxGatherer.aggregateByTime(value1, value2);
                return IntegerFluctuatingMinGatherer.aggregateByTime(value1, value2);
            }
            if (typeInfo.isDuration()) return IntegerAverageGatherer.aggregateByTime(value1, value2);
            if (typeInfo.isPercentage()) {
                return IntegerAverageGatherer.aggregateByTime(value1, value2);
            }
            if (typeInfo.isRate()) {
                return RateGatherer.aggregateByTime(value1, value2);
            }
            if (typeInfo.isSaturation()) {
                return IntegerMaxGatherer.aggregateByTime(value1, value2);
            }
            if (typeInfo.isMonotonicallyIncreasingCounter()) return GathererFactory.genericAggregateByTime(value1, value2);
            if (!typeInfo.isTimestamp()) throw new InternalException("unsupported changing integer type in newGathererByType");
            return GathererFactory.genericAggregateByTime(value1, value2);
        }
        if (typeInfo.isLong()) {
            if (typeInfo.isMonotonicallyIncreasingCounter()) return GathererFactory.genericAggregateByTime(value1, value2);
            if (typeInfo.isTimestamp()) {
                return GathererFactory.genericAggregateByTime(value1, value2);
            }
            if (typeInfo.isFluctuatingCounter()) {
                if (!typeInfo.isTimeAggregatingByMin()) return LongFluctuatingMaxGatherer.aggregateByTime(value1, value2);
                return LongFluctuatingMinGatherer.aggregateByTime(value1, value2);
            }
            if (typeInfo.isDuration()) return LongAverageGatherer.aggregateByTime(value1, value2);
            if (typeInfo.isPercentage()) {
                return LongAverageGatherer.aggregateByTime(value1, value2);
            }
            if (!typeInfo.isIntervalCounter()) throw new InternalException("unsupported changing long type in newGathererByType");
            return IntervalCounterGatherer.aggregateByTime(value1, value2);
        }
        if (!typeInfo.isString()) throw new InternalException("unsupported changing type in newGathererByType");
        return GathererFactory.genericAggregateByTime(value1, value2);
    }

    public static Map getBlameStackSnapshotCache(String key) {
        int index = GathererFactory.getIndex(key);
        return BlameStackSnapshotCache[index];
    }

    public static int getIndex(String key) {
        int index = key.hashCode() >> 3 & kMask;
        return index;
    }
}

