/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.preflight.modules;

import com.wily.util.preflight.KPreflightErrorMessages;

public final class LibraryDescriptor
implements KPreflightErrorMessages {
    private final String[] fClassNameList;
    private final String fErrorMessage;
    private static final LibraryDescriptor kXercesDescriptor = new LibraryDescriptor("org.apache.xerces.parsers.DOMParser", "Cannot find the Xerces library.");
    private static final LibraryDescriptor kXalanDescriptor = new LibraryDescriptor("org.apache.xalan.Version", "Cannot find the Xalan library.");
    private static final LibraryDescriptor kXMLAPIsDescriptor = new LibraryDescriptor("javax.xml.parsers.DocumentBuilder", "Cannot find the XML APIs library.");
    private static final LibraryDescriptor kJChart4Descriptor = new LibraryDescriptor("com.klg.jclass.chart.JCChart", "Cannot find the JCChart library.");
    private static final LibraryDescriptor kSwingDescriptor = new LibraryDescriptor("javax.swing.JComponent", "Cannot find the Swing library.  Swing is a standard part of Java 1.2.");
    private static final LibraryDescriptor kJavaMailDescriptor = new LibraryDescriptor("javax.mail.Message", "Cannot find the JavaMail library.");
    private static final LibraryDescriptor kJHotDrawDescriptor = new LibraryDescriptor("CH.ifa.draw.framework.Drawing", "Cannot find the JHotDraw library.");

    public LibraryDescriptor(String className, String errorMessage) {
        this.fClassNameList = new String[]{className};
        this.fErrorMessage = errorMessage;
    }

    public LibraryDescriptor(String[] classNames, String errorMessage) {
        this.fClassNameList = new String[classNames.length];
        System.arraycopy(classNames, 0, this.fClassNameList, 0, classNames.length);
        this.fErrorMessage = errorMessage;
    }

    public int getRepresentativeClassNameCount() {
        return this.fClassNameList.length;
    }

    public String getRepresentativeClassNameAtIndex(int i) {
        return this.fClassNameList[i];
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public static final LibraryDescriptor getXercesDescriptor() {
        return kXercesDescriptor;
    }

    public static final LibraryDescriptor getXalanDescriptor() {
        return kXalanDescriptor;
    }

    public static final LibraryDescriptor getXMLAPIsDescriptor() {
        return kXMLAPIsDescriptor;
    }

    public static final LibraryDescriptor getJChart4Descriptor() {
        return kJChart4Descriptor;
    }

    public static final LibraryDescriptor getSwingDescriptor() {
        return kSwingDescriptor;
    }

    public static final LibraryDescriptor getJavaMailDescriptor() {
        return kJavaMailDescriptor;
    }

    public static final LibraryDescriptor getJHotDrawDescriptor() {
        return kJHotDrawDescriptor;
    }
}

