/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.jmx.JMXDelegatingService;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class RateCounterJMXDataView
extends AJMXDataView {
    private ILongIntervalCounterDataAccumulator fAccumulator;
    private String fFullIntroscopeMetricName;
    private long fPreviousValue;
    private long fPreviousDeltaValue;

    public RateCounterJMXDataView(IAgent agent, ObjectName on, MBeanServer server, String attributeName, String fullIntroscopeMetricName, Object attKey) {
        super(agent, on, server, attributeName, attKey);
        this.fFullIntroscopeMetricName = fullIntroscopeMetricName;
        this.fPreviousValue = 0L;
        this.fPreviousDeltaValue = 0L;
    }

    @Override
    protected void doUpdate(Object currentValue) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        Number numberValue;
        if (currentValue instanceof Attribute) {
            Attribute att = (Attribute)currentValue;
            numberValue = (Number)att.getValue();
        } else {
            numberValue = (Number)currentValue;
        }
        long longValue = numberValue.longValue();
        long deltaValue = longValue - this.fPreviousValue;
        ILongIntervalCounterDataAccumulator accumulator = (ILongIntervalCounterDataAccumulator)this.getAccumulator(true);
        if (accumulator != null) {
            if (JMXDelegatingService.sIsJMXRateCounterResetEnabled) {
                if (deltaValue < 0L) {
                    accumulator.ILongIntervalCounterDataAccumulator_addBatchIncidents(Math.max(this.fPreviousDeltaValue, longValue));
                } else {
                    accumulator.ILongIntervalCounterDataAccumulator_addBatchIncidents(deltaValue);
                    this.fPreviousDeltaValue = deltaValue;
                }
            } else {
                accumulator.ILongIntervalCounterDataAccumulator_addBatchIncidents(deltaValue);
            }
            this.getAgent().IAgent_getModuleFeedback().debug("Reporting interval: " + this.fFullIntroscopeMetricName);
            this.getAgent().IAgent_getModuleFeedback().debug(new StringBuffer().append("New: ").append(longValue).append(" Old: ").append(this.fPreviousValue).append(" deltaValue: ").append(deltaValue).toString());
            this.fPreviousValue = longValue;
        }
    }

    @Override
    protected IDataAccumulator getAccumulator(boolean forceCreate) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        if (forceCreate && this.fAccumulator == null) {
            this.fAccumulator = this.getAgent().IAgent_getDataAccumulatorFactory().createLongIntervalCounterDataAccumulator(this.fFullIntroscopeMetricName);
        }
        return this.fAccumulator;
    }

    @Override
    protected void doDestroy() {
        try {
            if (this.fAccumulator != null) {
                this.getAgent().IAgent_getDataAccumulatorFactory().removeDataAccumulator((IDataAccumulator)this.fAccumulator);
            }
        }
        finally {
            this.fAccumulator = null;
            this.decrementJMXClampMetricCounter();
        }
    }

    @Override
    public String getFullMetricName() {
        return this.fFullIntroscopeMetricName;
    }
}

