/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.gcmonitor.instrumentation;

import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.gcmonitor.instrumentation.ApplicationException;
import com.wily.introscope.gcmonitor.instrumentation.Collector;
import com.wily.introscope.gcmonitor.metricpublisher.MetricPublisher;
import com.wily.introscope.gcmonitor.metricpublisher.MetricPublisherFactory;
import com.wily.introscope.gcmonitor.ui.Messages;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.MetricNotFoundException;
import java.lang.management.GarbageCollectorMXBean;
import java.util.ArrayList;

public class GCCollector
implements Collector {
    protected MetricPublisher metricPublisher = null;
    private GarbageCollectorMXBean fCollectorMXBean;
    private long count;
    private long time;
    private String fCountMetricName;
    private String fTimeMetricName;
    private String fGCAlgorithm;
    private String fGCAlgorithmName;
    private ArrayList<String> fMetricNames = null;

    public GCCollector(GarbageCollectorMXBean bean) {
        this.initPublisher();
        this.fCollectorMXBean = bean;
        if (bean != null) {
            this.fGCAlgorithmName = bean.getName();
            this.init();
        }
    }

    @Override
    public boolean init() {
        String metricPrefix = this.generateName();
        this.fGCAlgorithm = String.valueOf(metricPrefix) + this.getString("GCMonitorTypeViewer.CollectorAlgorithm");
        this.fCountMetricName = String.valueOf(metricPrefix) + this.getString("GCMonitorTypeViewer.CollectionCount");
        this.fTimeMetricName = String.valueOf(metricPrefix) + this.getString("GCMonitorTypeViewer.CollectionTime");
        this.fMetricNames = new ArrayList();
        return true;
    }

    @Override
    public void publishMetricValues() {
        if (this.fCollectorMXBean != null) {
            this.count = this.fCollectorMXBean.getCollectionCount();
            this.time = this.fCollectorMXBean.getCollectionTime();
            this.metricPublisher.publish(this.fGCAlgorithm, this.fGCAlgorithmName);
            if (!this.fMetricNames.contains(this.fGCAlgorithm)) {
                this.fMetricNames.add(this.fGCAlgorithm);
            }
            this.metricPublisher.publish(this.fCountMetricName, this.count);
            if (!this.fMetricNames.contains(this.fCountMetricName)) {
                this.fMetricNames.add(this.fCountMetricName);
            }
            this.metricPublisher.publish(this.fTimeMetricName, this.time);
            if (!this.fMetricNames.contains(this.fTimeMetricName)) {
                this.fMetricNames.add(this.fTimeMetricName);
            }
        }
    }

    private String generateName() {
        String metricName = "";
        String rootNode = this.getString("GCMonitorTypeViewer.RootNode");
        metricName = String.valueOf(rootNode) + "|" + this.getString("GCMonitorTypeViewer.CollectorsNode") + "|" + this.fGCAlgorithmName + ":";
        return metricName;
    }

    @Override
    public void turnOffMetrics(DataAccumulatorFactory factory) throws ApplicationException {
        if (this.fMetricNames != null && this.fMetricNames.size() != 0) {
            ArrayList<String> metricsTobeRemoved = new ArrayList<String>();
            for (String metricName : this.fMetricNames) {
                metricsTobeRemoved.add(metricName);
            }
            for (String metric : metricsTobeRemoved) {
                try {
                    factory.removeMetric(metric);
                    this.fMetricNames.remove(metric);
                }
                catch (BadlyFormedNameException e) {
                    throw new ApplicationException(e);
                }
                catch (MetricNotFoundException e) {
                    throw new ApplicationException(e);
                }
            }
        }
    }

    protected String getString(String key) {
        return Messages.getString(key);
    }

    protected void initPublisher() {
        this.metricPublisher = MetricPublisherFactory.getInstance().getMetricPublisher();
    }

    protected int getMetricNamesSize() {
        return this.fMetricNames.size();
    }

    public String getfGCAlgorithmName() {
        return this.fGCAlgorithmName;
    }
}

