/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.gcmonitor.metricpublisher.agent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.IStringConstantDataAccumulator;
import com.wily.introscope.gcmonitor.metricpublisher.MetricPublisher;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.MetricNotFoundException;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.BlameHandlingGatherer;
import com.wily.introscope.stat.gatherer.IntegerAverageGatherer;
import com.wily.introscope.stat.gatherer.LongAverageGatherer;

public class AgentMetricPublisher
implements MetricPublisher {
    private DataAccumulatorFactory accumulatorFactory = null;
    private ILongFluctuatingCounterDataAccumulator longAverageCounterDataAccumulator = null;
    private IStringConstantDataAccumulator stringDataAccumulator = null;
    private IIntegerAverageDataAccumulator integerAverageDataAccumulator = null;

    public AgentMetricPublisher(IAgent agent) {
        this.accumulatorFactory = agent.IAgent_getDataAccumulatorFactory();
    }

    @Override
    public void publish(String metricName, long value) {
        this.longAverageCounterDataAccumulator = this.accumulatorFactory.safeGetLongFluctuatingCounterDataAccumulator(metricName);
        this.longAverageCounterDataAccumulator.ILongCounterDataAccumulator_setValue(value);
    }

    @Override
    public void publish(String metricName, String value) {
        this.stringDataAccumulator = this.accumulatorFactory.safeGetStringConstantDataAccumulator(metricName, value);
        this.stringDataAccumulator.IStringConstantDataAccumulator_getStringValue();
    }

    @Override
    public void publish(String metricName, int value) {
        this.integerAverageDataAccumulator = this.accumulatorFactory.safeGetIntegerPercentageDataAccumulator(metricName);
        this.integerAverageDataAccumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(value);
    }

    public void removeMetric() {
        try {
            this.accumulatorFactory.removeMetric("");
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
        }
        catch (MetricNotFoundException metricNotFoundException) {}
    }

    public DataAccumulatorFactory getAccumulatorFactory() {
        return this.accumulatorFactory;
    }

    public void setAccumulatorFactory(DataAccumulatorFactory accumulatorFactory) {
        this.accumulatorFactory = accumulatorFactory;
    }

    public long getLongAccumulatorValue() {
        if (this.longAverageCounterDataAccumulator != null) {
            return ((LongAverageGatherer)((BlameHandlingGatherer)this.longAverageCounterDataAccumulator.IDataAccumulator_getGatherer()).getGathererForBlameStackSnapshot(BlameStackSnapshot.kEmptyBlameStackSnapshot)).getLongValue();
        }
        return 0L;
    }

    public int getIntAccumulatorValue() {
        if (this.integerAverageDataAccumulator != null) {
            return ((IntegerAverageGatherer)((BlameHandlingGatherer)this.integerAverageDataAccumulator.IDataAccumulator_getGatherer()).getGathererForBlameStackSnapshot(BlameStackSnapshot.kEmptyBlameStackSnapshot)).getIntValue();
        }
        return 0;
    }

    public String getStringAccumulatorValue() {
        if (this.stringDataAccumulator != null) {
            return this.stringDataAccumulator.IStringConstantDataAccumulator_getStringValue();
        }
        return "";
    }

    public String getGCAlgorithmName(String metricName) {
        if (this.stringDataAccumulator != null) {
            return this.stringDataAccumulator.IStringConstantDataAccumulator_getStringValue();
        }
        return null;
    }
}

