/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension.deployer;

import com.wily.introscope.agent.extension.deployer.DeploymentManager;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class DeploymentLock {
    private final DeploymentManager fManager;
    private final Module kModule;
    private final IModuleFeedbackChannel fFeedback;
    private FileChannel fLockChannel;
    private FileLock fLock;

    DeploymentLock(DeploymentManager manager) {
        this.fManager = manager;
        this.kModule = this.fManager.getModule();
        this.fFeedback = this.fManager.getFeedback();
    }

    public boolean initialize() {
        ExtendedFile deployDir = this.fManager.getDeployDirectory();
        ExtendedFile lockFile = new ExtendedFile(deployDir + File.separator + ".lock");
        return this.initialize(lockFile);
    }

    public boolean initializeProfileLock() {
        ExtendedFile deployDir = this.fManager.getDeployDirectory();
        ExtendedFile lockFile = new ExtendedFile(deployDir + File.separator + ".lockProfile");
        return this.initialize(lockFile);
    }

    public boolean initialize(ExtendedFile lockFile) {
        block5: {
            try {
                this.fLockChannel = new RandomAccessFile(lockFile.getFile(), "rw").getChannel();
                if (this.fLockChannel == null) {
                    this.fFeedback.error(this.kModule, "Cannot create the lock file in " + lockFile.getAbsolutePath() + ". Please enable write permissions to this folder for extension deployer to work.");
                }
            }
            catch (FileNotFoundException e) {
                this.fFeedback.error(this.kModule, "Cannot create the lock file in " + lockFile.getAbsolutePath() + " : " + e.getMessage());
                if (this.fFeedback.isDebugEnabled(this.kModule)) {
                    this.fFeedback.debug(this.kModule, "Cannot create the lock file", (Throwable)e);
                }
            }
            catch (Exception e) {
                this.fFeedback.error(this.kModule, "Cannot create the lock file in " + lockFile.getAbsolutePath() + " : " + e.getMessage());
                if (!this.fFeedback.isDebugEnabled(this.kModule)) break block5;
                this.fFeedback.debug(this.kModule, "Cannot create the lock file", (Throwable)e);
            }
        }
        return this.fLockChannel != null;
    }

    public void acquireExclusiveLock() {
        block2: {
            try {
                this.fLock = this.fLockChannel.lock();
            }
            catch (IOException e) {
                this.fFeedback.error(this.kModule, "Cannot acquire the deployment exclusive lock: " + e.getMessage());
                if (!this.fFeedback.isDebugEnabled(this.kModule)) break block2;
                this.fFeedback.debug(this.kModule, "Cannot acquire the deployment exclusive lock.", (Throwable)e);
            }
        }
    }

    public void acquireSharedLock() {
        block2: {
            try {
                this.fLock = this.fLockChannel.lock(0L, Long.MAX_VALUE, true);
            }
            catch (IOException e) {
                this.fFeedback.error(this.kModule, "Cannot acquire the deployment shared lock: " + e.getMessage());
                if (!this.fFeedback.isDebugEnabled(this.kModule)) break block2;
                this.fFeedback.debug(this.kModule, "Cannot acquire the deployment shared lock.", (Throwable)e);
            }
        }
    }

    public FileLock trySharedLock() {
        block2: {
            try {
                this.fLock = this.fLockChannel.tryLock(0L, Long.MAX_VALUE, true);
            }
            catch (IOException e) {
                this.fFeedback.error(this.kModule, "Cannot try the deployment shared lock: " + e.getMessage());
                if (!this.fFeedback.isDebugEnabled(this.kModule)) break block2;
                this.fFeedback.debug(this.kModule, "Cannot try the deployment shared lock.", (Throwable)e);
            }
        }
        return this.fLock;
    }

    public FileLock tryExclusiveLock() {
        block2: {
            try {
                this.fLock = this.fLockChannel.tryLock(0L, Long.MAX_VALUE, false);
            }
            catch (IOException e) {
                this.fFeedback.error(this.kModule, "Cannot try the deployment exclusive lock: " + e.getMessage());
                if (!this.fFeedback.isDebugEnabled(this.kModule)) break block2;
                this.fFeedback.debug(this.kModule, "Cannot try the deployment exclusive lock.", (Throwable)e);
            }
        }
        return this.fLock;
    }

    public boolean hasLock() {
        return this.fLock != null;
    }

    public boolean isLockValid() {
        return this.fLock.isValid();
    }

    public void releaseLock() {
        block3: {
            if (this.fLock != null) {
                try {
                    this.fLock.release();
                }
                catch (IOException e) {
                    this.fFeedback.error(this.kModule, "Cannot release the deployment lock: " + e.getMessage());
                    if (!this.fFeedback.isDebugEnabled(this.kModule)) break block3;
                    this.fFeedback.debug(this.kModule, "Cannot release the deployment lock.", (Throwable)e);
                }
            }
        }
    }

    public void closeLock() {
        block2: {
            try {
                this.fLockChannel.close();
            }
            catch (IOException e) {
                this.fFeedback.error(this.kModule, "Cannot release the deployment lock: " + e.getMessage());
                if (!this.fFeedback.isDebugEnabled(this.kModule)) break block2;
                this.fFeedback.debug(this.kModule, "Cannot release the deployment lock.", (Throwable)e);
            }
        }
    }
}

