/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension.deployer;

import com.wily.introscope.agent.extension.deployer.DeploymentLock;
import com.wily.introscope.agent.extension.deployer.DeploymentManager;
import com.wily.introscope.agent.extension.deployer.IDeploymentWatcher;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class DeploymentWatcher
implements Runnable,
IDeploymentWatcher {
    private DeploymentManager fManager;
    private Module kModule;
    private IModuleFeedbackChannel fFeedback;
    private ExtendedFile fExtensionsDir;
    private ExtendedFile fDeploymentDir;
    private WatchService fWatcher;
    private Path fExtensionProfile;
    private WatchService fProfileWatcher;
    private long fProfileWatcherStamp = 0L;

    @Override
    public void start(DeploymentManager manager) {
        try {
            this.fManager = manager;
            this.kModule = this.fManager.getModule();
            this.fFeedback = this.fManager.getFeedback();
            this.fExtensionsDir = this.fManager.getExtensionDirectory();
            this.fDeploymentDir = this.fManager.getDeployDirectory();
            this.fExtensionProfile = FileSystems.getDefault().getPath(this.fManager.getExtensionProfileResource().IResource_getLocation(), new String[0]);
            this.fWatcher = FileSystems.getDefault().newWatchService();
            Path deployDir = FileSystems.getDefault().getPath(this.fDeploymentDir.getAbsolutePath(), new String[0]);
            deployDir.register(this.fWatcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            this.fProfileWatcher = FileSystems.getDefault().newWatchService();
            Path extensionProfileDir = FileSystems.getDefault().getPath(this.fExtensionsDir.getAbsolutePath(), new String[0]);
            extensionProfileDir.register(this.fProfileWatcher, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException e) {
            this.fFeedback.error(this.kModule, "Failed to create filesystem watcher service: " + e.getMessage());
            this.fFeedback.debug(this.kModule, "Watcher creation failed", (Throwable)e);
            return;
        }
        Thread t = new Thread((Runnable)this, "Deployment Watcher");
        t.setDaemon(true);
        t.start();
        Thread t2 = new Thread(new Runnable(){

            @Override
            public void run() {
                DeploymentWatcher.this.profileWatcherRun();
            }
        }, "Extension Profile Watcher");
        t2.setDaemon(true);
        t2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void profileWatcherRun() {
        if (this.fProfileWatcher == null) {
            return;
        }
        while (true) {
            try {
                block9: while (true) {
                    WatchKey key = this.fProfileWatcher.take();
                    boolean fileChanged = false;
                    Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            long now;
                            key.reset();
                            if (!fileChanged || this.fProfileWatcherStamp >= (now = System.currentTimeMillis())) continue block9;
                            DeploymentLock deploymentLock = this.fManager.getProfileLock();
                            synchronized (deploymentLock) {
                                try {
                                    this.fManager.getProfileLock().acquireSharedLock();
                                    this.fFeedback.info(this.kModule, "Notifying ConfigurationWatcher.");
                                    this.fManager.notifyConfigurationWatcher();
                                    this.fProfileWatcherStamp = now + this.fManager.getProfileCheckInterval();
                                }
                                finally {
                                    this.fManager.getProfileLock().releaseLock();
                                }
                                continue block9;
                            }
                        }
                        WatchEvent<?> event = iterator.next();
                        WatchEvent.Kind<?> kind = event.kind();
                        WatchEvent<?> ev = event;
                        Path fileName = (Path)ev.context();
                        this.fFeedback.debug(this.kModule, "ProfileWatcher noticed " + kind.name() + ": " + fileName.getFileName());
                        if (!fileName.getFileName().equals(this.fExtensionProfile.getFileName())) continue;
                        fileChanged = true;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException v0) {}
        try {
            while (true) {
                block17: {
                    try {
                        while (true) {
                            key = this.fWatcher.poll(30L, TimeUnit.SECONDS);
                            fileChanged = false;
                            if (key == null) break block17;
                            for (WatchEvent<?> event : key.pollEvents()) {
                                kind = event.kind();
                                ev = event;
                                fileName = (Path)ev.context();
                                if (fileName.toString().endsWith(".tar.gz")) {
                                    fileChanged = true;
                                    this.fFeedback.info(this.kModule, "Noticed " + kind.name() + ": " + fileName.getFileName());
                                    continue;
                                }
                                this.fFeedback.debug(this.kModule, "Noticed " + kind.name() + ": " + fileName.getFileName());
                            }
                            key.reset();
                            if (fileChanged) ** GOTO lbl35
                        }
lbl-1000:
                        // 1 sources

                        {
                            key = this.fWatcher.poll(1L, TimeUnit.SECONDS);
                            if (key == null) continue;
                            var3_6 = key.pollEvents().iterator();
                            while (var3_6.hasNext()) {
                                var3_6.next();
                            }
                            key.reset();
lbl35:
                            // 3 sources

                            ** while (key != null)
                        }
lbl36:
                        // 1 sources

                    }
                    catch (InterruptedException v1) {}
                }
                this.fManager.checkFilesAndDeploy(false);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.fFeedback.error(this.kModule, "Error occured in Extension Deployer, the feature is disabled: " + t.getMessage());
                if (this.fFeedback.isDebugEnabled(this.kModule)) {
                    this.fFeedback.debug(this.kModule, "Extension Deployer Thread uncaught exception: ", t);
                }
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable v2) {}
            return;
        }
    }
}

