/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.jmx.IntJMXDataView;
import com.wily.introscope.agent.jmx.StringJMXDataView;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class CustomOperationJMXDataView
extends AJMXDataView {
    private IStringEveryEventDataAccumulator fAccumulator;
    private String fullIntroscopeMetricName;
    private String fLastValue = null;
    private String fCurrentValue = null;
    private boolean fWasSame = false;
    private AJMXDataView wrappedView = null;
    private OperationAction action = null;
    private volatile boolean considerBooleanInt = false;

    public CustomOperationJMXDataView(IAgent agent, ObjectName objectName, MBeanServer server, String attributeName, String fullIntroscopeMetricName, OperationAction action) {
        super(agent, objectName, server, attributeName, null);
        this.fullIntroscopeMetricName = fullIntroscopeMetricName;
        this.action = action;
        this.wrappedView = new IntJMXDataView(this.getAgent(), this.getSourceObjectName(), this.getSourceServer(), this.getSourceAttribute(), fullIntroscopeMetricName, null);
        this.considerBooleanInt = true;
    }

    private synchronized AJMXDataView getWrappedView(Object currentValue) {
        if (this.wrappedView == null) {
            if (this.isOnlyBoolean(currentValue)) {
                this.wrappedView = new IntJMXDataView(this.getAgent(), this.getSourceObjectName(), this.getSourceServer(), this.getSourceAttribute(), this.fullIntroscopeMetricName, null);
                this.considerBooleanInt = true;
            } else {
                this.wrappedView = new StringJMXDataView(this.getAgent(), this.getSourceObjectName(), this.getSourceServer(), this.getSourceAttribute(), this.fullIntroscopeMetricName, null);
            }
        }
        return this.wrappedView;
    }

    private boolean isOnlyBoolean(Object currentValue) {
        String str = currentValue != null ? currentValue.toString() : null;
        str = str != null ? str.toLowerCase().trim() : null;
        boolean res = false;
        if (str != null && (str.equals("true") || str.equals("false"))) {
            res = true;
        }
        return res;
    }

    @Override
    protected void doUpdate(Object currentValue) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        AJMXDataView view;
        if (currentValue != null && (view = this.getWrappedView(currentValue)) != null) {
            if (this.considerBooleanInt) {
                boolean res = Boolean.parseBoolean(currentValue.toString());
                currentValue = res ? new Integer(1) : new Integer(0);
            }
            view.doUpdate(currentValue);
        }
    }

    public String debug_GetCurrentAndLastValues() {
        return null;
    }

    @Override
    protected IDataAccumulator getAccumulator(boolean forceCreate) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.wrappedView.getAccumulator(forceCreate);
    }

    @Override
    protected void doDestroy() {
        this.wrappedView.doDestroy();
    }

    @Override
    public String getFullMetricName() {
        return this.wrappedView.getFullMetricName();
    }

    @Override
    protected Object getValue() throws Exception {
        Object value = this.action.doAction(this.getSourceObjectName(), this.getSourceServer());
        return value;
    }

    public static interface OperationAction {
        public Object doAction(ObjectName var1, MBeanServer var2) throws Exception;
    }

    public static class OperationActionOnItem
    implements OperationAction {
        String operation;
        String param;

        public OperationActionOnItem(String op, String param) {
            this.operation = op;
            this.param = param;
        }

        @Override
        public Object doAction(ObjectName objectName, MBeanServer server) throws Exception {
            Object value = server.invoke(objectName, this.operation, new String[]{this.param}, new String[]{String.class.getName()});
            return value;
        }
    }
}

