/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.wldf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.wldf.IWLDFDataView;
import com.wily.introscope.agent.wldf.IntWLDFDataView;
import com.wily.introscope.agent.wldf.LongWLDFDataView;
import com.wily.introscope.agent.wldf.StringWLDFDataView;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class DataViewFactory {
    static final int kIntViewType = 1;
    static final int kLongViewType = 2;
    static final int kStringViewType = 3;

    public static IWLDFDataView createView(IAgent agent, ObjectName mbeanName, String wldfAttributeType, String wldfAttributeName, MBeanServer server, String fullIntroscopeMetricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        if (wldfAttributeType == null) {
            return new StringWLDFDataView(agent, mbeanName, server, wldfAttributeName, fullIntroscopeMetricName);
        }
        int viewType = DataViewFactory.getViewType(wldfAttributeType);
        switch (viewType) {
            case 1: {
                return new IntWLDFDataView(agent, mbeanName, server, wldfAttributeName, fullIntroscopeMetricName);
            }
            case 2: {
                return new LongWLDFDataView(agent, mbeanName, server, wldfAttributeName, fullIntroscopeMetricName);
            }
        }
        return new StringWLDFDataView(agent, mbeanName, server, wldfAttributeName, fullIntroscopeMetricName);
    }

    public static int getViewType(String inputType) {
        String type = inputType.replace('/', '.');
        if (DataViewFactory.isLongType(type)) {
            return 2;
        }
        if (DataViewFactory.isIntType(type)) {
            return 1;
        }
        return 3;
    }

    private static boolean isLongType(String type) {
        return type.equals(Long.TYPE.getName()) || type.equals(Long.class.getName()) || type.equals(Double.TYPE.getName()) || type.equals(Double.class.getName()) || type.equals(Float.TYPE.getName()) || type.equals(Float.class.getName()) || type.equals(Number.class.getName());
    }

    private static boolean isIntType(String type) {
        return type.equals(Short.TYPE.getName()) || type.equals(Short.class.getName()) || type.equals(Integer.TYPE.getName()) || type.equals(Integer.class.getName()) || type.equals(Byte.TYPE.getName()) || type.equals(Byte.class.getName());
    }
}

