/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient;

import com.ca.apm.agent.jmxclient.ControlledErrorLogger;
import com.ca.apm.agent.jmxclient.Properties;
import com.ca.apm.agent.jmxclient.api.JmxMetricInfo;
import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;

public class Configuration {
    private static final Module MODULE = new Module("JMXClient");
    private static volatile Logger.ILoggingHandler logger = new Logger.NoOpLoggingHandler();
    private static volatile IAgent agent = null;

    static {
        try {
            agent = AgentShim.getAgent();
            logger = new Logger.LoggingHandler(MODULE, agent);
        }
        catch (AgentNotAvailableException e) {
            AgentShim.handleError((String)"Error while getting Agent instance for generic JMX", (Throwable)e);
        }
    }

    public static Logger.ILoggingHandler getLogger() {
        return logger;
    }

    public static Module getModule() {
        return logger.getModule();
    }

    public static IAgent getAgent() {
        return agent;
    }

    public static IndexedProperties getIndexedProperties() {
        return agent.IAgent_getIndexedProperties();
    }

    public static int getThreadPoolSizeFactor() {
        return 1;
    }

    private static long getIntervalValue(String p, float dv) {
        String sv = Configuration.getIndexedProperties().getTrimmedProperty(p);
        float v = sv == null ? dv : Float.parseFloat(sv);
        return (long)v;
    }

    public static long getDiscoveryIntervalMillis() {
        return Configuration.getIntervalValue("introscope.agent.remotejmx.reconnection.interval.seconds", 60.0f) * 1000L;
    }

    public static long getPollingIntervalMillis(JmxNodeInfo node) {
        JmxMetricInfo info = node.getMetricInfo();
        return info.getPollingInterval() > 0L ? info.getPollingInterval() * 1000L : Configuration.getDefaultPollingInterval() * 1000L;
    }

    public static long getDefaultPollingInterval() {
        return Configuration.getIntervalValue("introscope.agent.remotejmx.polling.interval.seconds", 15.0f);
    }

    public static boolean isSoftSyncEnabled() {
        return Configuration.getSoftSyncInterval() > 0L;
    }

    public static long getSoftSyncInterval() {
        return Configuration.getIndexedProperties().getLongProperty("introscope.agent.remotejmx.softConfigSync.interval.seconds", 60L);
    }

    public static boolean isHardSyncEnabled() {
        return Configuration.getHardSyncInterval() > 0L;
    }

    public static boolean isHardSyncEnabled(JmxNodeInfo node) {
        return Configuration.getHardSyncInterval(node) > 0L;
    }

    public static long getHardSyncInterval() {
        return Configuration.getIndexedProperties().getLongProperty("introscope.agent.remotejmx.configSync.interval.seconds", 0L);
    }

    public static long getHardSyncInterval(JmxNodeInfo node) {
        return node.getMetricInfo().getConfigSyncInterval() > 0L ? node.getMetricInfo().getConfigSyncInterval() : Configuration.getHardSyncInterval();
    }

    public static int getMaxJmxConnections() {
        return Configuration.getIndexedProperties().getIntProperty("introscope.agent.remotejmx.connections.max", 100);
    }

    public static int getInitialPoolSize() {
        return Configuration.getIndexedProperties().getIntProperty("introscope.agent.remotejmx.poller.threadPool.size.initial", 1);
    }

    public static int getMaxPoolSize() {
        return Configuration.getIndexedProperties().getIntProperty("introscope.agent.remotejmx.poller.threadPool.size.max", 1);
    }

    public static int getErrorLogClamp() {
        return Configuration.getIndexedProperties().getIntProperty("introscope.agent.remotejmx.error.clamp", 10);
    }

    public static boolean shouldBuildAtcMap() {
        return Configuration.getIndexedProperties().getBooleanProperty("introscope.agent.remotejmx.atcMap.enabled", true);
    }

    public static long getGraphSyncServiceInterval() {
        String ttl = Configuration.getIndexedProperties().getProperty("introscope.agent.remotejmx.atc.graphSync.interval");
        return ttl != null ? Long.valueOf(ttl) : 60000L;
    }

    public static long getGraphTimeToLive() {
        String ttl = Configuration.getIndexedProperties().getProperty("introscope.agent.remotejmx.atc.graphTtl");
        return ttl != null ? Long.valueOf(ttl) : 0x6DDD00L;
    }

    public static long geGraphResendInterval() {
        String ttl = Configuration.getIndexedProperties().getProperty("introscope.agent.remotejmx.atc.graphResend.interval");
        return ttl != null ? Long.valueOf(ttl) : 7140000L;
    }

    public static int geAtcHttpRequestTimeout() {
        return Configuration.getIndexedProperties().getIntProperty("introscope.agent.remotejmx.atc.httpRequest.timeout", 60);
    }

    public static String getDefaultMetricFormat() {
        return Configuration.getIndexedProperties().getProperty("introscope.agent.remotejmx.metricNamePattern", "{rootNode}|Default|{domain}|{properties}:{attribute}");
    }

    public static String getDefaultSpringActuatorMetricPrefixFormat() {
        return Configuration.getIndexedProperties().getProperty("introscope.agent.remotejmx.springboot.metricEndpoint.namePattern", "{rootNode}|Default|{domain}|{properties}");
    }

    public static String getDefaultWebsphereMetricPrefixFormat() {
        return Configuration.getIndexedProperties().getProperty("introscope.agent.remotejmx.websphere.listEndpoint.namePattern", Properties.JMX_SERVER_METRIC_NAME_PATTERN_WEBSPHERE_PROPERTY_DEFAULT_VALUE);
    }

    public static ControlledErrorLogger createErrorLoggerInstance() {
        return new ControlledErrorLogger(Configuration.getLogger(), Configuration.getErrorLogClamp());
    }

    public static DataAccumulatorFactory getAccumulatorFactory() {
        return Configuration.getAgent().IAgent_getDataAccumulatorFactory();
    }

    public static String getAgentName() {
        String[] triplet = Configuration.getAgent().IAgent_getHostProcessAgentTriplet();
        return String.valueOf(triplet[0]) + "|" + triplet[1] + "|" + triplet[2];
    }
}

