/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.environment;

import com.wily.util.WilyStringBuilder;
import java.lang.reflect.Array;

public class UnsignedByteArray {
    private static final FieldFormatter decimalFormatter = new FieldFormatter(){

        @Override
        public String toString(int i) {
            return Integer.toString(i);
        }
    };
    private static final FieldFormatter hexFormatter = new FieldFormatter(){

        @Override
        public String toString(int i) {
            return Integer.toHexString(i);
        }
    };
    private final byte[] bytes;

    public UnsignedByteArray(byte[] bytes) {
        this.bytes = bytes == null ? new byte[]{} : bytes;
    }

    public UnsignedByteArray(String str, int length, int bytesPerField, int maxFieldWidth, String separator, boolean isDecimal) throws IllegalArgumentException, NumberFormatException {
        if (length < 0 || bytesPerField < 0 || bytesPerField > 4 || maxFieldWidth < 1 || length % bytesPerField > 0 || str == null || separator == null || separator.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.bytes = new byte[length];
        int maxFields = length / bytesPerField;
        int maxValue = -1 >>> (4 - bytesPerField) * 8;
        int byteStart = 0;
        int fieldStart = 0;
        int fieldEnd = 0;
        int separatorLength = separator.length();
        boolean done = false;
        int nField = 0;
        while (nField < maxFields && !done) {
            fieldEnd = str.indexOf(separator, fieldStart);
            if (nField > 0 && fieldEnd == fieldStart) {
                int sepStart = fieldStart + separator.length();
                int strlen = str.length();
                int remainingSeparators = 0;
                while (sepStart < strlen) {
                    int nextSepStart = str.indexOf(separator, sepStart);
                    if (nextSepStart < 0) break;
                    ++remainingSeparators;
                    sepStart = nextSepStart + separatorLength;
                }
                int skippedFields = maxFields - nField - 1 - remainingSeparators;
                if (skippedFields < 1) {
                    throw new IllegalArgumentException();
                }
                byteStart += skippedFields * bytesPerField;
                fieldEnd = fieldStart;
            } else {
                int fieldInt;
                String field;
                int fieldLength;
                boolean bl = done = fieldEnd < 0;
                if (done) {
                    fieldEnd = str.length();
                }
                if ((fieldLength = (field = str.substring(fieldStart, fieldEnd)).length()) > maxFieldWidth) {
                    throw new IllegalArgumentException();
                }
                int n = fieldLength == 0 ? 0 : (fieldInt = Integer.parseInt(field, isDecimal ? 10 : 16));
                if (fieldInt > maxValue) {
                    throw new IllegalArgumentException();
                }
                int i = 0;
                while (i < bytesPerField) {
                    this.bytes[byteStart + (bytesPerField - i) - 1] = (byte)(fieldInt >> i * 8 & 0xFFFFFFFF);
                    ++i;
                }
                byteStart += bytesPerField;
            }
            fieldStart = fieldEnd + separatorLength;
            ++nField;
        }
        if (!done) {
            throw new IllegalArgumentException();
        }
    }

    public UnsignedByteArray(int length, int nLeadingOnes) throws IllegalArgumentException {
        if (length < 0 || nLeadingOnes < 0 || nLeadingOnes > length * 8) {
            throw new IllegalArgumentException();
        }
        this.bytes = new byte[length];
        int nAllLeadingOnesBytes = nLeadingOnes / 8;
        int i = 0;
        while (i < nAllLeadingOnesBytes) {
            this.bytes[i] = -1;
            ++i;
        }
        int nRemainingLeadingOnes = nLeadingOnes % 8;
        if (nRemainingLeadingOnes > 0) {
            this.bytes[nAllLeadingOnesBytes] = (byte)(-1 << 8 - nRemainingLeadingOnes);
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int length() {
        return this.bytes.length;
    }

    public UnsignedByteArray and(UnsignedByteArray other) {
        byte[] otherBytes = other != null ? other.getBytes() : new byte[]{};
        byte[] result = (byte[])Array.newInstance(Byte.TYPE, this.bytes.length);
        int shortestLength = Math.min(this.bytes.length, otherBytes.length);
        int i = 0;
        while (i < shortestLength) {
            result[i] = (byte)(this.bytes[i] & otherBytes[i]);
            ++i;
        }
        return new UnsignedByteArray(result);
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        byte[] otherBytes = ((UnsignedByteArray)other).getBytes();
        if (this.bytes.length != otherBytes.length) {
            return false;
        }
        int i = 0;
        while (i < this.bytes.length) {
            if (this.bytes[i] != otherBytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        int i = 0;
        while (i < this.bytes.length) {
            result = result * 31 ^ this.bytes[i];
            ++i;
        }
        return result;
    }

    public String format(int bytesPerField, int minFieldOutputWidth, String separator, boolean formatAsDecimal, boolean toUpper) {
        FieldFormatter fieldFormatter = formatAsDecimal ? decimalFormatter : hexFormatter;
        WilyStringBuilder sb = new WilyStringBuilder();
        String sep = "";
        int i = 0;
        while (i < this.bytes.length) {
            int ipField = 0;
            int j = 0;
            while (j < bytesPerField) {
                ipField <<= 8;
                int unsignedByte = this.bytes[i + j];
                ipField += (unsignedByte &= 0xFF);
                ++j;
            }
            sb.append(sep);
            String fieldStr = fieldFormatter.toString(ipField);
            int paddingWidth = Math.max(0, minFieldOutputWidth - fieldStr.length());
            int j2 = 0;
            while (j2 < paddingWidth) {
                sb.append("0");
                ++j2;
            }
            sb.append(!formatAsDecimal && toUpper ? fieldStr.toUpperCase() : fieldStr);
            sep = separator;
            i += bytesPerField;
        }
        return sb.toString();
    }

    public String toString() {
        return this.format(1, 2, " ", false, true);
    }

    private static interface FieldFormatter {
        public String toString(int var1);
    }
}

