/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.fault;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.extension.agent.trace.AWSMetricTracer;
import com.wily.util.properties.AttributeListing;

public abstract class AWSFaultTracer
extends AWSMetricTracer
implements KConstants {
    public AWSFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    @Override
    public void finishTrace(int tracerIndex, InvocationData data) {
        ILongIntervalCounterDataAccumulator count;
        boolean fault = this.reportFaultIfExists(data);
        BlameStackSnapshot snapshot = this.removeFromBlameStackIfEnabledAndReturnSnapshot(data);
        if (fault && !(count = (ILongIntervalCounterDataAccumulator)this.getDataAccumulator(data)).IDataAccumulator_isShutOff()) {
            count.ILongIntervalCounterDataAccumulator_addSingleIncident(snapshot);
        }
    }

    protected boolean ignoreTrace(int index, InvocationData data) {
        return false;
    }

    @Override
    public void startTrace(int tracerIndex, InvocationData data) {
        this.addToBlameStackIfEnabled(data);
    }

    protected abstract boolean reportFaultIfExists(InvocationData var1);

    protected void reportFault(String message, InvocationData data) {
        try {
            if (message == null) {
                message = "";
            }
            ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)message);
        }
        catch (Throwable throwable) {}
        if (data.get("com.wily.powerpack.webservices.trace.ErrorSignalKey") == null) {
            this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
            data.put("com.wily.powerpack.webservices.trace.ErrorSignalKey", (Object)kByte);
        }
    }

    public IDataAccumulator testOnly_getDataAccumulator(InvocationData data) {
        return this.getDataAccumulator(data);
    }
}

