/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.jboss;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.ANameFormatter;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.WSNameCache;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class JBossClientNameFormatter
extends ANameFormatter {
    private IModuleFeedbackChannel logger = null;

    public JBossClientNameFormatter(IAgent agent) {
        super(agent);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    @Override
    public String getServiceName(InvocationData data) {
        String serviceURI = null;
        try {
            int wsdlIndex;
            serviceURI = WSNameCache.getServiceName();
            if (serviceURI != null) {
                return serviceURI;
            }
            Object commonClient = data.getInvocationObject();
            serviceURI = (String)WSMUtils.invokeMethodOnObject(commonClient, "getTargetEndpointAddress");
            if (serviceURI != null && (wsdlIndex = serviceURI.lastIndexOf("?wsdl")) != -1) {
                serviceURI = serviceURI.substring(0, wsdlIndex);
            }
        }
        catch (Throwable bomb) {
            String message = Thread.currentThread() + "JBossClientNameFormatter:: Caught unexpected exception while resolving web service name URI " + bomb;
            WSMUtils.handleException(this.getAgent(), message, bomb);
        }
        WSNameCache.setServiceName(serviceURI);
        return serviceURI == null || serviceURI.equals("") ? "UnknownService" : serviceURI;
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespaceURI = null;
        try {
            namespaceURI = WSNameCache.getNamespaceURI();
            if (namespaceURI != null) {
                return namespaceURI;
            }
            Object qName = data.getInvocationParameterAsObject(0);
            namespaceURI = (String)WSMUtils.invokeMethodOnObject(qName, "getNamespaceURI");
        }
        catch (Throwable bomb) {
            try {
                String message = Thread.currentThread() + "JBossClientNameFormatter:: Caught unexpected exception while resolving web service operation namespace URI from " + data.getInvocationObject().getClass() + " " + bomb;
                WSMUtils.handleException(this.getAgent(), message, bomb);
            }
            catch (Exception exception) {
                WSMUtils.handleException(this.getAgent(), "JBossClientNameFormatter:: Caught unexpected exception while resolving web service operation namespace URI", bomb);
            }
        }
        WSNameCache.setNamespaceURI(namespaceURI);
        return namespaceURI == null || namespaceURI.equals("") ? "UnknownService" : namespaceURI;
    }

    @Override
    public String getOperationName(InvocationData data) {
        String operationName = null;
        try {
            operationName = WSNameCache.getOperationName();
            if (operationName != null) {
                return operationName;
            }
            Object qName = data.getInvocationParameterAsObject(0);
            operationName = (String)WSMUtils.invokeMethodOnObject(qName, "getLocalPart");
        }
        catch (Throwable bomb) {
            try {
                String message = "JBossClientNameFormatter::  Caught unexpected exception while resolving web service operation namespace URI from " + data.getInvocationObject().getClass() + " " + bomb;
                WSMUtils.handleException(this.getAgent(), message, bomb);
            }
            catch (Exception exception) {
                WSMUtils.handleException(this.getAgent(), "JBossClientNameFormatter:: Caught unexpected exception while resolving web service operation name", bomb);
            }
        }
        WSNameCache.setOperationName(operationName);
        return operationName == null || operationName.equals("") ? "UnknownOperationName" : operationName;
    }
}

