/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.errors;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.service.ASimpleService;
import com.wily.util.Glob;
import com.wily.util.IConfigurationListener;
import com.wily.util.properties.IndexedProperties;
import java.util.ArrayList;
import java.util.Map;

public class ErrorReportingService
extends ASimpleService {
    public static final String EnabledKey = "introscope.agent.errorsnapshots.enable";
    public static final String ThrottleKey = "introscope.agent.errorsnapshots.throttle";
    public static final int DefaultThrottle = 10;
    public static final String IgnoreKeyPrefix = "introscope.agent.errorsnapshots.ignore";
    private static Glob[] IgnoreGlobs = new Glob[0];
    private IAgent fAgent;
    private ErrorSnapshotFeatureFactory fErrorSnapshotFeatureFactory;
    private boolean fHasServiceStarted = false;
    private boolean fIsAgentInOldConfig = false;
    public static boolean fIsSnapshotEnabled = false;
    private String[] fIgnoreGlobPatterns = new String[0];
    private IConfigurationListener fListener;

    public ErrorReportingService() {
        super("Error Reporting");
    }

    @Override
    protected void doStartService(IAgent agent, Map parameters) throws Exception {
        this.fAgent = agent;
        ComponentTracer componentTracer = agent.IAgent_getComponentTracer();
        this.fIsAgentInOldConfig = componentTracer.isAgentOldMode();
        this.configureIgnores(agent.IAgent_getIndexedProperties());
        this.updateSnapshotCollectionStatus(agent.IAgent_getIndexedProperties());
        agent.IAgent_getModuleFeedback().info("Started Error Reporting service");
        this.fHasServiceStarted = true;
        this.fListener = new ErrorIgnoresConfigurationListener(this);
        agent.addConfigurationListener(this.fListener);
    }

    private void updateSnapshotCollectionStatus(IndexedProperties props) {
        boolean newState = props.safeGetBooleanProperty(EnabledKey, true, this.fAgent.IAgent_getModuleFeedback(), this.fAgent.IAgent_getStringLocalizer());
        if (this.fIsAgentInOldConfig && this.fErrorSnapshotFeatureFactory == null) {
            this.fErrorSnapshotFeatureFactory = new ErrorSnapshotFeatureFactory(this.fAgent);
            this.fAgent.getBlameStackFeatureAdministrator().addFeatureFactory(this.fErrorSnapshotFeatureFactory);
        }
        if (fIsSnapshotEnabled != newState) {
            fIsSnapshotEnabled = newState;
            if (!fIsSnapshotEnabled) {
                this.fAgent.IAgent_getModuleFeedback().info("Error snapshot collection has been disabled");
            } else {
                this.fAgent.IAgent_getModuleFeedback().info("Error snapshot collection has been enabled");
            }
        }
    }

    private void configureIgnores(IndexedProperties props) {
        String[] globPatterns = props.getAndCondenseAllTrimmedIndexedProperties(IgnoreKeyPrefix);
        if (globPatterns == null) {
            globPatterns = new String[]{};
        }
        ArrayList<Glob> globsList = new ArrayList<Glob>();
        if (this.fIgnoreGlobPatterns.length != globPatterns.length) {
            this.fIgnoreGlobPatterns = globPatterns;
            int i = 0;
            while (i < globPatterns.length) {
                globsList.add(new Glob(globPatterns[i]));
                this.fAgent.IAgent_getModuleFeedback().info("Configured error reporting to ignore errors matching " + globPatterns[i]);
                ++i;
            }
            if (globPatterns.length == 0) {
                this.fAgent.IAgent_getModuleFeedback().info("Configured error reporting to not ignore any errors. Ignore list was disabled");
            }
            IgnoreGlobs = globsList.toArray(new Glob[globsList.size()]);
        } else {
            int i = 0;
            while (i < this.fIgnoreGlobPatterns.length) {
                if (!this.fIgnoreGlobPatterns[i].equals(globPatterns[i])) {
                    this.fIgnoreGlobPatterns = globPatterns;
                    int j = 0;
                    while (j < globPatterns.length) {
                        globsList.add(new Glob(globPatterns[j]));
                        this.fAgent.IAgent_getModuleFeedback().info("Configured error reporting to ignore errors matching " + globPatterns[j]);
                        ++j;
                    }
                    IgnoreGlobs = globsList.toArray(new Glob[globsList.size()]);
                    break;
                }
                ++i;
            }
        }
    }

    public static boolean shouldIgnore(String errorMessage) {
        int i = 0;
        while (i < IgnoreGlobs.length) {
            if (IgnoreGlobs[i].matches(errorMessage)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean flagErrorInManagedApplication(String errorMessage) {
        return ErrorSnapshotFeatureFactory.flagErrorInManagedApplication(errorMessage);
    }

    private static class ErrorIgnoresConfigurationListener
    implements IConfigurationListener {
        ErrorReportingService parent;

        public ErrorIgnoresConfigurationListener(ErrorReportingService parent) {
            this.parent = parent;
        }

        @Override
        public void onChange(IndexedProperties props) {
            if (this.parent.fHasServiceStarted) {
                this.parent.configureIgnores(props);
                this.parent.updateSnapshotCollectionStatus(props);
            }
        }
    }
}

