/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.recording;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.recording.IMetricRecordingListener;
import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.wilyassert.Assertion;

public final class MetricSetShutoffHandler
implements IMetricRecordingListener {
    private final IAgent fAgent;
    private final AgentMetric[] fMetrics;
    private final boolean[] fIsRecording;
    private int fRecordingCount;

    public MetricSetShutoffHandler(IAgent agent, AgentMetric[] metrics) {
        this.fAgent = agent;
        this.fMetrics = metrics;
        this.fIsRecording = new boolean[this.fMetrics.length];
        int i = 0;
        while (i < this.fIsRecording.length) {
            this.fIsRecording[i] = true;
            ++i;
        }
        this.fRecordingCount = this.fIsRecording.length;
        this.addRecordingListeners();
    }

    public void teardown() {
        this.removeRecordingListeners();
    }

    private void addRecordingListeners() {
        MetricRecordingAdministrator administrator = this.fAgent.IAgent_getMetricRecordingAdministrator();
        int i = 0;
        while (i < this.fMetrics.length) {
            administrator.addMetricRecordingListenerWithRewind(this.fMetrics[i], this);
            ++i;
        }
    }

    private void removeRecordingListeners() {
        MetricRecordingAdministrator administrator = this.fAgent.IAgent_getMetricRecordingAdministrator();
        int i = 0;
        while (i < this.fMetrics.length) {
            administrator.removeMetricRecordingListener(this.fMetrics[i], this);
            ++i;
        }
    }

    private int getMetricIndex(AgentMetric metric) {
        int i = 0;
        while (i < this.fMetrics.length) {
            if (metric == this.fMetrics[i]) {
                return i;
            }
            ++i;
        }
        Assertion.wilyAssert(false);
        return -1;
    }

    @Override
    public void IMetricRecordingListener_metricIsShutOff(AgentMetric metric) {
        int index = this.getMetricIndex(metric);
        if (index >= 0 && this.fIsRecording[index]) {
            this.fIsRecording[index] = false;
            --this.fRecordingCount;
        }
    }

    @Override
    public void IMetricRecordingListener_metricIsTurnedOn(AgentMetric metric) {
        int index = this.getMetricIndex(metric);
        if (index >= 0 && !this.fIsRecording[index]) {
            this.fIsRecording[index] = true;
            ++this.fRecordingCount;
        }
    }

    public boolean isShutoff() {
        return this.fRecordingCount == 0;
    }
}

