/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.nio.ChannelMethodResultRateTracer;
import com.wily.introscope.agent.trace.nio.SocketAcceptMappingTracer;
import com.wily.introscope.agent.trace.nio.SocketChannelMap;
import com.wily.util.properties.AttributeListing;
import java.nio.channels.SocketChannel;

public final class SocketMethodResultRateTracer
extends ChannelMethodResultRateTracer
implements ITracer {
    public SocketMethodResultRateTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected final IIntegerRateDataAccumulator createDataAccumulator(InvocationData data) {
        String formattedName = this.formatParameterizedName(data);
        if (formattedName != null) {
            return this.createDataAccumulator(formattedName);
        }
        return null;
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        SocketChannel channel;
        if (SocketAcceptMappingTracer.checkWithOverheadMgr()) {
            return null;
        }
        if (data.isSocketClamped()) {
            return null;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof SocketChannel && SocketChannelMap.isRequired(channel = (SocketChannel)invocationObject, this.getAgent()) && SocketChannelMap.getResourceName(channel) != null) {
            return this;
        }
        return null;
    }
}

