/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.introscope.spec.server.transactiontrace.SequenceId;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;

public abstract class ABaseCorrelationId {
    private IModuleFeedbackChannel fFeedback = null;
    private static volatile boolean sAgentInitialized = false;
    protected static GUIDGenerator globalIDGenerator = GUIDGenerator.getInstance();
    protected static final String sequenceSeparator = ",";
    protected SharedCrossProcessData cache = null;
    protected ComponentTracer componentTracer = null;
    protected boolean fIsDebugEnabled = false;
    protected boolean fIsVerboseEnabled = false;
    protected static IAgent sAgent;
    public static final String CORRELATION_ID_KEY = "CorIDForSOAPInvocation";
    protected static Module kModule;
    private static final String kSequenceIdMaxLimitCrossProcessData = "introscope.agent.crossprocess.sequenceid.maxlimit";
    private static final int kDefaultSequenceIdMaxLimit = 32;
    private static SequenceIdMaxLimitCrossProcessDataProperty sSequenceIdMaxLimitCrossProcessDataProperty;
    private static int sSeqIdDebugLogThreshold;
    private static final int kSeqIdDebugLogMaxLimit = 10;

    static {
        kModule = new Module("CorrelationAPI");
        sSequenceIdMaxLimitCrossProcessDataProperty = null;
        sSeqIdDebugLogThreshold = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void initializeAgent() {
        try {
            if (!sAgentInitialized) {
                Class<ABaseCorrelationId> clazz = ABaseCorrelationId.class;
                // MONITORENTER : com.wily.introscope.agent.transactiontrace.ABaseCorrelationId.class
                if (!sAgentInitialized) {
                    sAgent = AgentShim.getAgent();
                    sSequenceIdMaxLimitCrossProcessDataProperty = new SequenceIdMaxLimitCrossProcessDataProperty(sAgent);
                    sAgent.IAgent_getConfigurationManager().add(sSequenceIdMaxLimitCrossProcessDataProperty, true);
                    sAgentInitialized = true;
                }
                // MONITOREXIT : clazz
            }
            this.componentTracer = sAgent.IAgent_getComponentTracer();
            this.cache = this.componentTracer.getCrossProcessDataCache();
            this.fFeedback = sAgent.IAgent_getModuleFeedback();
            this.fIsDebugEnabled = this.fFeedback.isDebugEnabled(kModule);
            this.fIsVerboseEnabled = this.fFeedback.isVerboseEnabled(kModule);
            return;
        }
        catch (AgentNotAvailableException e) {
            e.printStackTrace();
        }
    }

    protected void initializeCache() {
        if (this.cache.getCorrelationID() == null) {
            this.cache.setCorrelationID(globalIDGenerator.generateKey(), true);
            this.cache.createSeqID();
            this.cache.setPropagationFlag(0);
            this.cache.setDependencyPropagationFlag(0);
            this.cache.setComponentCount(0);
        }
    }

    public IModuleFeedbackChannel getAgentLogger() {
        return this.fFeedback;
    }

    public void incrementSequenceId() {
        int correlationCount = this.cache.incrementCorrelationCount();
        if (correlationCount == 0) {
            this.cache.getSeqID().getOutgoingSequenceId();
        }
    }

    protected String resolveFixedParams(String initialValue, boolean override) {
        String correlationId = null;
        String propagationFlag = null;
        String depPropagationFlag = null;
        String callerName = null;
        String callerNodeType = null;
        String optionalParam = null;
        String newSeqString = null;
        String[] resultArray = initialValue.split(sequenceSeparator);
        int len = resultArray.length;
        if (len < 7 && this.fIsDebugEnabled) {
            this.getAgentLogger().debug(kModule, "Received an older cross process data on wire. ");
        }
        if (len > 0) {
            correlationId = resultArray[0];
        }
        if (len > 1) {
            newSeqString = resultArray[1];
        }
        if (len > 2) {
            propagationFlag = resultArray[2];
        }
        if (len > 3) {
            depPropagationFlag = resultArray[3];
        }
        if (len > 4) {
            callerName = resultArray[4];
        }
        if (len > 5) {
            callerNodeType = resultArray[5];
        }
        if (len > 6) {
            optionalParam = resultArray[6];
        }
        if (correlationId == null) {
            this.initializeCache();
        } else {
            if (!override) {
                this.cache.setCorrelationID(correlationId);
            } else {
                this.cache.overrideCorrelationId(correlationId);
            }
            if (depPropagationFlag != null) {
                this.cache.setDependencyPropagationFlag(Integer.parseInt(depPropagationFlag));
            }
            this.cache.setIncomingCalledByNodeId(callerName);
            this.cache.setIncomingCalledByNodeType(callerNodeType);
            if (newSeqString != null) {
                this.cache.createSeqID(newSeqString);
            } else {
                this.cache.createSeqID();
            }
            if (propagationFlag != null) {
                this.cache.setPropagationFlag(Integer.parseInt(propagationFlag));
                this.cache.setIncomingPropagationFlag(Integer.parseInt(propagationFlag));
            }
        }
        return optionalParam;
    }

    protected abstract void resolveOptionalParams(String var1);

    public int decrementCorrelationCount() {
        return this.cache.decrementCorrelationCount();
    }

    public SequenceId getSequenceId() {
        return this.cache.getSeqID();
    }

    protected final String getCurrentFixedParams() {
        String result = null;
        sAgent.IAgent_getModuleFeedback().debug("getCurrentFixedParams :: Current SequenceId = " + this.cache.getSeqID().getSequenceId());
        result = String.valueOf(this.cache.getCorrelationID()) + sequenceSeparator + this.cache.getSeqID().getSequenceId() + sequenceSeparator + this.cache.getPropagationFlag() + sequenceSeparator + this.cache.getDependencyPropagationFlag() + sequenceSeparator + this.cache.getOutgoingCallerNodeId() + sequenceSeparator + this.cache.getOutgoingCallerNodeType();
        return result;
    }

    private final String getCappedSequenceId(String seqId) {
        int maxSeqIdLength = sSequenceIdMaxLimitCrossProcessDataProperty.getIntValue();
        String sequenceId = seqId;
        if (maxSeqIdLength > 3 && sequenceId != null && sequenceId.length() > maxSeqIdLength) {
            if (this.fIsDebugEnabled && sSeqIdDebugLogThreshold < 10) {
                this.getAgentLogger().debug(kModule, "Received an older cross process data on wire. ");
                this.getAgentLogger().debug(kModule, "Current SequenceId = " + sequenceId);
                this.getAgentLogger().debug(kModule, "SequenceId is growing above acceptable limit. Dropping the trailing sequence numbers");
            }
            String trimmedSeqID = sequenceId.substring(0, maxSeqIdLength);
            sequenceId = trimmedSeqID.substring(0, trimmedSeqID.lastIndexOf(":"));
            if (this.fIsDebugEnabled && sSeqIdDebugLogThreshold < 10) {
                this.getAgentLogger().debug(kModule, "Setting the SequenceId to be at the child level which satisfies the max SeqID length");
                this.getAgentLogger().debug(kModule, "Current SequenceID = " + sequenceId);
                ++sSeqIdDebugLogThreshold;
            }
        }
        return sequenceId;
    }

    protected final String getOutGoingFixedParams() {
        String result = null;
        result = String.valueOf(this.cache.getCorrelationID()) + sequenceSeparator + this.getCappedSequenceId(this.cache.getSeqID().getOutgoingSequenceId()) + sequenceSeparator + this.cache.getPropagationFlag() + sequenceSeparator + this.cache.getDependencyPropagationFlag() + sequenceSeparator + this.cache.getOutgoingCallerNodeId() + sequenceSeparator + this.cache.getOutgoingCallerNodeType();
        return result;
    }

    protected final String getCurrentOutGoingFixedParams() {
        String result = null;
        result = String.valueOf(this.cache.getCorrelationID()) + sequenceSeparator + this.getCappedSequenceId(this.cache.getSeqID().getCurrentOutgoingSequenceId()) + sequenceSeparator + this.cache.getPropagationFlag() + sequenceSeparator + this.cache.getDependencyPropagationFlag() + sequenceSeparator + this.cache.getOutgoingCallerNodeId() + sequenceSeparator + this.cache.getOutgoingCallerNodeType();
        return result;
    }

    public SharedCrossProcessData getData() {
        return this.cache;
    }

    private static final class SequenceIdMaxLimitCrossProcessDataProperty
    extends PositiveIntegerConfigurationProperty {
        private SequenceIdMaxLimitCrossProcessDataProperty(IAgent agent) {
            super(ABaseCorrelationId.kSequenceIdMaxLimitCrossProcessData, 32, agent.IAgent_getModuleFeedback(), agent.IAgent_getModule(), agent.IAgent_getStringLocalizer());
        }

        public int getIntValue() {
            return (Integer)this.getValue();
        }
    }
}

