/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

import com.wily.util.adt.CanonicalObjectPool;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;

public class StringParser
implements Externalizable,
CharSequence {
    private static final long serialVersionUID = 6302697429361907728L;
    private static final int kEmptyStringHashCode = "".hashCode();
    private static final String[] kEmptyStringArray = new String[0];
    private char fSeparator;
    private String[] fSegments;
    private int fHashCode;

    public StringParser(char separator, String entireString) {
        this.initializeFromString(separator, entireString);
    }

    public StringParser(char separator, String[] segments) {
        this.initializeFromStringArray(separator, segments, 0, segments.length);
    }

    public StringParser(char separator, String[] segments, int startIndex, int count) {
        this.initializeFromStringArray(separator, segments, startIndex, count);
    }

    public StringParser() {
    }

    public String getEntireString() {
        StringBuilder b = new StringBuilder(256);
        int i = 0;
        while (i < this.fSegments.length) {
            if (i > 0) {
                b.append(this.fSeparator);
            }
            b.append(this.fSegments[i]);
            ++i;
        }
        return b.toString();
    }

    public String getSegment(int index) {
        return this.fSegments[index];
    }

    public int getSegmentCount() {
        return this.fSegments.length;
    }

    @Override
    public boolean isEmpty() {
        return this.fSegments.length == 0;
    }

    public String getPrefixIncludingSegmentN(int n) {
        if (n >= this.getSegmentCount()) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " >= " + this.getSegmentCount());
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i <= n) {
            if (i != 0) {
                buffer.append(this.fSeparator);
            }
            buffer.append(this.getSegment(i));
            ++i;
        }
        return buffer.toString();
    }

    public String getSubSegment(int start) {
        if (start > this.getSegmentCount()) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(start) + " > " + this.getSegmentCount());
        }
        StringBuilder buffer = new StringBuilder();
        int end = this.getSegmentCount();
        int i = start;
        while (i < end) {
            if (i != start) {
                buffer.append(this.fSeparator);
            }
            buffer.append(this.getSegment(i));
            ++i;
        }
        return buffer.toString();
    }

    public String getSuffixStartingWithSegmentN(int n) {
        if (n > this.getSegmentCount()) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(n) + " > " + this.getSegmentCount());
        }
        StringBuilder buffer = new StringBuilder();
        int i = n;
        while (i < this.getSegmentCount()) {
            if (i != n) {
                buffer.append(this.fSeparator);
            }
            buffer.append(this.getSegment(i));
            ++i;
        }
        return buffer.toString();
    }

    private void initializeFromString(char separator, String entireString) {
        this.fSeparator = separator;
        if (entireString == null || entireString.length() == 0) {
            this.fHashCode = kEmptyStringHashCode;
            this.fSegments = kEmptyStringArray;
        } else {
            ArrayList<String> bag = new ArrayList<String>(32);
            int lastStart = 0;
            int i = 0;
            while (i < entireString.length()) {
                char c = entireString.charAt(i);
                if (c == separator) {
                    String sub = entireString.substring(lastStart, i);
                    bag.add(CanonicalObjectPool.getCanonicalString(sub));
                    lastStart = i + 1;
                }
                ++i;
            }
            String sub = entireString.substring(lastStart, entireString.length());
            bag.add(CanonicalObjectPool.getCanonicalString(sub));
            this.fSegments = bag.toArray(new String[bag.size()]);
            this.fHashCode = entireString.hashCode();
        }
    }

    private void initializeFromStringArray(char separator, String[] segments, int startIndex, int count) {
        this.fSeparator = separator;
        this.fSegments = new String[count];
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < count) {
            this.fSegments[i] = CanonicalObjectPool.getCanonicalString(segments[startIndex++]);
            if (i != 0) {
                buffer.append(separator);
            }
            buffer.append(this.fSegments[i]);
            ++i;
        }
        this.fHashCode = buffer.toString().hashCode();
    }

    @Override
    public String toString() {
        return this.getEntireString();
    }

    public int hashCode() {
        return this.fHashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StringParser)) {
            return false;
        }
        return Arrays.equals(this.fSegments, ((StringParser)o).fSegments) && ((StringParser)o).fSeparator == this.fSeparator;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeChar(this.fSeparator);
        out.writeObject(this.getEntireString());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.initializeFromString(in.readChar(), (String)in.readObject());
    }

    public void readExternal(ObjectInput in, byte b) throws IOException, ClassNotFoundException {
        this.initializeFromString((char)b, (String)in.readObject());
    }

    public void smartWriteExternal(ObjectOutput out) throws IOException {
        this.writeExternal(out);
    }

    @Override
    public char charAt(int pIndex) {
        int index = pIndex;
        int i = 0;
        while (i < this.fSegments.length) {
            if (index < this.fSegments[i].length()) {
                return this.fSegments[i].charAt(index);
            }
            if ((index -= this.fSegments[i].length()) == 0) {
                return this.fSeparator;
            }
            --index;
            ++i;
        }
        throw new IndexOutOfBoundsException("Index " + pIndex + " out of bounds with StringParser len " + this.getEntireString().length());
    }

    @Override
    public int length() {
        int len = 0;
        int i = 0;
        while (i < this.fSegments.length) {
            len += this.fSegments[i].length();
            if (i > 0) {
                ++len;
            }
            ++i;
        }
        return len;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new StringParser(this.fSeparator, this.getEntireString().substring(start, end));
    }

    public static StringParser smartReadExternalESEStringParser(ObjectInput in) throws IOException, ClassNotFoundException {
        StringParser parser = new StringParser();
        parser.readExternal(in);
        return parser;
    }
}

