/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.timeslice;

import com.wily.introscope.spec.metric.TypeInquisitor;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.introscope.stat.timeslice.StringTimeslicedValue;
import com.wily.util.WilyUtilities;
import com.wily.wilyassert.Assertion;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class ATimeslicedValue
implements Externalizable,
IMetricDataValue {
    private static final long serialVersionUID = -5118661875535113365L;
    private int fTypeCookie;
    private long fStartTimestampInMillis;
    private long fStopTimestampInMillis;
    private BlameStackSnapshot fBlameStackSnapshot;
    private long fDataPointCount;
    private boolean fDataIsAbsent;
    private boolean fTreatZeroAsHole;
    public static final boolean kDataIsAbsent = true;
    public static final boolean kDataIsPresent = false;
    public static final ATimeslicedValue[] kZeroLengthTimeslicedValueArray = new ATimeslicedValue[0];

    protected ATimeslicedValue(int typeCookie, long startTimestamp, long stopTimestamp, BlameStackSnapshot blameStack, long dataPointCount, boolean dataIsAbsent) {
        this.fTypeCookie = typeCookie;
        this.fStartTimestampInMillis = startTimestamp / 1000L * 1000L;
        this.fStopTimestampInMillis = stopTimestamp / 1000L * 1000L;
        this.fBlameStackSnapshot = blameStack;
        this.fDataPointCount = dataPointCount;
        this.fDataIsAbsent = dataIsAbsent;
        this.fTreatZeroAsHole = TypeInquisitor.isTreatZeroCountAsHole(typeCookie);
    }

    protected ATimeslicedValue() {
    }

    @Override
    public final long getStartTimestampInMillis() {
        return this.fStartTimestampInMillis;
    }

    @Override
    public final long getStopTimestampInMillis() {
        return this.fStopTimestampInMillis;
    }

    @Override
    public final int getType() {
        return this.fTypeCookie;
    }

    public BlameStackSnapshot getBlameStackSnapshot() {
        return this.fBlameStackSnapshot;
    }

    @Override
    public final long getDataPointCount() {
        return this.fDataPointCount;
    }

    @Override
    public final boolean hasDataPoints() {
        return this.fDataPointCount != 0L;
    }

    @Override
    public abstract String getValueAsString();

    @Override
    public double getValueAsDouble(double defaultValue) {
        return defaultValue;
    }

    @Override
    public double getMaxAsDouble(double defaultValue) {
        return defaultValue;
    }

    @Override
    public double getMinAsDouble(double defaultValue) {
        return defaultValue;
    }

    @Override
    public final boolean dataIsAbsent() {
        return this.fDataIsAbsent || this.fTreatZeroAsHole && this.getDataPointCount() == 0L;
    }

    protected boolean equalsDNA(ATimeslicedValue toCompare) {
        if (this.fDataIsAbsent != toCompare.fDataIsAbsent) {
            return false;
        }
        return this.fTypeCookie == toCompare.fTypeCookie && this.fStartTimestampInMillis == toCompare.fStartTimestampInMillis && this.fStopTimestampInMillis == toCompare.fStopTimestampInMillis && (WilyUtilities.nullHandlingEquals(this.getDataPointCount(), toCompare.getDataPointCount()) || this.fDataIsAbsent && toCompare.fDataIsAbsent);
    }

    protected int hashCodeDNA() {
        return this.fTypeCookie ^ (int)this.fStartTimestampInMillis ^ (int)this.fStopTimestampInMillis ^ (int)this.getDataPointCount();
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public String toString() {
        return "[" + super.toString() + "|type: 0x" + Integer.toHexString(this.fTypeCookie) + ", start: " + this.getStartTimestampInMillis() + ", stop: " + this.getStopTimestampInMillis() + ", value: " + this.getValueAsString() + ", absent: " + this.dataIsAbsent() + ", count: " + this.getDataPointCount() + "]";
    }

    public void write(DataOutputStream stream) throws IOException {
        this.writeExternalData(stream);
    }

    public static ATimeslicedValue newFromStream(int typeCookie, DataInputStream inputStream) throws IOException {
        return ATimeslicedValue.newFromStream(typeCookie, inputStream, BlameStackSnapshot.kEmptyBlameStackSnapshot);
    }

    public static ATimeslicedValue newFromStream(int typeCookie, DataInputStream inputStream, BlameStackSnapshot blameStack) throws IOException {
        if (TypeInquisitor.isInteger(typeCookie)) {
            return new IntegerTimeslicedValue(inputStream, blameStack);
        }
        if (TypeInquisitor.isLong(typeCookie)) {
            return new LongTimeslicedValue(inputStream, blameStack);
        }
        if (TypeInquisitor.isString(typeCookie)) {
            return new StringTimeslicedValue(inputStream, blameStack);
        }
        throw new IOException("unsupported type");
    }

    public static ATimeslicedValue createHoleValue(int typeCookie, long startTime, long endTime) {
        return ATimeslicedValue.createValue(typeCookie, startTime, endTime, true);
    }

    public static ATimeslicedValue createZeroValue(int typeCookie, long startTime, long endTime) {
        return ATimeslicedValue.createValue(typeCookie, startTime, endTime, false);
    }

    private static ATimeslicedValue createValue(int typeCookie, long startTime, long endTime, boolean dataIsAbsent) {
        if (TypeInquisitor.isInteger(typeCookie)) {
            return new IntegerTimeslicedValue(typeCookie, startTime, endTime, BlameStackSnapshot.kEmptyBlameStackSnapshot, dataIsAbsent);
        }
        if (TypeInquisitor.isLong(typeCookie)) {
            return new LongTimeslicedValue(typeCookie, startTime, endTime, BlameStackSnapshot.kEmptyBlameStackSnapshot, dataIsAbsent);
        }
        if (TypeInquisitor.isString(typeCookie)) {
            return new StringTimeslicedValue(typeCookie, startTime, endTime, BlameStackSnapshot.kEmptyBlameStackSnapshot, dataIsAbsent);
        }
        Assertion.wilyAssert("Unsupported type.");
        return null;
    }

    protected void writeExternalData(DataOutput out) throws IOException {
        out.writeInt(this.fTypeCookie);
        out.writeLong(this.fStartTimestampInMillis);
        out.writeLong(this.fStopTimestampInMillis);
        out.writeLong(this.fDataPointCount);
        out.writeBoolean(this.fDataIsAbsent);
    }

    protected void readExternalData(DataInput in, BlameStackSnapshot blameStack) throws IOException {
        this.fTypeCookie = in.readInt();
        this.fStartTimestampInMillis = in.readLong();
        this.fStopTimestampInMillis = in.readLong();
        this.fDataPointCount = in.readLong();
        this.fDataIsAbsent = in.readBoolean();
        this.fBlameStackSnapshot = blameStack;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternalData(out);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalData(in, BlameStackSnapshot.kEmptyBlameStackSnapshot);
    }
}

