/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.WilyMath;

public final class HashCodeUtils {
    public static final int STRING_HASHCODE_PRIME = 31;

    private HashCodeUtils() {
    }

    public static final int hashBoolean(boolean b) {
        return b ? 0 : 1;
    }

    public static final int hashByte(byte input) {
        return input;
    }

    public static final int hashChar(char input) {
        return input;
    }

    public static final int hashShort(short input) {
        return input;
    }

    public static final int hashInt(int input) {
        return input;
    }

    public static final int hashLong(long input) {
        return (int)(input ^ input >>> 32);
    }

    public static final int hashFloat(float f) {
        return Float.floatToIntBits(f);
    }

    public static final int hashDouble(double d) {
        return HashCodeUtils.hashLong(Double.doubleToLongBits(d));
    }

    public static final int hashObject(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static final int unsafeHashObject(Object o) {
        return o.hashCode();
    }

    public static final int accumulateHashCode(int hashSoFar, int newComponent) {
        return 37 * hashSoFar + newComponent;
    }

    public static final int accumulateHashCode(int hashSoFar, Object o) {
        return 37 * hashSoFar + HashCodeUtils.hashObject(o);
    }

    public static final int unsafeAccumulateHashCode(int hashSoFar, Object o) {
        return 37 * hashSoFar + HashCodeUtils.unsafeHashObject(o);
    }

    public static final int accumulateHashCode(int hashSoFar, boolean b) {
        return 37 * hashSoFar + HashCodeUtils.hashBoolean(b);
    }

    public static final int accumulateHashCode(int hashSoFar, byte b) {
        return 37 * hashSoFar + HashCodeUtils.hashByte(b);
    }

    public static final int accumulateHashCode(int hashSoFar, short s) {
        return 37 * hashSoFar + HashCodeUtils.hashShort(s);
    }

    public static final int accumulateHashCode(int hashSoFar, char c) {
        return 37 * hashSoFar + HashCodeUtils.hashChar(c);
    }

    public static final int accumulateHashCode(int hashSoFar, long l) {
        return 37 * hashSoFar + HashCodeUtils.hashLong(l);
    }

    public static final int accumulateHashCode(int hashSoFar, float f) {
        return 37 * hashSoFar + HashCodeUtils.hashFloat(f);
    }

    public static final int accumulateHashCode(int hashSoFar, double d) {
        return 37 * hashSoFar + HashCodeUtils.hashDouble(d);
    }

    public static final int appendHashCode(int currentHash, String appendee) {
        return WilyMath.overflowExp(31, appendee.length()) * currentHash + appendee.hashCode();
    }

    public static final int appendHashCode(int currentHash, int appendeeHashCode, int appendeeLength) {
        return WilyMath.overflowExp(31, appendeeLength) * currentHash + appendeeHashCode;
    }
}

