/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.TraceRecorder;
import com.wily.introscope.agent.intelligent.detection.AutomaticBoundaryDetectionAdmin;
import com.wily.introscope.agent.intelligent.detection.BoundaryDetectionExecutor;
import com.wily.introscope.agent.intelligent.detection.Logger;
import com.wily.introscope.agent.intelligent.detection.StackTraceRecorder;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.RulesSettings;
import com.wily.introscope.agent.intelligent.entrypoint.apis.Rule;
import com.wily.introscope.agent.intelligent.entrypoint.apis.RuleEngine;
import com.wily.introscope.agent.intelligent.entrypoint.filters.BlacklistedElementsFilter;
import com.wily.introscope.agent.intelligent.entrypoint.tracers.EntryPointDetectionHelperTracer;
import com.wily.introscope.agent.intelligent.exitpoint.ExitPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.exitpoint.tracers.BaseExitPointDetectionHelperTracer;
import com.wily.introscope.agent.service.ASimpleService;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.api.instrument.AClassRedefinitionDelegate;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import java.lang.instrument.Instrumentation;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class AutomaticBoundaryDetectionService
extends ASimpleService {
    private volatile IAgent agent;
    private static final String SERVICE_NAME = "AutomaticBoundaryDetectionService";

    public AutomaticBoundaryDetectionService() {
        this(SERVICE_NAME);
    }

    public AutomaticBoundaryDetectionService(String name) {
        super(name);
    }

    protected void doStartService(IAgent agent, Map parameters) throws Exception {
        this.agent = agent;
        EntryPointDetectionConfiguration.init(agent);
        ExitPointDetectionConfiguration.init(agent);
        if (this.shouldStartService()) {
            this.initializeConfigurations(this.agent);
            Logger.logInfoMessage((String)"Automatic Boundary Detection Service started");
        }
    }

    private boolean shouldStartService() {
        String messagePrefix = "Automatic Boundary Detection Service is turned off ";
        Instrumentation inst = null;
        IClassRedefinitionDelegate classRedefinitionDelegate = null;
        TransformerAdministrator tAdm = this.agent.IAgent_getTransformerAdministrator();
        AutoProbeTransformer dit = (AutoProbeTransformer)tAdm.getDynamicInstrumentationTransformer();
        if (dit != null && (classRedefinitionDelegate = dit.getClassRedefinitionDelegate()) != null) {
            inst = ((AClassRedefinitionDelegate)classRedefinitionDelegate).getInstrumentation();
        }
        if (inst == null) {
            if (Logger.isWarningEnabled()) {
                Logger.logWarningMessage((String)messagePrefix);
            }
            return false;
        }
        if (this.agent.IAgent_getComponentTracer().isAgentOldMode()) {
            if (Logger.isWarningEnabled()) {
                Logger.logWarningMessage((String)(String.valueOf(messagePrefix) + "due to use of old agent configuration."));
            }
            return false;
        }
        if (!this.agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.autoprobe.enable", false)) {
            if (Logger.isWarningEnabled()) {
                Logger.logWarningMessage((String)(String.valueOf(messagePrefix) + "because Introscope AutoProbe has been disabled."));
            }
            return false;
        }
        if (!this.agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.deep.instrumentation.enabled", true)) {
            if (Logger.isWarningEnabled()) {
                Logger.logWarningMessage((String)(String.valueOf(messagePrefix) + "because Intelligent Instrumentation has been disabled."));
            }
            return false;
        }
        if (inst != null && !inst.isRedefineClassesSupported()) {
            if (Logger.isWarningEnabled()) {
                Logger.logWarningMessage((String)(String.valueOf(messagePrefix) + "because DI is not supported."));
            }
            return false;
        }
        if (!this.agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.autoprobe.dynamicinstrument.enabled", false)) {
            if (Logger.isWarningEnabled()) {
                Logger.logWarningMessage((String)(String.valueOf(messagePrefix) + "because DI has been disabled."));
            }
            return false;
        }
        return true;
    }

    private void initializeConfigurations(IAgent agent) {
        Logger.logDebugMessage((String)"Initializing configurations for automatic boundary detection");
        StackTraceRecorder recorder = StackTraceRecorder.getInstance();
        AutomaticBoundaryDetectionAdmin.getInstance().setTraceRecorder((TraceRecorder)recorder);
        agent.setBoundaryDetectionTraceRecorder((TraceRecorder)recorder);
        EntryPointDetectionHelperTracer.updateRecorder(recorder);
        BaseExitPointDetectionHelperTracer.updateRecorder(recorder);
        BoundaryDetectionExecutor.init(agent);
        RuleEngine engine = AutomaticBoundaryDetectionAdmin.getInstance().getEntryPointDetectionRuleEngine();
        this.registerFiltersToEngine(engine);
        this.registerRulesToEngine(engine);
    }

    public void registerRulesToEngine(RuleEngine engine) {
        Logger.logDebugMessage((String)"Registering rules with entrypoint detection rule engine");
        Set<Rule> rules = RulesSettings.getDefaultRulesSet(this.agent);
        engine.registerRules(rules);
        if (Logger.isDebugEnabled()) {
            Logger.logDebugMessage((String)("Total number of entrypoint rules registered: " + rules.size()));
            Logger.logDebugMessage((String)("Entry Point rules list: " + rules));
        }
    }

    public void registerFiltersToEngine(RuleEngine engine) {
        Logger.logDebugMessage((String)"Registering filters with entrypoint detection rule engine");
        LinkedHashSet<BlacklistedElementsFilter> filters = new LinkedHashSet<BlacklistedElementsFilter>();
        filters.add(new BlacklistedElementsFilter(this.agent));
        engine.registerFilters(filters);
        if (Logger.isDebugEnabled()) {
            Logger.logDebugMessage((String)("Total number of entrypoint filters registered: " + filters.size()));
            Logger.logDebugMessage((String)("Entry Point filters list: " + filters));
        }
    }
}

