/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.cb;

import com.wily.introscope.agent.intelligent.detection.Logger;
import com.wily.introscope.agent.intelligent.detection.cb.CandidateDetectionReport;
import com.wily.introscope.agent.intelligent.detection.cb.CandidateFinderExecutionListener;
import com.wily.introscope.agent.intelligent.detection.cb.CircuitBreaker;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseCircuitBreaker
implements CircuitBreaker,
Runnable,
CandidateFinderExecutionListener {
    private static final int MIN_TRACES = 1;
    private final String moduleName;
    private final int maxWaitIntervals;
    private volatile CircuitState state = CircuitState.CLOSED;
    private int runId = 0;
    private int currentWaitIntervals = 0;
    private boolean isCircuitOpen = false;
    private int closeRunId = -1;
    private AtomicInteger numTraces = new AtomicInteger(0);
    private AtomicInteger candidates = new AtomicInteger(0);
    private Object STATS_LOCK = new Object();

    protected BaseCircuitBreaker(String moduleName, int maxWaitIntervals) {
        this.moduleName = moduleName;
        this.maxWaitIntervals = maxWaitIntervals;
    }

    protected int getRunId() {
        return this.runId;
    }

    private int getNextRunId() {
        return ++this.runId;
    }

    @Override
    public void run() {
        int id = this.getNextRunId();
        Logger.logTraceMessage((String)(String.valueOf(this.moduleName) + " - Circuit Breaker run id:" + id));
        if (this.shouldRunCircuitBreaker()) {
            CandidateDetectionReport report = this.harvestAndReset();
            boolean trace = Logger.isTraceEnabled();
            if (trace) {
                Logger.logTraceMessage((String)(String.valueOf(this.moduleName) + "- Candidate detection report: " + report));
                Logger.logTraceMessage((String)(String.valueOf(this.moduleName) + "- Circuit state before run: " + (Object)((Object)this.state) + ", Current wait intervals before run: " + this.currentWaitIntervals + ", Current run id for closing circuit: " + this.closeRunId));
            }
            if (this.hasSucceededInInterval(report)) {
                if (this.isCircuitOpen) {
                    this.closeCircuit();
                }
                this.resetCounters();
            } else if (this.checkHealth(report)) {
                this.closeCircuit();
            } else if (this.shouldTrip(report)) {
                this.openCircuit();
            }
            if (trace) {
                String msg = String.valueOf(this.moduleName) + "- Circuit state after run: " + (Object)((Object)this.state) + ", Current wait intervals after run: " + this.currentWaitIntervals + ", New run id for closing circuit: " + this.closeRunId;
                Logger.logTraceMessage((String)msg);
            }
        }
    }

    protected abstract boolean shouldRunCircuitBreaker();

    public CircuitState getCircuitState() {
        return this.state;
    }

    protected void setCircuitState(CircuitState state) {
        this.state = state;
    }

    protected boolean isCircuitOpen() {
        return CircuitState.OPEN.equals((Object)this.getCircuitState());
    }

    protected boolean isCircuitClosed() {
        return CircuitState.CLOSED.equals((Object)this.getCircuitState());
    }

    @Override
    public boolean shouldTrip(CandidateDetectionReport report) {
        return this.hasFailedInInterval(report) && !this.isCircuitOpen;
    }

    private boolean hasSucceededInInterval(CandidateDetectionReport report) {
        return report.getCandidateDetected() > 0;
    }

    private boolean hasFailedInInterval(CandidateDetectionReport report) {
        return report.getTracesCapured() >= 1 && report.getCandidateDetected() == 0;
    }

    @Override
    public boolean checkHealth(CandidateDetectionReport report) {
        return this.isCircuitOpen && this.runId >= this.closeRunId;
    }

    private void openCircuitInternal() {
        this.setCircuitState(CircuitState.OPEN);
    }

    private void closeCircuitInternal() {
        this.setCircuitState(CircuitState.CLOSED);
    }

    @Override
    public void openCircuit() {
        Logger.logDebugMessage((String)(String.valueOf(this.moduleName) + " - Tripping circuit"));
        this.openCircuitInternal();
        this.isCircuitOpen = true;
        this.currentWaitIntervals = this.currentWaitIntervals >= this.maxWaitIntervals ? 1 : (this.closeRunId > 0 && this.runId == this.closeRunId + 1 ? (this.currentWaitIntervals *= 2) : 1);
        this.closeRunId = this.runId + this.currentWaitIntervals;
    }

    @Override
    public void closeCircuit() {
        Logger.logDebugMessage((String)(String.valueOf(this.moduleName) + " - Closing back circuit"));
        this.closeCircuitInternal();
        this.isCircuitOpen = false;
    }

    private void resetCounters() {
        this.closeRunId = -1;
        this.currentWaitIntervals = 0;
    }

    protected int getCloseRunId() {
        return this.closeRunId;
    }

    protected int getCurrentWaitIntervals() {
        return this.currentWaitIntervals;
    }

    protected void setCurrentWaitIntervals(int n) {
        this.currentWaitIntervals = n;
    }

    protected void reset() {
        this.runId = 0;
        this.setCircuitState(CircuitState.CLOSED);
        this.isCircuitOpen = false;
        this.harvestAndReset();
        this.resetCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportTraceAnalysisResult(int traces, int candidates) {
        Object object = this.STATS_LOCK;
        synchronized (object) {
            this.candidates.addAndGet(candidates);
            this.numTraces.addAndGet(traces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CandidateDetectionReport harvestAndReset() {
        Object object = this.STATS_LOCK;
        synchronized (object) {
            return new CandidateDetectionReport(this.numTraces.getAndSet(0), this.candidates.getAndSet(0));
        }
    }

    public static enum CircuitState {
        OPEN,
        CLOSED;

    }
}

