/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection.rules;

import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.methodmatcher.NamedMethodMatcher;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.intelligent.detection.rules.AbstractFailFastRule;
import com.wily.introscope.agent.intelligent.detection.rules.CommonUtils;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.NameUtilities;
import java.util.Map;
import java.util.Set;

public class SkipMarkedForSkipInsRule
extends AbstractFailFastRule {
    private final AutoProbeTransformer autoProbeTransformer;

    public SkipMarkedForSkipInsRule(IAgent agent) {
        this.autoProbeTransformer = agent != null ? (AutoProbeTransformer)agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer() : null;
    }

    public SkipMarkedForSkipInsRule(AutoProbeTransformer autoProbeTransformer) {
        this.autoProbeTransformer = autoProbeTransformer;
    }

    public boolean doExecute(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        boolean passes = true;
        if (this.autoProbeTransformer != null) {
            IndexAwareTraceElement traceElement = trace[currentElementIndex];
            String className = traceElement.getClassName();
            passes = !this.isSkippedByNormalInstrumentation(className, traceElement.getMethodName());
        }
        return passes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSkippedByNormalInstrumentation(String fqClassName, String simpleMethodName) {
        try {
            if (this.autoProbeTransformer.isSkippedByNormalInstrumentation(fqClassName)) {
                return true;
            }
            fqClassName = NameUtilities.normalizeClassName((String)fqClassName);
            Map skipMethodsForClasses = this.autoProbeTransformer.getCompilerSettings().getFilter().getSkipMethodsForClasses();
            for (Map.Entry entry : skipMethodsForClasses.entrySet()) {
                Set methodSet;
                IClassName currentName = (IClassName)entry.getKey();
                if (!currentName.getContainerAndPackageAndNameString().equals(fqClassName) || (methodSet = (Set)entry.getValue()) == null) continue;
                for (IMethodMatcher matcher : methodSet) {
                    IMethodName skippedMethod;
                    if (!(matcher instanceof NamedMethodMatcher) || !(skippedMethod = ((NamedMethodMatcher)matcher).getMethodName()).getNameString().equals(simpleMethodName)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            Logger.logDebugMessage((String)("Exception while checking if method '" + fqClassName + "#" + simpleMethodName + "'  is skipped by normal instrumentation"), (Throwable)e);
        }
        return false;
    }

    public String toString() {
        return CommonUtils.formatStringRep((String)((Object)((Object)this)).getClass().getSimpleName());
    }
}

