/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.filter.sampling;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.filter.sampling.FastestNSlowestNStatisticalSampler;
import com.wily.introscope.agent.filter.sampling.FirstNPerIntervalSampler;
import com.wily.introscope.agent.filter.sampling.ISampler;
import com.wily.introscope.agent.filter.sampling.RandomSampler;
import com.wily.introscope.agent.filter.sampling.SamplingResult;
import com.wily.introscope.agent.transactiontrace.ISamplingInput;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import com.wily.introscope.install.KIntroscopeConfigConstants;
import com.wily.util.IConfigurationListener;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class SamplingManager
implements IConfigurationListener {
    private final IAgent fAgent;
    private final ISampler[] fSamplers;
    private long fDisabled = 0L;
    private final IModuleFeedbackChannel fFeedback;
    private Object fPreviousEnabledSet = new Object();

    public SamplingManager(IAgent agent) {
        this.fAgent = agent;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fSamplers = new ISampler[]{new FirstNPerIntervalSampler(), new RandomSampler(), new FastestNSlowestNStatisticalSampler(true), new FastestNSlowestNStatisticalSampler(false)};
    }

    public synchronized void configure() {
        this.fAgent.addConfigurationListener(this);
        ISampler[] iSamplerArray = this.fSamplers;
        int n = this.fSamplers.length;
        int n2 = 0;
        while (n2 < n) {
            ISampler sampler = iSamplerArray[n2];
            if (this.fFeedback.isTraceEnabled(ISampler.kSamplingModule)) {
                this.fFeedback.trace(ISampler.kSamplingModule, "Will configure " + sampler.getClass().getSimpleName());
            }
            sampler.configure(this.fAgent);
            ++n2;
        }
    }

    @Override
    public void onChange(IndexedProperties newProps) {
        this.updateMasterEnabled(DisableReason.Configuration, newProps.getBooleanProperty("introscope.agent.transactiontracer.sampling.enabled", true), newProps);
        this.updateEnabled(newProps);
    }

    private void updateEnabled(IndexedProperties newProps) {
        this.updateEnabled(newProps.getProperty("introscope.agent.transactiontracer.sampling.enabled.set", null));
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private synchronized void updateEnabled(String text) {
        if (this.fDisabled != 0L) {
            ISampler[] iSamplerArray = this.fSamplers;
            int n = this.fSamplers.length;
            int n2 = 0;
            while (n2 < n) {
                ISampler sampler = iSamplerArray[n2];
                sampler.enable(false);
                ++n2;
            }
            return;
        }
        HashSet<String> set = text == null ? new HashSet<String>(KIntroscopeConfigConstants.kDefaultSamplingEnabledSet) : new HashSet(StringUtils.parseAndTrimListToSet(text, ","));
        HashSet<String> enabledSet = new HashSet<String>();
        HashSet<String> disabledSet = new HashSet<String>();
        ISampler[] iSamplerArray = this.fSamplers;
        int n = this.fSamplers.length;
        int n3 = 0;
        while (n3 < n) {
            ISampler sampler = iSamplerArray[n3];
            String name = sampler.name();
            boolean enabled = set.contains(name);
            if (enabled) {
                enabledSet.add(name);
            } else {
                disabledSet.add(name);
            }
            sampler.enable(enabled);
            set.remove(name);
            ++n3;
        }
        if (!SamplingManager.equals(this.fPreviousEnabledSet, text)) {
            if (enabledSet.isEmpty()) {
                this.fFeedback.info(ISampler.kSamplingModule, "All sampling strategies are disabled");
            } else {
                String message = "Sampling strategies " + enabledSet + " are enabled";
                message = disabledSet.isEmpty() ? String.valueOf(message) + "." : String.valueOf(message) + ", " + disabledSet + " are disabled.";
                this.fFeedback.info(ISampler.kSamplingModule, message);
            }
            if (!set.isEmpty()) {
                this.fFeedback.warn(ISampler.kSamplingModule, "Unrecognized sampling strategies: " + set);
            }
        }
        this.fPreviousEnabledSet = text;
    }

    public final void updateMasterEnabled(DisableReason cause, boolean enabled) {
        this.updateMasterEnabled(cause, enabled, null);
    }

    private final synchronized void updateMasterEnabled(DisableReason cause, boolean enabled, IndexedProperties newProps) {
        boolean nowEnabled;
        boolean wasEnabled;
        boolean bl = wasEnabled = this.fDisabled == 0L;
        this.fDisabled = enabled ? (this.fDisabled &= cause.bitMask ^ 0xFFFFFFFFFFFFFFFFL) : (this.fDisabled |= cause.bitMask);
        boolean bl2 = nowEnabled = this.fDisabled == 0L;
        if (wasEnabled == nowEnabled) {
            return;
        }
        this.fFeedback.info(ISampler.kSamplingModule, "Will " + (nowEnabled ? "enable" : "disable") + " sampling session");
        this.updateEnabled(newProps == null ? this.fAgent.IAgent_getIndexedProperties() : newProps);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ISamplingResult shouldSample() {
        if (this.fDisabled != 0L) {
            return SamplingResult.NO;
        }
        ArrayList<ISamplingResult> accepted = new ArrayList<ISamplingResult>(this.fSamplers.length);
        ISamplingResult.Answer defineteYes = null;
        ISampler[] iSamplerArray = this.fSamplers;
        int n = this.fSamplers.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                ISampler sampler = iSamplerArray[n2];
                ISamplingResult r = sampler.shouldSample();
                if (r != null) {
                    ISamplingResult.Answer answer = r.shouldStartSampling();
                    switch (answer.choice) {
                        case YES: {
                            if (defineteYes != null) break;
                            defineteYes = answer;
                        }
                        case MAYBE: {
                            break;
                        }
                        case NO: {
                            break block13;
                        }
                    }
                    accepted.add(r);
                }
            }
            ++n2;
        }
        switch (accepted.size()) {
            case 0: {
                return SamplingResult.NO;
            }
            case 1: {
                return (ISamplingResult)accepted.get(0);
            }
        }
        if (defineteYes != null) {
            return new SamplingResultYesConsolidator(accepted, defineteYes);
        }
        return new SamplingResultMaybeConsolidator(accepted);
    }

    public static enum DisableReason {
        Configuration(1L),
        TraceSession(2L);

        final long bitMask;

        private DisableReason(long bitMask) {
            this.bitMask = bitMask;
        }
    }

    private static final class SamplingResultMaybeConsolidator
    extends SamplingResult {
        private final List<ISamplingResult> accepted;

        private SamplingResultMaybeConsolidator(List<ISamplingResult> accepted) {
            super(ISamplingResult.Answer.create(ISamplingResult.Choice.MAYBE, null));
            this.accepted = accepted;
        }

        @Override
        protected void determineSamplingInternal(ISamplingInput input, ISamplingResult.Callback callback) {
            Accumulator accumulator = new Accumulator(this.accepted, callback);
            for (ISamplingResult r : this.accepted) {
                r.determineSampling(input, accumulator);
            }
        }

        private static final class Accumulator
        implements ISamplingResult.Callback {
            private ISamplingResult.Callback callback;
            private boolean maybeReturned = false;
            private int noCountdown;

            Accumulator(List<ISamplingResult> accepted, ISamplingResult.Callback callback) {
                this.callback = callback;
                this.noCountdown = accepted.size();
            }

            @Override
            public synchronized void onSamplingDetermined(ISamplingResult.Answer answer) {
                if (this.callback == null) {
                    return;
                }
                switch (answer.choice) {
                    case NO: {
                        if (--this.noCountdown == 0) {
                            this.callback.onSamplingDetermined(answer);
                            this.callback = null;
                        }
                        return;
                    }
                    case MAYBE: {
                        if (!this.maybeReturned) {
                            this.maybeReturned = true;
                            this.callback.onSamplingDetermined(answer);
                        }
                        return;
                    }
                    case YES: {
                        this.callback.onSamplingDetermined(answer);
                        this.callback = null;
                        return;
                    }
                }
            }
        }
    }

    private static final class SamplingResultYesConsolidator
    extends SamplingResult {
        private final List<ISamplingResult> accepted;

        private SamplingResultYesConsolidator(List<ISamplingResult> accepted, ISamplingResult.Answer yesAnswer) {
            super(yesAnswer);
            this.accepted = accepted;
        }

        @Override
        protected void determineSamplingInternal(ISamplingInput input, ISamplingResult.Callback callback) {
            for (ISamplingResult r : this.accepted) {
                r.determineSampling(input, ISamplingResult.Callback.NO_OP_CALLBACK);
            }
            callback.onSamplingDetermined(this.answer);
        }
    }
}

