/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IEntryPointShutoff;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontendCandidate;
import com.wily.util.properties.AttributeListing;
import java.util.concurrent.atomic.AtomicBoolean;

public class EntryPointTracer
extends BlamePointTracer
implements IEntryPointShutoff {
    private static final AtomicBoolean GLOBAL_SHUTOFF = new AtomicBoolean(false);
    private AtomicBoolean fIsBadEntryPoint = new AtomicBoolean(false);

    public EntryPointTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        String className = probe.getProbeClassName();
        String methodName = probe.getProbeMethodName();
        String methodDescriptor = probe.getProbeMethodDescriptor();
        IIntelligentInstrumentationTracerHelper helper = HighPerformanceIntelligenceStackElement.getHelper();
        if (helper != null) {
            helper.setEntryPointStateForMethod(className, methodName, methodDescriptor, FrontendCandidate.FrontEndCandidateState.IDENTIFIED.toString());
        }
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return this.fIsBadEntryPoint.get() || GLOBAL_SHUTOFF.get() || HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack.isTracingOn();
    }

    private boolean setBadEntryPoint() {
        return this.fIsBadEntryPoint.compareAndSet(false, true);
    }

    @Override
    protected int getBlameStatus() {
        return 3;
    }

    @Override
    protected long getFilterEnablerBit() {
        return 0L;
    }

    @Override
    public boolean shutoff() {
        return this.setBadEntryPoint();
    }

    public static boolean shutoffAllInstances() {
        return GLOBAL_SHUTOFF.compareAndSet(false, true);
    }
}

