/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.agent.AgentFactoryThread;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.api.instrument.AggregateClassLoader;
import com.wily.introscope.api.instrument.FakeClassLoader;
import com.wily.introscope.api.instrument.Pair;
import com.wily.util.StringIndexer;
import com.wily.util.adt.ConcurrentWeakIdentityThreadLocalHashMap;
import com.wily.util.adt.WeakHashSet;
import com.wily.util.adt.primitive.IntHashSet;
import com.wily.util.adt.primitive.IntObjHashMap;
import com.wily.util.adt.primitive.IntSetEntry;
import com.wily.util.adt.primitive.PrimitiveIntObjMap;
import com.wily.util.adt.primitive.PrimitiveIntSet;
import com.wily.util.adt.primitive.Synchronizer;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DeepInheritanceHelper {
    public static boolean onlyDeep = Boolean.parseBoolean(System.getProperty("com.wily.introscope.agent.deepinheritance.onlyDeep", "false"));
    public static final StringIndexer classNameForest = new StringIndexer();
    public static volatile boolean isDebugOn = false;
    public static volatile PrimitiveIntSet debugForClass = null;
    public static volatile PrimitiveIntSet debugForRoot = null;
    private static boolean isInitialized = false;
    private static ConcurrentWeakIdentityThreadLocalHashMap<ClassLoader, PrimitiveIntObjMap<List<PrimitiveIntSet>>> classForest;
    private static final int PARENTS_INDEX = 0;
    private static final int SUBCLASSES_INDEX = 1;
    private static final int INSTRUMENTED_INDEX = 2;
    private static final int ANNOTATIONS_INDEX = 3;
    private static ConcurrentWeakIdentityThreadLocalHashMap<ClassLoader, PrimitiveIntSet> annotationForest;
    private static ConcurrentWeakIdentityThreadLocalHashMap<ClassLoader, WeakHashSet> classLoaderHierarchy;
    private static PrimitiveIntObjMap<ConcurrentWeakIdentityThreadLocalHashMap<ClassLoader, PrimitiveIntSet>> parentNotFound;
    private static PrimitiveIntSet rootNotFound;
    private static PrimitiveIntSet shallowRootNotFound;
    private static PrimitiveIntObjMap<Set<ClassLoader>> classesBeingRetransformed;
    private static Lock retransformationLock;
    private static final Module kModule;
    private static IModuleFeedbackChannel logger;
    private static IAgent agent;
    private static IClassRedefinitionDelegate instrumentationDelegate;
    public static IntervalHeartbeat heartbeat;
    private static final ClassLoader bootstrapClassLoader;
    private static IDynamicInstrumentationTransformer transformer;

    static {
        kModule = new Module("DeepInheritanceHelper");
        bootstrapClassLoader = new FakeClassLoader();
    }

    public static void initialize(IAgent ag) {
        agent = ag;
        transformer = agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
        IndexedProperties props = agent.IAgent_getIndexedProperties();
        isDebugOn = Boolean.parseBoolean(props.getProperty("com.wily.introscope.agent.deepinheritance.debugOn", "false"));
        if (isDebugOn) {
            debugForClass = new IntHashSet(0, 1.0f);
            debugForRoot = new IntHashSet(0, 1.0f);
            String[] stringArray = props.getProperty("com.wily.introscope.agent.deepinheritance.debugClasses", "").split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                if ((className = className.trim()).length() > 0) {
                    debugForClass.add(classNameForest.addAndGetID(className));
                }
                ++n2;
            }
            stringArray = props.getProperty("com.wily.introscope.agent.deepinheritance.debugRoots", "").split(",");
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String rootName = stringArray[n2];
                if ((rootName = rootName.trim()).length() > 0) {
                    debugForRoot.add(classNameForest.addAndGetID(rootName));
                }
                ++n2;
            }
        }
        instrumentationDelegate = agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getClassRedefinitionDelegate();
        heartbeat = agent.IAgent_getAsyncInstrumentationHeartbeat();
        logger = agent.IAgent_getModuleFeedback();
        classForest = new ConcurrentWeakIdentityThreadLocalHashMap(heartbeat, logger, false, 15000L);
        annotationForest = new ConcurrentWeakIdentityThreadLocalHashMap(heartbeat, logger, false, 15000L);
        classLoaderHierarchy = new ConcurrentWeakIdentityThreadLocalHashMap(heartbeat, logger, false, 15000L);
        parentNotFound = Synchronizer.synchronizedPrimitiveIntObjMap(new IntObjHashMap());
        rootNotFound = Synchronizer.synchronizedPrimitiveIntSet(new IntHashSet(0, 1.0f));
        shallowRootNotFound = Synchronizer.synchronizedPrimitiveIntSet(new IntHashSet(0, 1.0f));
        classesBeingRetransformed = Synchronizer.synchronizedPrimitiveIntObjMap(new IntObjHashMap());
        retransformationLock = new ReentrantLock();
        AgentFactoryThread initForestThread = new AgentFactoryThread(null, new Runnable(){

            @Override
            public void run() {
                DeepInheritanceHelper.initForest();
            }
        }, "Agent: DeepInheritanceInitializer");
        initForestThread.setDaemon(true);
        initForestThread.start();
        isInitialized = true;
    }

    private static void populateClassLoaderHierarchy(ClassLoader classLoader) {
        while (classLoader != null && classLoader != bootstrapClassLoader) {
            WeakHashSet temp;
            ClassLoader parent = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded((classLoader = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(classLoader)).getParent());
            if (parent == null) {
                parent = bootstrapClassLoader;
            }
            if ((temp = classLoaderHierarchy.getWeak(parent)) == null) {
                temp = new WeakHashSet();
                classLoaderHierarchy.putWeak(parent, temp);
            }
            if (temp.contains(classLoader)) break;
            temp.add(classLoader);
            if (parent == bootstrapClassLoader) break;
            classLoader = parent;
        }
    }

    private static Set<ClassLoader> getAllPossibleSubclassClassLoaders(ClassLoader parentClassClassLoader) {
        if (parentClassClassLoader == null) {
            parentClassClassLoader = bootstrapClassLoader;
        }
        HashSet<ClassLoader> returnSet = new HashSet<ClassLoader>();
        LinkedList<ClassLoader> children = new LinkedList<ClassLoader>();
        children.add(parentClassClassLoader);
        while (children.peek() != null) {
            ClassLoader child = (ClassLoader)children.poll();
            returnSet.add(child);
            WeakHashSet directChildren = classLoaderHierarchy.getWeak(child);
            if (directChildren == null) continue;
            children.addAll(directChildren.keySet());
        }
        return returnSet;
    }

    private static ClassLoader getRelevantClassLoaderForParentClass(int className, ClassLoader startingPoint) {
        while (true) {
            PrimitiveIntObjMap<List<PrimitiveIntSet>> map;
            if ((startingPoint = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(startingPoint)) == null) {
                startingPoint = bootstrapClassLoader;
            }
            if ((map = classForest.getWeak(startingPoint)) != null && map.containsKey(className)) {
                return startingPoint;
            }
            if (startingPoint == bootstrapClassLoader) {
                return null;
            }
            startingPoint = startingPoint.getParent();
        }
    }

    private static boolean shouldProcessForAnnotations(PrimitiveIntSet annotations) {
        if (annotations == null || annotations.size() == 0) {
            return false;
        }
        IntHashSet temp = new IntHashSet();
        for (IntSetEntry entry : annotations) {
            int anno = entry.getValue();
            if (!rootNotFound.contains(anno) && !shallowRootNotFound.contains(anno)) continue;
            temp.add(anno);
        }
        return temp.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void addClass(int thisClassName, ClassLoader thisClassLoader, PrimitiveIntSet parents, PrimitiveIntSet directSubclasses, PrimitiveIntSet instrumentedFor, PrimitiveIntSet annotations, boolean isClassBeingLoaded) {
        ClassLoader realClassLoader = thisClassLoader;
        if (thisClassLoader == null) {
            thisClassLoader = bootstrapClassLoader;
        }
        thisClassLoader = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(thisClassLoader);
        DeepInheritanceHelper.populateClassLoaderHierarchy(thisClassLoader);
        PrimitiveIntObjMap<List<PrimitiveIntSet>> classMap = classForest.getWeak(thisClassLoader);
        if (classMap == null) {
            classMap = Synchronizer.synchronizedPrimitiveIntObjMap(new IntObjHashMap());
            classForest.putWeak(thisClassLoader, classMap);
        }
        PrimitiveIntObjMap<List<PrimitiveIntSet>> primitiveIntObjMap = classMap;
        synchronized (primitiveIntObjMap) {
            List<PrimitiveIntSet> tempList = classMap.get(thisClassName);
            if (tempList != null && tempList.get(1) != null) {
                if (directSubclasses == null) {
                    directSubclasses = new IntHashSet(tempList.get(1).size(), 1.0f);
                }
                for (Object entry : tempList.get(1)) {
                    directSubclasses.add(((IntSetEntry)entry).getValue());
                }
            }
            classMap.put(thisClassName, Arrays.asList(parents, directSubclasses, instrumentedFor, annotations));
        }
        if (annotations != null && annotations.size() > 0) {
            PrimitiveIntSet tempSet = annotationForest.getWeak(thisClassLoader);
            if (tempSet == null) {
                tempSet = new IntHashSet(0, 1.0f);
                annotationForest.putWeak(thisClassLoader, tempSet);
            }
            for (Object entry : annotations) {
                tempSet.add(((IntSetEntry)entry).getValue());
            }
        }
        if (parents != null) {
            for (IntSetEntry entry : parents) {
                int name = entry.getValue();
                ClassLoader loader = DeepInheritanceHelper.getRelevantClassLoaderForParentClass(name, thisClassLoader);
                if (loader == null) {
                    ConcurrentWeakIdentityThreadLocalHashMap<ClassLoader, PrimitiveIntSet> map;
                    PrimitiveIntObjMap<ConcurrentWeakIdentityThreadLocalHashMap<ClassLoader, PrimitiveIntSet>> primitiveIntObjMap2 = parentNotFound;
                    synchronized (primitiveIntObjMap2) {
                        map = parentNotFound.get(name);
                        if (map == null) {
                            map = new ConcurrentWeakIdentityThreadLocalHashMap(heartbeat, logger, false, 15000L);
                            parentNotFound.put(name, map);
                        }
                    }
                    PrimitiveIntSet subclasses = map.getWeak(thisClassLoader);
                    if (subclasses == null) {
                        subclasses = new IntHashSet(0, 1.0f);
                        map.putWeak(thisClassLoader, subclasses);
                    }
                    subclasses.add(thisClassName);
                    continue;
                }
                PrimitiveIntSet subclasses = classForest.getWeak(loader).get(name).get(1);
                if (subclasses == null) {
                    subclasses = new IntHashSet(0, 1.0f);
                    classForest.getWeak(loader).get(name).set(1, subclasses);
                }
                subclasses.add(thisClassName);
            }
        }
        if (parentNotFound.containsKey(thisClassName)) {
            PrimitiveIntSet subclasses = classForest.getWeak(thisClassLoader).get(thisClassName).get(1);
            if (subclasses == null) {
                subclasses = new IntHashSet(0, 1.0f);
                classForest.getWeak(thisClassLoader).get(thisClassName).set(1, subclasses);
            }
            ConcurrentWeakIdentityThreadLocalHashMap<ClassLoader, PrimitiveIntSet> possibleSubclasses = parentNotFound.get(thisClassName);
            for (ClassLoader loader : DeepInheritanceHelper.getAllPossibleSubclassClassLoaders(thisClassLoader)) {
                if (!possibleSubclasses.containsWeakKey(loader)) continue;
                for (IntSetEntry entry : possibleSubclasses.getWeak(loader)) {
                    subclasses.add(entry.getValue());
                }
                possibleSubclasses.removeWeak(loader);
            }
            if (possibleSubclasses.size() == 0) {
                parentNotFound.remove(thisClassName);
                possibleSubclasses.markForGC();
            }
        }
        if (!isClassBeingLoaded) {
            retransformationLock.lock();
            if (!(!rootNotFound.contains(thisClassName) && !DeepInheritanceHelper.shouldProcessForAnnotations(annotations) || !instrumentationDelegate.isClassRetransformationSupported() || classesBeingRetransformed.containsKey(thisClassName) && classesBeingRetransformed.get(thisClassName).contains(realClassLoader))) {
                SubtreeRetransformer retransformClasses = new SubtreeRetransformer(thisClassName, thisClassLoader, false);
                heartbeat.addBehavior(retransformClasses, "Retransforming Classes for Deep Inheritance", true, 2000L, false, 1);
            }
            retransformationLock.unlock();
        }
    }

    public static void addClass(Class<?> c) {
        String name;
        if (!isInitialized) {
            return;
        }
        if (c == null) {
            return;
        }
        ClassLoader thisClassLoader = c.getClassLoader();
        int thisClassName = classNameForest.addAndGetID(c.getName());
        IntHashSet parents = null;
        PrimitiveIntSet directSubclasses = null;
        PrimitiveIntSet instrumentedFor = null;
        IntHashSet annotations = null;
        Class<?> parent = c.getSuperclass();
        if (parent != null && !(name = parent.getName()).equals("java.lang.Object")) {
            parents = new IntHashSet(c.getInterfaces().length + 1, 1.0f);
            parents.add(classNameForest.addAndGetID(name));
        }
        if (c.getInterfaces().length > 0 && parents == null) {
            parents = new IntHashSet(c.getInterfaces().length, 1.0f);
        }
        Object[] objectArray = c.getInterfaces();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = objectArray[n2];
            parents.add(classNameForest.addAndGetID(clazz.getName()));
            ++n2;
        }
        try {
            if (c.getDeclaredAnnotations().length > 0) {
                annotations = new IntHashSet(c.getDeclaredAnnotations().length, 1.0f);
            }
            objectArray = c.getDeclaredAnnotations();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object annotation = objectArray[n2];
                annotations.add(classNameForest.addAndGetID(annotation.annotationType().getName()));
                ++n2;
            }
        }
        catch (Throwable throwable) {}
        DeepInheritanceHelper.addClass(thisClassName, thisClassLoader, parents, directSubclasses, instrumentedFor, annotations, false);
    }

    public static void addClass(IModeledClass c) {
        if (!isInitialized) {
            return;
        }
        if (c == null) {
            return;
        }
        ClassLoader thisClassloader = c.getClassLoader();
        int thisClassName = classNameForest.addAndGetID("Unnamed Class");
        try {
            thisClassName = classNameForest.addAndGetID(c.getClassName().getReflectionFriendlyQualifiedNameString());
        }
        catch (NullPointerException nullPointerException) {}
        IntHashSet parents = null;
        PrimitiveIntSet directSubclasses = null;
        PrimitiveIntSet instrumentedFor = null;
        IntHashSet annotations = null;
        String superClassName = null;
        try {
            superClassName = c.getSuperClassName().getReflectionFriendlyQualifiedNameString();
        }
        catch (NullPointerException nullPointerException) {}
        if (superClassName != null && !superClassName.equals("java.lang.Object")) {
            parents = new IntHashSet(c.getAllImplementedInterfaceNames().size() + 1, 1.0f);
            parents.add(classNameForest.addAndGetID(superClassName));
        }
        if (c.getAllImplementedInterfaceNames().size() > 0) {
            if (parents == null) {
                parents = new IntHashSet(c.getAllImplementedInterfaceNames().size(), 1.0f);
            }
            for (String interfaceName : c.getAllImplementedInterfaceNames()) {
                parents.add(classNameForest.addAndGetID(interfaceName));
            }
        }
        if (c.getAllDeclaredAnnotationNames().size() > 0) {
            annotations = new IntHashSet(c.getAllDeclaredAnnotationNames().size(), 1.0f);
            for (String annotationName : c.getAllDeclaredAnnotationNames()) {
                annotations.add(classNameForest.addAndGetID(annotationName));
            }
        }
        DeepInheritanceHelper.addClass(thisClassName, thisClassloader, parents, directSubclasses, instrumentedFor, annotations, true);
    }

    private static void initForest() {
        Class[] classArray = instrumentationDelegate.getAllLoadedClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            DeepInheritanceHelper.addClass(c);
            ++n2;
        }
    }

    private static void updateInstrumentedFor(ClassLoader loader, int className, int rootName) {
        ClassLoader realLoader = loader;
        if (loader == null) {
            loader = bootstrapClassLoader;
        }
        try {
            boolean changeInInstrumentation;
            PrimitiveIntSet instrumentedFor = classForest.getWeak(loader).get(className).get(2);
            if (instrumentedFor == null) {
                instrumentedFor = new IntHashSet(0, 1.0f);
                classForest.getWeak(loader).get(className).set(2, instrumentedFor);
            }
            int origSize = instrumentedFor.size();
            instrumentedFor.add(rootName);
            boolean bl = changeInInstrumentation = origSize != instrumentedFor.size();
            if (!(!changeInInstrumentation || classForest.getWeak(loader).get(className).get(1) == null || classForest.getWeak(loader).get(className).get(1).size() <= 0 || classesBeingRetransformed.containsKey(className) && classesBeingRetransformed.get(className).contains(realLoader))) {
                SubtreeRetransformer retransformClasses = new SubtreeRetransformer(className, loader, true, rootName);
                heartbeat.addBehavior(retransformClasses, "Retransforming Classes for Deep Inheritance", true, 2000L, false, 1);
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    private static boolean runMatch(int rootName, IModeledClass classToMatch, boolean shouldMatchShallow, boolean isRootAnAnnotation) {
        int thisClassName = classNameForest.addAndGetID(classToMatch.getClassName().getReflectionFriendlyQualifiedNameString());
        ClassLoader thisClassLoader = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(classToMatch.getClassLoader());
        if (thisClassLoader == null) {
            thisClassLoader = bootstrapClassLoader;
        }
        if (isRootAnAnnotation) {
            if (classForest.getWeak(thisClassLoader).get(thisClassName).get(3) != null && classForest.getWeak(thisClassLoader).get(thisClassName).get(3).contains(rootName)) {
                if (shouldMatchShallow && classForest.getWeak(thisClassLoader).get(thisClassName).get(1) != null && classForest.getWeak(thisClassLoader).get(thisClassName).get(1).size() > 0) {
                    SubtreeRetransformer shallowRetransform = new SubtreeRetransformer(thisClassName, thisClassLoader, true, rootName, true);
                    heartbeat.addBehavior(shallowRetransform, "Shallow Retransformation for annotations", true, 2000L, false, 1);
                }
                return true;
            }
        } else if (thisClassName == rootName) {
            return !shouldMatchShallow;
        }
        if (classForest.getWeak(thisClassLoader).get(thisClassName).get(0) != null) {
            LinkedList<Object> levelOrderTraversalQ = new LinkedList<Object>();
            for (IntSetEntry entry : classForest.getWeak(thisClassLoader).get(thisClassName).get(0)) {
                levelOrderTraversalQ.add(entry.getValue());
            }
            ClassLoader startingPoint = thisClassLoader;
            block1: while (levelOrderTraversalQ.peek() != null) {
                Object item = levelOrderTraversalQ.poll();
                if (item instanceof ClassLoader) {
                    startingPoint = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded((ClassLoader)item);
                    continue;
                }
                int parentClassName = (Integer)item;
                if (!isRootAnAnnotation) {
                    if (parentClassName == rootName) {
                        return true;
                    }
                    if (shouldMatchShallow) continue;
                }
                ClassLoader traversalLoader = startingPoint;
                while (true) {
                    if (traversalLoader == null) {
                        traversalLoader = bootstrapClassLoader;
                    }
                    if (classForest.containsWeakKey(traversalLoader = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(traversalLoader)) && classForest.getWeak(traversalLoader).containsKey(parentClassName)) {
                        if (isRootAnAnnotation && classForest.getWeak(traversalLoader).get(parentClassName).get(3) != null && classForest.getWeak(traversalLoader).get(parentClassName).get(3).contains(rootName)) {
                            return true;
                        }
                        if (!shouldMatchShallow) {
                            if (classForest.getWeak(traversalLoader).get(parentClassName).get(2) != null && classForest.getWeak(traversalLoader).get(parentClassName).get(2).contains(rootName)) {
                                return true;
                            }
                            levelOrderTraversalQ.offer(traversalLoader);
                            if (classForest.getWeak(traversalLoader).get(parentClassName).get(0) != null) {
                                for (IntSetEntry entry : classForest.getWeak(traversalLoader).get(parentClassName).get(0)) {
                                    levelOrderTraversalQ.add(entry.getValue());
                                }
                            }
                        }
                    }
                    if (traversalLoader == bootstrapClassLoader) continue block1;
                    traversalLoader = traversalLoader.getParent();
                }
            }
        }
        return false;
    }

    private static boolean isDirectMatchPossible(int rootName, IModeledClass cls, boolean isRootAnAnnotation) {
        int thisClassName = classNameForest.getIDIfExists(cls.getClassName().getReflectionFriendlyQualifiedNameString());
        ClassLoader thisClassLoader = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(cls.getClassLoader());
        if (thisClassLoader == null) {
            thisClassLoader = bootstrapClassLoader;
        }
        if (isRootAnAnnotation) {
            if (classForest.getWeak(thisClassLoader).get(thisClassName).get(3) != null && classForest.getWeak(thisClassLoader).get(thisClassName).get(3).contains(rootName)) {
                return true;
            }
        } else {
            if (thisClassName == rootName) {
                return true;
            }
            if (classForest.getWeak(thisClassLoader).get(thisClassName).get(0) != null && classForest.getWeak(thisClassLoader).get(thisClassName).get(0).contains(rootName)) {
                return true;
            }
        }
        return false;
    }

    private static synchronized boolean doesRootClassExist(int rootClassName, ClassLoader startingPoint) {
        while (true) {
            if (startingPoint == null) {
                startingPoint = bootstrapClassLoader;
            }
            if (classForest.containsWeakKey(startingPoint = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(startingPoint)) && classForest.getWeak(startingPoint).containsKey(rootClassName)) {
                return true;
            }
            if (startingPoint == bootstrapClassLoader) break;
            startingPoint = startingPoint.getParent();
        }
        rootNotFound.add(rootClassName);
        return false;
    }

    public static boolean matchForClass(int rootClassName, IModeledClass classToMatch, boolean shouldMatchShallow) {
        if (!isInitialized) {
            return false;
        }
        if (isDebugOn && debugForRoot.contains(rootClassName)) {
            System.out.print("");
        }
        if (!(DeepInheritanceHelper.isDirectMatchPossible(rootClassName, classToMatch, false) || shouldMatchShallow || DeepInheritanceHelper.doesRootClassExist(rootClassName, classToMatch.getClassLoader()))) {
            return false;
        }
        if (DeepInheritanceHelper.runMatch(rootClassName, classToMatch, shouldMatchShallow, false)) {
            if (!shouldMatchShallow) {
                DeepInheritanceHelper.updateInstrumentedFor(classToMatch.getClassLoader(), classNameForest.getIDIfExists(classToMatch.getClassName().getReflectionFriendlyQualifiedNameString()), rootClassName);
            }
            return true;
        }
        return false;
    }

    private static synchronized boolean doesRootAnnotationExist(int rootAnnotationName, ClassLoader startingPoint, boolean isForShallowMatch) {
        while (true) {
            if (startingPoint == null) {
                startingPoint = bootstrapClassLoader;
            }
            if (annotationForest.containsWeakKey(startingPoint = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(startingPoint)) && annotationForest.getWeak(startingPoint).contains(rootAnnotationName)) {
                return true;
            }
            if (startingPoint == bootstrapClassLoader) break;
            startingPoint = startingPoint.getParent();
        }
        if (isForShallowMatch) {
            if (!rootNotFound.contains(rootAnnotationName)) {
                shallowRootNotFound.add(rootAnnotationName);
            }
        } else {
            shallowRootNotFound.remove(rootAnnotationName);
            rootNotFound.add(rootAnnotationName);
        }
        return false;
    }

    public static boolean matchForAnnotation(int rootAnnotationName, IModeledClass classToMatch, boolean shouldMatchShallow) {
        if (!isInitialized) {
            return false;
        }
        if (isDebugOn && debugForRoot.contains(rootAnnotationName)) {
            System.out.print("");
        }
        if (!DeepInheritanceHelper.isDirectMatchPossible(rootAnnotationName, classToMatch, true) && !DeepInheritanceHelper.doesRootAnnotationExist(rootAnnotationName, classToMatch.getClassLoader(), shouldMatchShallow)) {
            return false;
        }
        if (DeepInheritanceHelper.runMatch(rootAnnotationName, classToMatch, shouldMatchShallow, true)) {
            if (!shouldMatchShallow) {
                DeepInheritanceHelper.updateInstrumentedFor(classToMatch.getClassLoader(), classNameForest.getIDIfExists(classToMatch.getClassName().getReflectionFriendlyQualifiedNameString()), rootAnnotationName);
            }
            return true;
        }
        return false;
    }

    private static final class SubtreeRetransformer
    implements ITimestampedRunnable {
        private int rootClassName;
        private ClassLoader rootClassLoader;
        private int instrumentFor;
        boolean skipRoot;
        private boolean shallowRetransformation;

        SubtreeRetransformer(int rootClassName, ClassLoader rootClassLoader, boolean skipRoot) {
            this.rootClassName = rootClassName;
            this.rootClassLoader = rootClassLoader == null ? bootstrapClassLoader : rootClassLoader;
            this.skipRoot = skipRoot;
            this.instrumentFor = 0;
            this.shallowRetransformation = false;
        }

        public SubtreeRetransformer(int rootClassName, ClassLoader rootClassLoader, boolean skipRoot, int instrumentFor) {
            this.rootClassName = rootClassName;
            this.rootClassLoader = rootClassLoader == null ? bootstrapClassLoader : rootClassLoader;
            this.skipRoot = skipRoot;
            this.instrumentFor = instrumentFor;
            this.shallowRetransformation = false;
        }

        public SubtreeRetransformer(int rootClassName, ClassLoader rootClassLoader, boolean skipRoot, int instrumentFor, boolean shallowRetransformation) {
            this.rootClassName = rootClassName;
            this.rootClassLoader = rootClassLoader == null ? bootstrapClassLoader : rootClassLoader;
            this.skipRoot = skipRoot;
            this.instrumentFor = instrumentFor;
            this.shallowRetransformation = shallowRetransformation;
        }

        private PrimitiveIntSet calculateInstrumentFor() {
            int annotation;
            boolean hasAnnotations;
            IntHashSet instrumentFor = new IntHashSet();
            if (this.instrumentFor != 0) {
                instrumentFor.add(this.instrumentFor);
            }
            if (rootNotFound.contains(this.rootClassName)) {
                instrumentFor.add(this.rootClassName);
            }
            IntHashSet annotationsToConsider = new IntHashSet();
            boolean bl = hasAnnotations = ((List)((PrimitiveIntObjMap)classForest.getWeak(this.rootClassLoader)).get(this.rootClassName)).get(3) != null;
            if (hasAnnotations) {
                for (IntSetEntry entry : (PrimitiveIntSet)((List)((PrimitiveIntObjMap)classForest.getWeak(this.rootClassLoader)).get(this.rootClassName)).get(3)) {
                    annotation = entry.getValue();
                    if (!rootNotFound.contains(annotation)) continue;
                    annotationsToConsider.add(annotation);
                }
            }
            for (IntSetEntry entry : annotationsToConsider) {
                instrumentFor.add(entry.getValue());
            }
            if (hasAnnotations && instrumentFor.size() == 0) {
                for (IntSetEntry entry : (PrimitiveIntSet)((List)((PrimitiveIntObjMap)classForest.getWeak(this.rootClassLoader)).get(this.rootClassName)).get(3)) {
                    annotation = entry.getValue();
                    if (!shallowRootNotFound.contains(annotation)) continue;
                    annotationsToConsider.add(annotation);
                }
                if (annotationsToConsider.size() > 0) {
                    for (IntSetEntry entry : annotationsToConsider) {
                        instrumentFor.add(entry.getValue());
                    }
                    this.shallowRetransformation = true;
                }
            }
            return instrumentFor;
        }

        /*
         * Unable to fully structure code
         */
        private ClassLoader getCommonAncestor(ClassLoader l1, ClassLoader l2) {
            if (l1 == l2) {
                return l1;
            }
            possbileMatches = new HashSet<ClassLoader>();
            while (true) {
                possbileMatches.add(l1);
                if (l1 == null) ** GOTO lbl11
                l1 = l1.getParent();
            }
lbl-1000:
            // 1 sources

            {
                l2 = l2.getParent();
lbl11:
                // 2 sources

                ** while (!possbileMatches.contains((Object)l2))
            }
lbl12:
            // 1 sources

            returnLoader = l2;
            if (returnLoader == null) {
                returnLoader = DeepInheritanceHelper.access$0();
            }
            return AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(returnLoader);
        }

        private LinkedHashMap<Integer, WeakHashMap<ClassLoader, Class<?>>> calculateClassesToInstrument(PrimitiveIntSet instrumentFor) {
            LinkedHashMap classesToInstrument = new LinkedHashMap();
            if (instrumentFor.size() == 0) {
                return classesToInstrument;
            }
            Stack<Pair> nameStack = new Stack<Pair>();
            if (!this.skipRoot) {
                nameStack.push(new Pair(this.rootClassName, 0, this.rootClassLoader));
            }
            if ((this.skipRoot || this.shallowRetransformation) && ((List)((PrimitiveIntObjMap)classForest.getWeak(this.rootClassLoader)).get(this.rootClassName)).get(1) != null) {
                for (IntSetEntry subclassEntry : (PrimitiveIntSet)((List)((PrimitiveIntObjMap)classForest.getWeak(this.rootClassLoader)).get(this.rootClassName)).get(1)) {
                    nameStack.push(new Pair(subclassEntry.getValue(), this.rootClassName, this.rootClassLoader));
                }
            }
            while (!nameStack.empty()) {
                Pair root = (Pair)nameStack.pop();
                int name = root.className;
                int parentName = root.parentClassName;
                ClassLoader rootLoader = root.startingPoint;
                Stack<ClassLoader> loaderStack = new Stack<ClassLoader>();
                loaderStack.push(rootLoader);
                int classesToBeInstrumented = 0;
                ClassLoader nextStartingPoint = null;
                while (!loaderStack.empty()) {
                    WeakHashSet subClassLoaders;
                    ClassLoader loader = (ClassLoader)loaderStack.pop();
                    if (classForest.containsWeakKey(loader) && ((PrimitiveIntObjMap)classForest.getWeak(loader)).containsKey(name) && (parentName == 0 || ((List)((PrimitiveIntObjMap)classForest.getWeak(loader)).get(name)).get(0) != null && ((PrimitiveIntSet)((List)((PrimitiveIntObjMap)classForest.getWeak(loader)).get(name)).get(0)).contains(parentName))) {
                        nextStartingPoint = nextStartingPoint == null ? loader : this.getCommonAncestor(nextStartingPoint, loader);
                        IntHashSet instrumentedFor = new IntHashSet(0, 1.0f);
                        if (((List)((PrimitiveIntObjMap)classForest.getWeak(loader)).get(name)).get(2) != null) {
                            for (IntSetEntry entry : (PrimitiveIntSet)((List)((PrimitiveIntObjMap)classForest.getWeak(loader)).get(name)).get(2)) {
                                instrumentedFor.add(entry.getValue());
                            }
                        } else {
                            ((List)((PrimitiveIntObjMap)classForest.getWeak(loader)).get(name)).set(2, new IntHashSet(0, 1.0f));
                        }
                        int origSize = instrumentedFor.size();
                        for (IntSetEntry entry : instrumentFor) {
                            instrumentedFor.add(entry.getValue());
                        }
                        if (instrumentedFor.size() > origSize) {
                            if (!classesToInstrument.containsKey(name)) {
                                classesToInstrument.put(name, new WeakHashMap());
                            }
                            classesToInstrument.get(name).put(loader, null);
                            ++classesToBeInstrumented;
                            if (!this.shallowRetransformation) {
                                for (IntSetEntry entry : instrumentedFor) {
                                    ((PrimitiveIntSet)((List)((PrimitiveIntObjMap)classForest.getWeak(loader)).get(name)).get(2)).add(entry.getValue());
                                }
                            }
                        }
                    }
                    if (!classLoaderHierarchy.containsWeakKey(loader) || (subClassLoaders = (WeakHashSet)classLoaderHierarchy.getWeak(loader)) == null) continue;
                    loaderStack.addAll(subClassLoaders.keySet());
                }
                if (classesToBeInstrumented == 0 || this.shallowRetransformation) continue;
                try {
                    if (((List)((PrimitiveIntObjMap)classForest.getWeak(rootLoader)).get(name)).get(1) == null) continue;
                    for (IntSetEntry subclassEntry : (PrimitiveIntSet)((List)((PrimitiveIntObjMap)classForest.getWeak(rootLoader)).get(name)).get(1)) {
                        nameStack.push(new Pair(subclassEntry.getValue(), name, nextStartingPoint));
                    }
                }
                catch (NullPointerException nullPointerException) {}
            }
            return classesToInstrument;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void ITimestampedRunnable_execute(long l) {
            try {
                void var5_8;
                LinkedHashMap<Integer, WeakHashMap<ClassLoader, Class<?>>> classesToInstrument = this.calculateClassesToInstrument(this.calculateInstrumentFor());
                if (classesToInstrument.size() == 0) {
                    return;
                }
                Class[] classArray = instrumentationDelegate.getAllLoadedClasses();
                int n = classArray.length;
                boolean n2 = false;
                while (var5_8 < n) {
                    Class c = classArray[var5_8];
                    if (classesToInstrument.containsKey(classNameForest.getIDIfExists(c.getName()))) {
                        ClassLoader loader = c.getClassLoader() == null ? bootstrapClassLoader : c.getClassLoader();
                        loader = AggregateClassLoader.substituteAggregateClassLoaderIfNeeded(loader);
                        if (classesToInstrument.get(classNameForest.getIDIfExists(c.getName())).containsKey(loader)) {
                            classesToInstrument.get(classNameForest.getIDIfExists(c.getName())).put(loader, c);
                        }
                    }
                    ++var5_8;
                }
                ArrayList optimizedClassesToInstrument = new ArrayList();
                for (WeakHashMap<ClassLoader, Class<?>> weakHashMap : classesToInstrument.values()) {
                    for (Class<?> c : weakHashMap.values()) {
                        if (c == null) continue;
                        optimizedClassesToInstrument.add(c);
                    }
                }
                for (Class clazz : optimizedClassesToInstrument) {
                    retransformationLock.lock();
                    if (!classesBeingRetransformed.containsKey(classNameForest.getIDIfExists(clazz.getName()))) {
                        classesBeingRetransformed.put(classNameForest.getIDIfExists(clazz.getName()), new HashSet());
                    }
                    ((Set)classesBeingRetransformed.get(classNameForest.getIDIfExists(clazz.getName()))).add(clazz.getClassLoader());
                    retransformationLock.unlock();
                    if (transformer.shouldRetransform(clazz)) {
                        instrumentationDelegate.retransformClasses(kModule, clazz);
                    } else {
                        logger.debug(kModule, "Class " + clazz.getName() + " is being skipped");
                    }
                    retransformationLock.lock();
                    ((Set)classesBeingRetransformed.get(classNameForest.getIDIfExists(clazz.getName()))).remove(clazz.getClassLoader());
                    if (((Set)classesBeingRetransformed.get(classNameForest.getIDIfExists(clazz.getName()))).size() == 0) {
                        classesBeingRetransformed.remove(classNameForest.getIDIfExists(clazz.getName()));
                    }
                    retransformationLock.unlock();
                }
            }
            catch (Throwable t) {
                logger.trace(kModule, "Retransfroming sub tree for class " + this.rootClassName + " in classloader " + this.rootClassLoader.getClass().getName() + " failed.", t);
            }
        }
    }
}

