/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.external.biz.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Random;

public class GUIDKeyGenerator {
    private static GUIDKeyGenerator instance = null;
    private Random seeder;
    private String hostAndSystemID;
    static final char[] kcharsHexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final String kstDefaultHost = "00000000";

    private GUIDKeyGenerator() {
        byte[] addr;
        try {
            this.seeder = new SecureRandom();
            this.seeder.nextInt();
        }
        catch (Throwable throwable) {
            System.out.println("Using Random class for GUID generation");
            this.seeder = new Random();
            this.seeder.nextInt();
        }
        StringBuilder buffer = new StringBuilder(16);
        try {
            addr = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            addr = kstDefaultHost.getBytes();
        }
        buffer.append(GUIDKeyGenerator.toHex(GUIDKeyGenerator.toInt(addr), 8));
        buffer.append(GUIDKeyGenerator.toHex(System.identityHashCode(this), 8));
        this.hostAndSystemID = buffer.toString();
    }

    public static GUIDKeyGenerator getInstance() {
        if (instance == null) {
            instance = new GUIDKeyGenerator();
        }
        return instance;
    }

    public String generateKey() {
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(GUIDKeyGenerator.toHex((int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL), 8));
        buffer.append(this.hostAndSystemID);
        buffer.append(GUIDKeyGenerator.toHex(this.seeder.nextInt(), 8));
        return buffer.toString();
    }

    private static String toHex(int value, int length) {
        StringBuilder buffer = new StringBuilder(length);
        int shift = length - 1 << 2;
        int i = -1;
        while (++i < length) {
            buffer.append(kcharsHexDigits[value >> shift & 0xF]);
            value <<= 4;
        }
        return buffer.toString();
    }

    private static int toInt(byte[] bytes) {
        int value = 0;
        int i = -1;
        while (++i < bytes.length) {
            value <<= 8;
            int b = bytes[i] & 0xFF;
            value |= b;
        }
        return value;
    }

    public boolean fromSameHost(String guidString) {
        String guidHostAndId = guidString.substring(8, 24);
        return guidHostAndId.equals(this.hostAndSystemID);
    }
}

