/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.batch;

import java.io.File;
import java.util.Vector;

public class DGFileSettings {
    private boolean fShouldCopyItems;
    private boolean fShouldFlushDestination;
    private Vector fSkipDeletionFiles;
    private Vector fIgnoredFiles;

    public DGFileSettings() {
        this(true);
    }

    public DGFileSettings(boolean shouldCopyItems) {
        this.fShouldCopyItems = shouldCopyItems;
        this.fShouldFlushDestination = false;
        this.fSkipDeletionFiles = new Vector();
        this.fIgnoredFiles = new Vector();
    }

    public boolean shouldCopyItems() {
        return this.fShouldCopyItems;
    }

    public void setShouldCopyItems(boolean shouldCopyItems) {
        this.fShouldCopyItems = shouldCopyItems;
    }

    public boolean shouldFlushDestination() {
        return this.fShouldFlushDestination;
    }

    public void setShouldFlushDestination(boolean shouldFlushDestination) {
        this.fShouldFlushDestination = shouldFlushDestination;
    }

    public void addSkippedFile(File file) {
        if (file != null) {
            this.fSkipDeletionFiles.addElement(file);
        }
    }

    public boolean skipFileDeletion(File file) {
        return this.fSkipDeletionFiles.contains(file);
    }

    public void addIgnoredFile(File file) {
        if (file != null) {
            this.fIgnoredFiles.addElement(file);
        }
    }

    public void addIgnoredFiles(File[] files) {
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                this.addIgnoredFile(files[i]);
                ++i;
            }
        }
    }

    public boolean shouldIgnoreFile(File file) {
        return this.fIgnoredFiles.contains(file);
    }
}

