/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives.parser;

import com.wily.diagnos.cmp.directives.AgentInitializationDirective;
import com.wily.diagnos.cmp.directives.CatchExceptionDirective;
import com.wily.diagnos.cmp.directives.IDirective;
import com.wily.diagnos.cmp.directives.InvalidDirectiveException;
import com.wily.diagnos.cmp.directives.ThrowExceptionDirective;
import com.wily.diagnos.cmp.directives.parser.ASingleDirectiveParser;
import com.wily.diagnos.cmp.directives.parser.DGParserException;
import com.wily.util.classfile.ClassFileException;
import com.wily.util.classfile.IClassSchemaPolicy;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;

public final class InstrumentPointDirectiveParser
extends ASingleDirectiveParser {
    private static final String kExceptionParsingInvalidInstrumentationPointMessage = "Syntax Error - Invalid instrumentation point: ";

    @Override
    public int getArgumentCount() {
        return 1;
    }

    @Override
    public String getDirectiveKeyword() {
        return "InstrumentPoint:";
    }

    @Override
    public ILocalizableMessage getHelpMessage(String keyword) {
        return new FormattedLocalizableMessage("Diagnos_Parsing_Expected_Syntax_Help_Message", (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Parsing_InstrumentPoint_Argument_Syntax_Key", this.getDirectiveKeyword()));
    }

    @Override
    public IDirective parseDirective(IClassSchemaPolicy schemaPolicy, String keyword, String[] arguments, String source, int lineNumber) throws ClassFileException, DGParserException, InvalidDirectiveException {
        String instrumentPoint = arguments[0].toLowerCase();
        if (instrumentPoint.equals("ThrowException".toLowerCase())) {
            return new ThrowExceptionDirective(source, lineNumber);
        }
        if (instrumentPoint.equals("CatchException".toLowerCase())) {
            return new CatchExceptionDirective(source, lineNumber);
        }
        if (instrumentPoint.equals("AgentInitialization".toLowerCase())) {
            return new AgentInitializationDirective(source, lineNumber);
        }
        throw new DGParserException(kExceptionParsingInvalidInstrumentationPointMessage + arguments[0], (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Exception_Parsing_Invalid_Instrumentation_Point", arguments[0]));
    }
}

