/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.mutate;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.cmp.transform.InsertOnSocketIOTransformation;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.diagnos.personality.java.mutate.AJavaMethodMutation;
import com.wily.util.classfile.IModeledMethod;
import java.io.IOException;

public final class InsertOnSocketIOMutation
extends AJavaMethodMutation {
    private final InsertOnSocketIOTransformation fTransform;
    private int parameterChoice;

    public InsertOnSocketIOMutation(DGCompilerSettings settings, IClassMutator mutator, InsertOnSocketIOTransformation transform, IModeledMethod targetMethod) {
        super(settings, mutator, targetMethod);
        this.fTransform = transform;
        this.parameterChoice = this.getParameterChoice(targetMethod);
    }

    private int getParameterChoice(IModeledMethod targetMethod) {
        String compare = "" + targetMethod.getSignature();
        if ("[B".equals(compare = compare.substring(1, compare.length() - 2))) {
            return 1;
        }
        if ("I".equals(compare)) {
            return 2;
        }
        if ("[BII".equals(compare)) {
            return 3;
        }
        return -1;
    }

    @Override
    protected void doMutate(DGMethod target) throws DGClassModificationException, IOException {
        if (target.getName().startsWith("read")) {
            target.insertStaticMethodAtSocketRead(this.fTransform.getInsertionMethod().toString());
        } else {
            target.insertStaticMethodAtSocketWrite(this.fTransform.getInsertionMethod().toString(), this.parameterChoice);
        }
    }
}

