/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.net;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureBlameStack;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureStackEntry;
import com.wily.introscope.agent.blamestackfeature.IBlameStackFeature;
import com.wily.introscope.agent.probe.net.IDefaultBackendFeature;
import com.wily.wilyassert.Assertion;

public class DefaultBackendFeature
implements IBlameStackFeature,
IDefaultBackendFeature {
    private String defaultBackend;
    private boolean backendWasTouchedInMostRecentBlameFrame;
    private String fHostName;
    private int fPort;
    private String component;
    private final BlameStackFeatureBlameStack fStack;

    public DefaultBackendFeature(BlameStackFeatureBlameStack stack) {
        this.fStack = stack;
    }

    @Override
    public void onBeforePush(BlameStackFeatureStackEntry entry) {
        this.backendWasTouchedInMostRecentBlameFrame = false;
        this.component = entry.getComponent();
    }

    @Override
    public void onAfterPop(BlameStackFeatureStackEntry poppedEntry, BlameStackFeatureStackEntry newTopEntry) {
    }

    @Override
    public void tearDown() {
        this.defaultBackend = null;
        this.backendWasTouchedInMostRecentBlameFrame = false;
    }

    @Override
    public void setDefaultBackend(String defaultBackendMetricName, String hostName, int port) {
        Assertion.wilyAssert(false);
        this.fHostName = hostName == null ? "localhost" : hostName;
        this.fPort = port;
        this.defaultBackend = defaultBackendMetricName;
        this.backendWasTouchedInMostRecentBlameFrame = true;
        if (this.backendWasTouchedInMostRecentBlameFrame()) {
            try {
                this.fStack.setDefaultBackendComponent(this.component, this.defaultBackend);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.getAgent().IAgent_getModuleFeedback().error("Error in default backend feature", t);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public boolean backendWasTouchedInMostRecentBlameFrame() {
        return this.backendWasTouchedInMostRecentBlameFrame;
    }

    public String getDefaultBackend() {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        return this.defaultBackend;
    }

    @Override
    public String getHost() {
        Assertion.wilyAssert(false);
        return this.fHostName;
    }

    @Override
    public int getPort() {
        Assertion.wilyAssert(false);
        return this.fPort;
    }

    @Override
    public void setFrontBoundary(String component) {
    }

    @Override
    public void setEndBoundary(String component) {
    }

    @Override
    public void reset() {
    }
}

