/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.remote.arf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.remote.arf.AArfConnection;
import com.wily.introscope.agent.remote.arf.ArfException;
import com.wily.introscope.agent.remote.arf.ArfMessage;

public abstract class ArfCommandConnection
extends AArfConnection {
    private Object fPingMonitor = new Object();
    private long fLastPingResponseTime = System.currentTimeMillis();

    public ArfCommandConnection(IAgent agent, String connectMessage) throws ArfException {
        super(agent, connectMessage);
        ArfMessage m = ArfMessage.parseMessage(connectMessage);
        if (m.isInstIdSet()) {
            this.fInstanceId = m.getInstId();
        }
        if (m.isProgramSet()) {
            this.fProgram = m.getProgram();
        }
        if (m.isProbeSet()) {
            this.fProbe = m.getProbe();
        }
        if (m.isPidSet()) {
            this.fPid = m.getPid();
        }
        if (m.isTidSet()) {
            this.fTid = m.getTid();
        }
    }

    public ArfCommandConnection(IAgent agent) {
        super(agent);
    }

    @Override
    public String toString() {
        return "ArfCommandConnection " + (this.isClient() ? "Client" : "Server");
    }

    @Override
    protected void processMessage(ArfMessage m) {
        if (m.getOp().equals("arf")) {
            this.pingResponse();
            return;
        }
        if (m.getOp().equals("speak")) {
            this.sendNow(new ArfMessage("arf").writeMessage());
            return;
        }
        if (this.fListener != null) {
            this.fListener.processMessage(this, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pingConnection(long maxPingDelay) {
        this.sendNow(new ArfMessage("speak").writeMessage());
        Object object = this.fPingMonitor;
        synchronized (object) {
            block4: {
                if (this.fLastPingResponseTime >= System.currentTimeMillis() - maxPingDelay) break block4;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pingResponse() {
        Object object = this.fPingMonitor;
        synchronized (object) {
            this.fLastPingResponseTime = System.currentTimeMillis();
        }
    }
}

