/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.cas.ICounterRepository;
import com.wily.introscope.agent.trace.cas.IGathererElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.SharedDataStructure;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class SharedDataStructure5
implements ICounterRepository {
    private static final int[] sleepTimes = new int[]{30, 50, 170, 370, 190, 10};
    private static final int sizeSleep = 5;
    private int sleepCount = 0;
    private final SynchronizedCounter counter;
    private volatile boolean fTouched;
    private volatile boolean fShutOff = false;

    public SharedDataStructure5(boolean shouldBeConsumed) {
        this.counter = new SynchronizedCounter(shouldBeConsumed);
        this.fTouched = true;
    }

    @Override
    public void offer(ISharedElement offered) {
        throw new Error("Not implemented");
    }

    public String toString() {
        return String.valueOf(Thread.currentThread().getName()) + " value = " + this.counter.getValue();
    }

    @Override
    public ISharedElement get() {
        throw new Error("get not implemented");
    }

    @Override
    public void reset() {
        this.fTouched = true;
        this.counter.reset();
    }

    @Override
    public ISharedElement read() {
        ISharedElement result = this.counter.getSharedElementInstance();
        return this.read(result);
    }

    @Override
    public ISharedElement read(ISharedElement result) {
        result.merge(this.counter);
        if (this.counter.shouldBeConsumendOnRead()) {
            this.counter.reset();
        } else {
            this.counter.resetMinMax();
        }
        this.fTouched = false;
        return result;
    }

    public IRepository getInstance(ISharedElement instance) {
        return new SharedDataStructure(instance);
    }

    @Override
    public void update(IUpdater updater, long value, long startTime, int hashcode) {
        this.fTouched = true;
        updater.update(this.counter, value, startTime);
    }

    @Override
    public boolean hasNotChanged() {
        return !this.fTouched;
    }

    @Override
    public void update(IUpdater updater, long value, long startTime, long endTime) {
        this.update(updater, value, startTime, 0);
    }

    @Override
    public ISharedElement read(IRepository.IRepositorySustainabilityCallback callback) {
        return this.read();
    }

    @Override
    public boolean shouldBeHarvested() {
        return !this.counter.shouldBeConsumendOnRead() || this.fTouched;
    }

    @Override
    public void increase(long time) {
        this.fTouched = true;
        this.counter.increase(time);
    }

    @Override
    public void decrease(long time) {
        this.fTouched = true;
        this.counter.decrease(time);
    }

    @Override
    public ISharedElement getSharedElementInstance() {
        return this.counter.getSharedElementInstance();
    }

    @Override
    public void cleanup(boolean offerBack) {
        if (!offerBack) {
            this.reset();
        }
    }

    @Override
    public void setShutOff(boolean shutOff) {
        this.fShutOff = shutOff;
    }

    @Override
    public boolean isShutOff() {
        return this.fShutOff;
    }

    public static class SynchronizedCounter
    implements ISharedElement {
        volatile long fValue;
        volatile long fCount;
        volatile long fMinimum;
        volatile long fMaximum;
        volatile long fStart;
        final boolean shouldBeConsumed;
        final Object monitor = new Object();

        public SynchronizedCounter(boolean shouldBeConsumedOnRead) {
            this.shouldBeConsumed = shouldBeConsumedOnRead;
        }

        public void add(long delta, long count, long otherMinimum, long otherMaximum) {
            if (count == 0L) {
                return;
            }
            this.forceAdd(delta, count, otherMinimum, otherMaximum);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forceAdd(long delta, long count, long otherMinimum, long otherMaximum) {
            Object object = this.monitor;
            synchronized (object) {
                this.fValue += delta;
                if (this.fCount == 0L || otherMinimum < this.fMinimum) {
                    this.fMinimum = otherMinimum;
                }
                if (this.fCount == 0L || otherMaximum > this.fMaximum) {
                    this.fMaximum = otherMaximum;
                }
            }
            this.fCount += count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            Object object = this.monitor;
            synchronized (object) {
                this.fValue = 0L;
                this.fCount = 0L;
                this.fMinimum = 0L;
                this.fMaximum = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetMinMax() {
            Object object = this.monitor;
            synchronized (object) {
                this.fMinimum = this.fValue;
                this.fMaximum = this.fValue;
                this.fCount = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(long value) {
            Object object = this.monitor;
            synchronized (object) {
                this.fValue = value;
                this.syncSinglePointBounds(this.fValue);
                ++this.fCount;
            }
        }

        protected void directSetIntValue(long value) {
            this.fValue = value;
        }

        protected void directSetIntMinimum(long minimum) {
            this.fMinimum = minimum;
        }

        protected void directSetIntMaximum(long maximum) {
            this.fMaximum = maximum;
        }

        @Override
        public long getValue() {
            return this.fValue;
        }

        @Override
        public long getMinimum() {
            return this.fMinimum;
        }

        @Override
        public long getMaximum() {
            return this.fMaximum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subtract(int delta) {
            Object object = this.monitor;
            synchronized (object) {
                this.fValue -= (long)delta;
                this.syncSinglePointBounds(this.fValue);
                ++this.fCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(long delta) {
            Object object = this.monitor;
            synchronized (object) {
                this.fValue += delta;
                this.syncSinglePointBounds(this.fValue);
                ++this.fCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void increase() {
            Object object = this.monitor;
            synchronized (object) {
                if (this.fValue == this.fMaximum) {
                    ++this.fMaximum;
                    if (this.fCount == 0L) {
                        this.fMinimum = this.fMaximum;
                    }
                }
                ++this.fValue;
                ++this.fCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decrease() {
            Object object = this.monitor;
            synchronized (object) {
                if (this.fValue == this.fMinimum) {
                    --this.fMinimum;
                    if (this.fCount == 0L) {
                        this.fMaximum = this.fMinimum;
                    }
                }
                --this.fValue;
                ++this.fCount;
            }
        }

        protected void syncSinglePointBounds(long value) {
            if (this.fCount > 0L) {
                if (value > this.fMaximum) {
                    this.fMaximum = value;
                }
                if (value < this.fMinimum) {
                    this.fMinimum = value;
                }
            } else {
                this.fMinimum = value;
                this.fMaximum = value;
            }
        }

        protected final void incrementDataPointCountNonSync() {
            ++this.fCount;
        }

        protected final void incrementDataPointCountNonSync(long deltaCount) {
            this.fCount += deltaCount;
        }

        public String toString() {
            return String.valueOf(this.fValue) + ";" + this.fCount + ";" + this.fMaximum + ";" + this.fMinimum;
        }

        @Override
        public long getCount() {
            return this.fCount;
        }

        @Override
        public IGathererElement getInstance() {
            return new SynchronizedCounter(this.shouldBeConsumed);
        }

        @Override
        public long getStartTimestamp() {
            return this.fStart;
        }

        @Override
        public void increase(long startTime) {
            this.increase();
            if (startTime < this.fStart) {
                this.fStart = startTime;
            }
        }

        @Override
        public void decrease(long startTime) {
            this.decrease();
            if (startTime < this.fStart) {
                this.fStart = startTime;
            }
        }

        @Override
        public void combineValue(long value) {
            this.add(value);
        }

        @Override
        public void combineTime(long startTime) {
            if (startTime < this.fStart) {
                this.fStart = startTime;
            }
        }

        @Override
        public void merge(IGathererElement other) {
            this.forceAdd(other.getValue(), other.getCount(), other.getMinimum(), other.getMaximum());
            this.combineTime(other.getStartTimestamp());
        }

        @Override
        public ISharedElement getSharedElementInstance() {
            return new SynchronizedCounter(this.shouldBeConsumed);
        }

        @Override
        public boolean shouldBeConsumendOnRead() {
            return this.shouldBeConsumed;
        }

        public void markClean() {
        }

        public boolean markDirty() {
            return false;
        }

        public boolean markRead() {
            return false;
        }

        public void forceDirty() {
        }

        public boolean isRead() {
            return false;
        }

        @Override
        public long getEndTimestamp() {
            return 0L;
        }

        @Override
        public void increase(long endTime, long startTime) {
            this.increase(startTime);
        }

        @Override
        public void decrease(long endTime, long startTime) {
            this.decrease(startTime);
        }

        @Override
        public void combineTime(long endTime, long startTime) {
            this.combineTime(startTime);
        }
    }

    public static class SynchronizedStateCounter
    implements ISharedElement {
        private static final int kCountZeroState = 0;
        volatile long fMinimum;
        volatile long fMaximum;
        volatile long fStart;
        final boolean shouldBeConsumed;
        private final AtomicInteger state = new AtomicInteger(0);
        private final AtomicLong value = new AtomicLong(0L);
        final Object monitor = new Object();

        public SynchronizedStateCounter(boolean shouldBeConsumedOnRead) {
            this.shouldBeConsumed = shouldBeConsumedOnRead;
        }

        public void add(long delta, long count, long otherMinimum, long otherMaximum) {
            if (count == 0L) {
                return;
            }
            this.forceAdd(delta, count, otherMinimum, otherMaximum);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void forceAdd(long delta, long count, long otherMinimum, long otherMaximum) {
            Object object = this.monitor;
            synchronized (object) {
                this.value.addAndGet(delta);
                if (this.state.get() == 0 || otherMinimum < this.fMinimum) {
                    this.fMinimum = otherMinimum;
                }
                if (this.state.get() == 0 || otherMaximum > this.fMaximum) {
                    this.fMaximum = otherMaximum;
                }
            }
            this.state.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            Object object = this.monitor;
            synchronized (object) {
                this.value.set(0L);
                this.state.set(0);
                this.fMinimum = 0L;
                this.fMaximum = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetMinMax() {
            Object object = this.monitor;
            synchronized (object) {
                long currentValue;
                this.fMinimum = currentValue = this.value.get();
                this.fMaximum = currentValue;
                this.state.set(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setValue(long input) {
            Object object = this.monitor;
            synchronized (object) {
                this.value.set(input);
                this.syncSinglePointBounds(input);
                this.state.incrementAndGet();
            }
        }

        protected void directSetIntValue(long fValue) {
            this.value.set(fValue);
        }

        protected void directSetIntMinimum(long minimum) {
            this.fMinimum = minimum;
        }

        protected void directSetIntMaximum(long maximum) {
            this.fMaximum = maximum;
        }

        @Override
        public long getValue() {
            return this.value.get();
        }

        @Override
        public long getMinimum() {
            return this.fMinimum;
        }

        @Override
        public long getMaximum() {
            return this.fMaximum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subtract(int delta) {
            Object object = this.monitor;
            synchronized (object) {
                long newValue = this.value.addAndGet(-1 * delta);
                this.syncSinglePointBounds(newValue);
                this.state.incrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(long delta) {
            Object object = this.monitor;
            synchronized (object) {
                long newValue = this.value.addAndGet(delta);
                this.syncSinglePointBounds(newValue);
                this.state.incrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void increase() {
            long modifiedCount = this.state.getAndIncrement();
            if (modifiedCount == 0L) {
                long newValue = this.value.getAndIncrement();
                if (newValue == this.fMaximum) {
                    Object object = this.monitor;
                    synchronized (object) {
                        ++this.fMaximum;
                        this.fMinimum = this.fMaximum;
                    }
                }
            } else {
                long newValue = this.value.getAndIncrement();
                if (newValue == this.fMaximum) {
                    Object object = this.monitor;
                    synchronized (object) {
                        ++this.fMaximum;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decrease() {
            long modifiedCount = this.state.getAndIncrement();
            if (modifiedCount == 0L) {
                long newValue = this.value.getAndDecrement();
                if (newValue == this.fMinimum) {
                    Object object = this.monitor;
                    synchronized (object) {
                        --this.fMinimum;
                        this.fMaximum = this.fMinimum;
                    }
                }
            } else {
                long newValue = this.value.getAndDecrement();
                Object object = this.monitor;
                synchronized (object) {
                    if (newValue == this.fMinimum) {
                        --this.fMinimum;
                    }
                }
            }
        }

        protected void syncSinglePointBounds(long value) {
            if (this.state.get() > 0) {
                if (value > this.fMaximum) {
                    this.fMaximum = value;
                }
                if (value < this.fMinimum) {
                    this.fMinimum = value;
                }
            } else {
                this.fMinimum = value;
                this.fMaximum = value;
            }
        }

        protected final void incrementDataPointCountNonSync() {
            this.state.incrementAndGet();
        }

        protected final void incrementDataPointCountNonSync(int deltaCount) {
            this.state.getAndAdd(deltaCount);
        }

        public String toString() {
            return this.value + ";" + this.state + ";" + this.fMaximum + ";" + this.fMinimum;
        }

        @Override
        public long getCount() {
            return this.state.get();
        }

        @Override
        public IGathererElement getInstance() {
            return new SynchronizedCounter(this.shouldBeConsumed);
        }

        @Override
        public long getStartTimestamp() {
            return this.fStart;
        }

        @Override
        public void increase(long startTime) {
            this.increase();
            if (startTime < this.fStart) {
                this.fStart = startTime;
            }
        }

        @Override
        public void decrease(long startTime) {
            this.decrease();
            if (startTime < this.fStart) {
                this.fStart = startTime;
            }
        }

        @Override
        public void combineValue(long value) {
            this.add(value);
        }

        @Override
        public void combineTime(long startTime) {
            if (startTime < this.fStart) {
                this.fStart = startTime;
            }
        }

        @Override
        public void merge(IGathererElement other) {
            this.forceAdd(other.getValue(), other.getCount(), other.getMinimum(), other.getMaximum());
            this.combineTime(other.getStartTimestamp());
        }

        @Override
        public ISharedElement getSharedElementInstance() {
            return new SynchronizedStateCounter(this.shouldBeConsumed);
        }

        @Override
        public boolean shouldBeConsumendOnRead() {
            return this.shouldBeConsumed;
        }

        public void markClean() {
        }

        public boolean markDirty() {
            return false;
        }

        public boolean markRead() {
            return false;
        }

        public void forceDirty() {
        }

        public boolean isRead() {
            return false;
        }

        @Override
        public long getEndTimestamp() {
            return 0L;
        }

        @Override
        public void increase(long endTime, long startTime) {
            this.increase(startTime);
        }

        @Override
        public void decrease(long endTime, long startTime) {
            this.decrease(startTime);
        }

        @Override
        public void combineTime(long endTime, long startTime) {
            this.combineTime(startTime);
        }
    }
}

