/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.AbstractTransactionElement;
import com.wily.introscope.agent.trace.cas.IMetricUpdater;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import com.wily.introscope.agent.trace.cas.ITransactionInstanceProvider;
import com.wily.introscope.agent.trace.cas.ITransactionStructure;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.transactiontrace.ITransactionEventListener;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;

public class TransactionStructure
implements ITransactionStructure,
IBlameStack {
    final ITransactionElement root;
    private static final CopyOnWriteArrayList sTransactionEventListeners = new CopyOnWriteArrayList();

    public TransactionStructure(ITransactionElementProvider provider) {
        this.root = provider.getElement("Root", null);
    }

    public void startTransactionTrigger(IStackElement data) {
        data.markStartTransaction();
        int size = sTransactionEventListeners.size();
        int i = 0;
        while (i < size) {
            ITransactionEventListener listener = (ITransactionEventListener)sTransactionEventListeners.get(i);
            listener.transactionStartedCallback(this.getAgent(), data);
            ++i;
        }
    }

    public void addComponentTrigger(IStackElement data) {
        int size = sTransactionEventListeners.size();
        int i = 0;
        while (i < size) {
            ITransactionEventListener listener = (ITransactionEventListener)sTransactionEventListeners.get(i);
            listener.transactionComponentAddCallback(this.getAgent(), data);
            ++i;
        }
    }

    public void preEndTransactionTrigger(IStackElement data) {
        int size = sTransactionEventListeners.size();
        int i = 0;
        while (i < size) {
            ITransactionEventListener listener = (ITransactionEventListener)sTransactionEventListeners.get(i);
            listener.preTransactionEndCallback(this.getAgent(), data);
            ++i;
        }
    }

    public void postEndTransactionTrigger(IStackElement data) {
        int size = sTransactionEventListeners.size();
        int i = 0;
        while (i < size) {
            ITransactionEventListener listener = (ITransactionEventListener)sTransactionEventListeners.get(i);
            listener.postTransactionEndCallback(this.getAgent(), data);
            ++i;
        }
    }

    protected boolean conditionalStartTransactionInstanceCreate(ITransactionInstanceProvider instanceProvider, IStackElement data, ITransactionElement element, int tracerIndex, boolean onStartTransaction, boolean doTrySampling) {
        return false;
    }

    protected void conditionalEndTransactionInstanceCreate(ITransactionInstanceProvider instanceProvider, IStackElement data, ITransactionElement element, int tracerIndex) {
    }

    protected void refreshTransactionCollectionStatus(IStackElement data) {
    }

    public ITransactionElement submitStartTransactionNoBlameTracer(Object transactionKey, int tracerIndex, IStackElement data, ITransactionElementProvider provider) {
        try {
            ITransactionElement element = this.root.goToChildStartTransaction(transactionKey, tracerIndex, data, provider);
            return element;
        }
        catch (ThreadDeath td) {
            this.abortTransaction(data);
            throw td;
        }
        catch (Throwable t) {
            this.abortTransaction(t, data);
            return null;
        }
    }

    @Override
    public ITransactionElement submitStartTransaction(Object transactionKey, int tracerIndex, IStackElement data, ITransactionElementProvider provider) {
        this.startTransactionTrigger(data);
        this.addComponentTrigger(data);
        try {
            ITransactionElement element = this.root.goToChildStartTransaction(transactionKey, tracerIndex, data, provider);
            data.setStartTransactionElement(element);
            return element.touch(data.getWallClockStartTime());
        }
        catch (ThreadDeath td) {
            this.abortTransaction(data);
            throw td;
        }
        catch (Throwable t) {
            this.abortTransaction(t, data);
            return null;
        }
    }

    @Override
    public ITransactionElement submitStartTransaction(Object transactionKey, int tracerIndex, IStackElement data, ITransactionElementProvider provider, ITransactionInstanceProvider instanceProvider) {
        this.startTransactionTrigger(data);
        this.addComponentTrigger(data);
        try {
            ITransactionElement element = this.root.goToChildStartTransaction(transactionKey, tracerIndex, data, provider);
            try {
                this.conditionalStartTransactionInstanceCreate(instanceProvider, data, element, tracerIndex, true, true);
                data.setStartTransactionElement(element);
                return element.touch(data.getWallClockStartTime());
            }
            catch (ThreadDeath td) {
                this.abortTransaction(data);
                throw td;
            }
            catch (Throwable t) {
                this.abortTransaction(t, data);
            }
        }
        catch (ThreadDeath td) {
            this.abortTransaction(data);
            throw td;
        }
        catch (Throwable t) {
            this.abortTransaction(t, data);
        }
        return null;
    }

    @Override
    public ITransactionElement submitStartTransaction(Object transactionKey, int tracerIndex, IStackElement data, ITransactionElementProvider provider, IMetricUpdater metricUpdater) {
        this.startTransactionTrigger(data);
        this.addComponentTrigger(data);
        try {
            ITransactionElement element = this.root.goToChildStartTransaction(transactionKey, tracerIndex, data, provider);
            if (element != null) {
                try {
                    metricUpdater.doOnStartTrace(tracerIndex, data, element);
                    data.setStartTransactionElement(element);
                    return element.touch(data.getWallClockStartTime());
                }
                catch (ThreadDeath td) {
                    this.abortTransaction(data);
                    throw td;
                }
                catch (Throwable t) {
                    this.abortTransaction(t, data);
                }
            }
        }
        catch (ThreadDeath td) {
            this.abortTransaction(data);
            throw td;
        }
        catch (Throwable t) {
            this.abortTransaction(t, data);
        }
        return null;
    }

    @Override
    public ITransactionElement submitStartTransaction(Object transactionKey, int tracerIndex, IStackElement data, ITransactionElementProvider provider, ITransactionInstanceProvider instanceProvider, IMetricUpdater metricUpdater) {
        this.startTransactionTrigger(data);
        this.addComponentTrigger(data);
        try {
            ITransactionElement element = this.root.goToChildStartTransaction(transactionKey, tracerIndex, data, provider);
            try {
                if (element != null) {
                    metricUpdater.doOnStartTrace(tracerIndex, data, element);
                    try {
                        this.conditionalStartTransactionInstanceCreate(instanceProvider, data, element, tracerIndex, true, true);
                        data.setStartTransactionElement(element);
                        return element.touch(data.getWallClockStartTime());
                    }
                    catch (ThreadDeath td) {
                        this.abortTransaction(data);
                        throw td;
                    }
                    catch (Throwable t) {
                        this.abortTransaction(t, data);
                    }
                }
            }
            catch (ThreadDeath td) {
                this.abortTransaction(data);
                throw td;
            }
            catch (Throwable t) {
                this.abortTransaction(t, data);
            }
        }
        catch (ThreadDeath td) {
            this.abortTransaction(data);
            throw td;
        }
        catch (Throwable t) {
            this.abortTransaction(t, data);
        }
        return null;
    }

    @Override
    public ITransactionElement submitEndTransaction(ITransactionElement cursor, int tracerIndex, IStackElement data) {
        try {
            ITransactionElement tElem = cursor.goToChildEndTransaction("<end>", tracerIndex, data, AbstractTransactionElement.kEndTransactionElementProvider);
            tElem.touch(data.getWallClockFinishTime());
            return this.moveToCursorOnEndTransaction(tElem);
        }
        catch (ThreadDeath td) {
            this.abortTransaction(data);
            throw td;
        }
        catch (Throwable t) {
            this.abortTransaction(t, data);
            return null;
        }
    }

    public ITransactionElement submitNextEndTransaction(ABlameComponent keyToNextStep, ITransactionElement currentStep, int tracerIndex, InvocationData data, ITransactionElementProvider elementProvider, IMetricUpdater updater, boolean terminateTransaction) {
        block12: {
            try {
                ITransactionElement result = currentStep.goToChildEndTransaction(keyToNextStep, tracerIndex, data, elementProvider);
                try {
                    block14: {
                        if (result == null) break block12;
                        updater.doOnEndTrace(tracerIndex, data, result);
                        if (terminateTransaction) {
                            this.preEndTransactionTrigger(data);
                            try {
                                try {
                                    result.terminateTransaction("<end>");
                                }
                                catch (ThreadDeath td) {
                                    this.abortTransaction(data);
                                    throw td;
                                }
                                catch (Throwable t) {
                                    this.abortTransaction(t, data);
                                    this.refreshTransactionCollectionStatus(data);
                                    this.postEndTransactionTrigger(data);
                                    break block14;
                                }
                            }
                            catch (Throwable throwable) {
                                this.refreshTransactionCollectionStatus(data);
                                this.postEndTransactionTrigger(data);
                                throw throwable;
                            }
                            this.refreshTransactionCollectionStatus(data);
                            this.postEndTransactionTrigger(data);
                        }
                    }
                    result.touch(data.getWallClockFinishTime());
                    return this.moveToCursorOnEndTransaction(result);
                }
                catch (ThreadDeath td) {
                    this.abortTransaction(data);
                    throw td;
                }
                catch (Throwable t) {
                    this.abortTransaction(t, data);
                }
            }
            catch (ThreadDeath td) {
                this.abortTransaction(data);
                throw td;
            }
            catch (Throwable t) {
                this.abortTransaction(t, data);
            }
        }
        return null;
    }

    public ITransactionElement submitNextEndTransaction(Object keyToNextStep, ITransactionElement currentStep, int tracerIndex, IStackElement data, ITransactionElementProvider elementProvider, ITransactionInstanceProvider instanceProvider, boolean terminateTransaction) {
        block12: {
            try {
                ITransactionElement result = currentStep.goToChildEndTransaction(keyToNextStep, tracerIndex, data, elementProvider);
                try {
                    block14: {
                        this.conditionalEndTransactionInstanceCreate(instanceProvider, data, result, tracerIndex);
                        if (result == null) break block12;
                        if (terminateTransaction) {
                            this.preEndTransactionTrigger(data);
                            try {
                                try {
                                    instanceProvider.suggestEndTrace(tracerIndex, data, result);
                                    result.terminateTransaction("<end>");
                                }
                                catch (ThreadDeath td) {
                                    this.abortTransaction(data);
                                    throw td;
                                }
                                catch (Throwable t) {
                                    this.abortTransaction(t, data);
                                    this.refreshTransactionCollectionStatus(data);
                                    this.postEndTransactionTrigger(data);
                                    break block14;
                                }
                            }
                            catch (Throwable throwable) {
                                this.refreshTransactionCollectionStatus(data);
                                this.postEndTransactionTrigger(data);
                                throw throwable;
                            }
                            this.refreshTransactionCollectionStatus(data);
                            this.postEndTransactionTrigger(data);
                        }
                    }
                    result.touch(data.getWallClockFinishTime());
                    return this.moveToCursorOnEndTransaction(result);
                }
                catch (ThreadDeath td) {
                    this.abortTransaction(data);
                    throw td;
                }
                catch (Throwable t) {
                    this.abortTransaction(t, data);
                }
            }
            catch (ThreadDeath td) {
                this.abortTransaction(data);
                throw td;
            }
            catch (Throwable t) {
                this.abortTransaction(t, data);
            }
        }
        return null;
    }

    public ITransactionElement submitEndTransaction(ITransactionElement cursor, int tracerIndex, IStackElement data, ITransactionElementProvider elementProvider, ITransactionInstanceProvider instanceProvider, IMetricUpdater metricUpdater) {
        this.preEndTransactionTrigger(data);
        instanceProvider.suggestEndTrace(tracerIndex, data, cursor);
        ITransactionElement element = cursor.goToChildEndTransaction("<end>", tracerIndex, data, AbstractTransactionElement.kEndTransactionElementProvider);
        this.refreshTransactionCollectionStatus(data);
        this.postEndTransactionTrigger(data);
        element.touch(data.getWallClockFinishTime());
        return this.moveToCursorOnEndTransaction(element);
    }

    @Override
    public ITransactionElement submitNextStartTransaction(Object keyToNextStep, ITransactionElement currentStep, int tracerIndex, IStackElement data, ITransactionElementProvider elementProvider) {
        try {
            ITransactionElement result = currentStep.goToChildStartTransaction(keyToNextStep, tracerIndex, data, elementProvider);
            return result.touch(data.getWallClockStartTime());
        }
        catch (ThreadDeath td) {
            this.abortTransaction(data);
            throw td;
        }
        catch (Throwable t) {
            this.abortTransaction(t, data);
            return null;
        }
    }

    @Override
    public ITransactionElement submitNextStartTransaction(Object keyToNextStep, ITransactionElement currentStep, int tracerIndex, IStackElement data, ITransactionElementProvider elementProvider, IMetricUpdater metricUpdater) {
        try {
            ITransactionElement result = currentStep.goToChildStartTransaction(keyToNextStep, tracerIndex, data, elementProvider);
            if (result != null) {
                try {
                    metricUpdater.doOnStartTrace(tracerIndex, data, result);
                    return result.touch(data.getWallClockStartTime());
                }
                catch (ThreadDeath td) {
                    this.abortTransaction(data);
                    throw td;
                }
                catch (Throwable t) {
                    this.abortTransaction(t, data);
                }
            }
        }
        catch (ThreadDeath td) {
            this.abortTransaction(data);
            throw td;
        }
        catch (Throwable t) {
            this.abortTransaction(t, data);
        }
        return null;
    }

    @Override
    public ITransactionElement submitNextStartTransaction(Object keyToNextStep, ITransactionElement currentStep, int tracerIndex, IStackElement data, ITransactionElementProvider elementProvider, ITransactionInstanceProvider instanceProvider) {
        try {
            ITransactionElement result = currentStep.goToChildStartTransaction(keyToNextStep, tracerIndex, data, elementProvider);
            try {
                this.conditionalStartTransactionInstanceCreate(instanceProvider, data, result, tracerIndex, false, false);
                return result.touch(data.getWallClockStartTime());
            }
            catch (ThreadDeath td) {
                this.abortTransaction(data);
                throw td;
            }
            catch (Throwable t) {
                this.abortTransaction(t, data);
            }
        }
        catch (ThreadDeath td) {
            this.abortTransaction(data);
            throw td;
        }
        catch (Throwable t) {
            this.abortTransaction(t, data);
        }
        return null;
    }

    @Override
    public ITransactionElement submitNextStartTransaction(Object keyToNextStep, ITransactionElement currentStep, int tracerIndex, IStackElement data, ITransactionElementProvider elementProvider, ITransactionInstanceProvider instanceProvider, IMetricUpdater metricUpdater) {
        block9: {
            try {
                ITransactionElement result = currentStep.goToChildStartTransaction(keyToNextStep, tracerIndex, data, elementProvider);
                if (result == null) break block9;
                try {
                    metricUpdater.doOnStartTrace(tracerIndex, data, result);
                    try {
                        this.conditionalStartTransactionInstanceCreate(instanceProvider, data, result, tracerIndex, false, false);
                        return result.touch(data.getWallClockStartTime());
                    }
                    catch (ThreadDeath td) {
                        this.abortTransaction(data);
                        throw td;
                    }
                    catch (Throwable t) {
                        this.abortTransaction(t, data);
                    }
                }
                catch (ThreadDeath td) {
                    this.abortTransaction(data);
                    throw td;
                }
                catch (Throwable t) {
                    this.abortTransaction(t, data);
                }
            }
            catch (ThreadDeath td) {
                this.abortTransaction(data);
                throw td;
            }
            catch (Throwable t) {
                this.abortTransaction(t, data);
            }
        }
        return null;
    }

    @Override
    public int getTransactionsCount() {
        return this.root.countChildren();
    }

    @Override
    public ITransactionElement submitNextEndTransaction(Object keyToNextStep, ITransactionElement currentStep, int tracerIndex, IStackElement data, ITransactionElementProvider elementProvider) {
        try {
            ITransactionElement result = currentStep.goToChildEndTransaction(keyToNextStep, tracerIndex, data, elementProvider);
            result.touch(data.getWallClockFinishTime());
            return this.moveToCursorOnEndTransaction(result);
        }
        catch (ThreadDeath td) {
            this.abortTransaction(data);
            throw td;
        }
        catch (Throwable t) {
            this.abortTransaction(t, data);
            return null;
        }
    }

    @Override
    public ITransactionElement submitNextEndTransaction(Object keyToNextStep, ITransactionElement currentStep, int tracerIndex, IStackElement data, ITransactionElementProvider elementProvider, ITransactionInstanceProvider instanceProvider) {
        try {
            ITransactionElement result = currentStep.goToChildEndTransaction(keyToNextStep, tracerIndex, data, elementProvider);
            try {
                this.conditionalEndTransactionInstanceCreate(instanceProvider, data, result, tracerIndex);
                result.touch(data.getWallClockFinishTime());
                return this.moveToCursorOnEndTransaction(result);
            }
            catch (ThreadDeath td) {
                this.abortTransaction(data);
                throw td;
            }
            catch (Throwable t) {
                this.abortTransaction(t, data);
            }
        }
        catch (ThreadDeath td) {
            this.abortTransaction(data);
            throw td;
        }
        catch (Throwable t) {
            this.abortTransaction(t, data);
        }
        return null;
    }

    @Override
    public ITransactionElement submitNextEndTransaction(Object keyToNextStep, ITransactionElement currentStep, int tracerIndex, IStackElement data, ITransactionElementProvider elementProvider, IMetricUpdater metricUpdater) {
        try {
            ITransactionElement result = currentStep.goToChildEndTransaction(keyToNextStep, tracerIndex, data, elementProvider);
            if (result != null) {
                try {
                    metricUpdater.doOnEndTrace(tracerIndex, data, result);
                    result.touch(data.getWallClockFinishTime());
                    return this.moveToCursorOnEndTransaction(result);
                }
                catch (ThreadDeath td) {
                    this.abortTransaction(data);
                    throw td;
                }
                catch (Throwable t) {
                    this.abortTransaction(t, data);
                }
            }
        }
        catch (ThreadDeath td) {
            this.abortTransaction(data);
            throw td;
        }
        catch (Throwable t) {
            this.abortTransaction(t, data);
        }
        return null;
    }

    @Override
    public ITransactionElement submitNextEndTransaction(Object keyToNextStep, ITransactionElement currentStep, int tracerIndex, IStackElement data, ITransactionElementProvider elementProvider, ITransactionInstanceProvider instanceProvider, IMetricUpdater metricUpdater, boolean terminateTransaction) {
        block15: {
            try {
                ITransactionElement result = currentStep.goToChildEndTransaction(keyToNextStep, tracerIndex, data, elementProvider);
                if (result == null) break block15;
                try {
                    metricUpdater.doOnEndTrace(tracerIndex, data, result);
                    try {
                        block17: {
                            this.conditionalEndTransactionInstanceCreate(instanceProvider, data, result, tracerIndex);
                            if (terminateTransaction) {
                                this.preEndTransactionTrigger(data);
                                try {
                                    try {
                                        instanceProvider.suggestEndTrace(tracerIndex, data, result);
                                        result.terminateTransaction("<end>");
                                    }
                                    catch (ThreadDeath td) {
                                        this.abortTransaction(null, data);
                                        throw td;
                                    }
                                    catch (Throwable t) {
                                        this.abortTransaction(t, data);
                                        this.refreshTransactionCollectionStatus(data);
                                        this.postEndTransactionTrigger(data);
                                        break block17;
                                    }
                                }
                                catch (Throwable throwable) {
                                    this.refreshTransactionCollectionStatus(data);
                                    this.postEndTransactionTrigger(data);
                                    throw throwable;
                                }
                                this.refreshTransactionCollectionStatus(data);
                                this.postEndTransactionTrigger(data);
                            }
                        }
                        result.touch(data.getWallClockFinishTime());
                        return this.moveToCursorOnEndTransaction(result);
                    }
                    catch (ThreadDeath td) {
                        this.abortTransaction(data);
                        throw td;
                    }
                    catch (Throwable t) {
                        this.abortTransaction(t, data);
                    }
                }
                catch (ThreadDeath td) {
                    this.abortTransaction(data);
                    throw td;
                }
                catch (Throwable t) {
                    this.abortTransaction(t, data);
                }
            }
            catch (ThreadDeath td) {
                this.abortTransaction(data);
                throw td;
            }
            catch (Throwable t) {
                this.abortTransaction(t, data);
            }
        }
        return null;
    }

    public ITransactionElement submitNextCursor(Object keyToNextStep, ITransactionElement currentStep, IStackElement currentData, ITransactionElementProvider elementProvider) {
        try {
            ITransactionElement result = currentStep.goToChild(keyToNextStep, currentData, elementProvider);
            return result.touch(currentData.getWallClockStartTime());
        }
        catch (ThreadDeath td) {
            this.abortTransaction(currentData);
            throw td;
        }
        catch (Throwable t) {
            this.abortTransaction(t, currentData);
            return null;
        }
    }

    public ITransactionElement getRoot() {
        return this.root;
    }

    @Override
    public void registerTxnEventListener(ITransactionEventListener listener) {
        sTransactionEventListeners.add(listener);
    }

    private ITransactionElement moveToCursorOnEndTransaction(ITransactionElement endCursor) {
        ITransactionElement result = endCursor.getNextOnEndTransaction();
        return result;
    }

    @Override
    public void IBlameStack_addComponent(String component) {
    }

    @Override
    public void IBlameStack_addComponent(String component, String paramName, String paramValue) {
    }

    @Override
    public void IBlameStack_addComponent(String component, IComponentParameterCallback callback) {
    }

    @Override
    public void IBlameStack_addExtraParameter(String paramName, String paramValue) {
    }

    @Override
    public BlameStackSnapshot IBlameStack_getSnapshot(String component) {
        return null;
    }

    @Override
    public boolean IBlameStack_isEmpty() {
        return false;
    }

    @Override
    public void IBlameStack_removeComponent(String component) {
    }

    @Override
    public void IBlameStack_tearDown() {
    }

    @Override
    public void addMapComponent(IStackType type, String component) {
    }

    @Override
    public void addMapComponent(IStackType type, String component, String paramName, String paramVal) {
    }

    public void addMapComponent(IStackType type, String component, HashMap params) {
    }

    @Override
    public void addRootParameter(String key, String value) {
    }

    @Override
    public void endBoundaryPopped(String component) {
    }

    @Override
    public void frontBoundaryPopped(String component) {
    }

    @Override
    public String[] getDefaultBackendData() {
        return null;
    }

    @Override
    public BlameStackSnapshot getDefaultBackendSnapshot() {
        return null;
    }

    @Override
    public boolean getHeadFilteringStatus() {
        return false;
    }

    @Override
    public boolean hasFrontBoundary() {
        return false;
    }

    @Override
    public boolean noteBoundaryError() {
        return false;
    }

    @Override
    public void popMapComponent(IStackType stackType, String component) {
    }

    @Override
    public void removeMapComponent(IStackType type, String component) {
    }

    @Override
    public void setDefaultBackendComponent(String componentToReplace, String backendComponent) {
    }

    @Override
    public void setEndBoundary(String component) {
    }

    @Override
    public void setFrontBoundary(String component) {
    }

    @Override
    public boolean shouldCurrentTraceBePropagated() {
        return false;
    }

    public void dump(PrintStream out) {
        ArrayList leaves = new ArrayList();
        int numberofnodes = 0;
        long[] counters = new long[3];
        this.findAllLeaves(this.root, leaves, counters);
        out.println("[total number of element =" + counters[numberofnodes] + "]");
        Stack<ITransactionElement> stack = new Stack<ITransactionElement>();
        HashSet reps = new HashSet();
        for (ITransactionElement leaf : leaves) {
            while (leaf != null) {
                stack.push(leaf);
                leaf = leaf.getParent();
            }
            int j = 0;
            while (!stack.isEmpty()) {
                leaf = (ITransactionElement)stack.pop();
                this.printNodeString(out, leaf);
                this.addReps(reps, leaf);
                if (++j == 2) {
                    out.print("[touched=" + leaf.wasTouchedSinceLastReadTime() + "]");
                }
                if (!stack.isEmpty()) {
                    out.print("->");
                    continue;
                }
                out.println("");
            }
        }
        out.println("[total number of repositories =" + reps.size() + "]");
    }

    protected void findAllLeaves(ITransactionElement cursor, List repository, long[] counters) {
        Stack<ITransactionElement> stack = new Stack<ITransactionElement>();
        stack.push(cursor);
        while (!stack.isEmpty()) {
            ITransactionElement pivot = (ITransactionElement)stack.pop();
            counters[0] = counters[0] + 1L;
            Iterator children = pivot.iterateChildren();
            if (children != null && children.hasNext()) {
                while (children.hasNext()) {
                    stack.push((ITransactionElement)children.next());
                }
                continue;
            }
            repository.add(pivot);
        }
    }

    protected void printNodeDepth(PrintStream out, ITransactionElement leaf) {
    }

    protected void printNodeString(PrintStream out, ITransactionElement leaf) {
    }

    protected void addReps(Set reps, ITransactionElement leaf) {
    }

    protected IAgent getAgent() {
        return null;
    }

    private void abortTransaction(IStackElement data) {
        this.abortTransaction(null, data);
    }

    public void abortTransaction(Throwable th, IStackElement data) {
        VirtualStack.abortTransaction();
    }
}

