/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.trace.IIntelligentInstrumentationStackElement;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.intelligent.AutoTracingController;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentStackHelper;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;

public class HighPerformanceIntelligentErrorFeature {
    public static TransactionComponentData fetchErrorSnapshot(IStackElement data, Runnable t, Throwable error, IIntelligentInstrumentationStackElement elementWithMTERTracer, String errorMessage, IIntelligentInstrumentationStackElement lastChildWithException) {
        return HighPerformanceIntelligentStackHelper.getErrorTransactionSnapshotFromStack(data, elementWithMTERTracer, t, error, errorMessage, lastChildWithException);
    }

    public static void triggerAutoTracingForError(IStackElement stackElement) {
        if (stackElement instanceof InvocationData) {
            AutoTracingController.markForAutoTracing((InvocationData)stackElement, "Error", ((InvocationData)stackElement).getComponentNameAt(0));
        }
    }

    public static String constructErrorMessage(IIntelligentInstrumentationStackElement errorElement) {
        String errorMessage = HighPerformanceIntelligentErrorFeature.fetchErrorMessage(errorElement);
        if (errorMessage != null) {
            String componentName = errorElement.getComponentName();
            if (componentName != null) {
                return String.valueOf(componentName) + ": " + errorMessage;
            }
            return errorMessage;
        }
        return null;
    }

    public static String fetchErrorMessage(IIntelligentInstrumentationStackElement errorElement) {
        Throwable error = errorElement.getInvocationThrownException();
        if (error != null) {
            return String.valueOf(error.getClass().getName()) + ": " + error.getMessage();
        }
        return null;
    }
}

