/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.servlet;

import com.wily.introscope.agent.trace.servlet.ObjectWrapper;
import com.wily.introscope.agent.trace.servlet.ServletObjectFactory;
import com.wily.introscope.agent.trace.servlet.ServletWrapper;
import com.wily.introscope.agent.trace.servlet.SessionWrapper;
import com.wily.introscope.agent.urlgroup.TomcatUtil;
import com.wily.introscope.spec.server.MetricNameUtils;
import java.io.BufferedReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class RequestWrapper
extends ObjectWrapper {
    private static final String kDefaultCharacterEncoding = "ISO-8859-1";
    public static final String kHttpServletRequestInterfaceName = "javax.servlet.http.HttpServletRequest";
    private static final Class[] kGetSessionParamClasses = new Class[]{Boolean.TYPE};
    public static final String kGetParameterMethodName = "getParameter";
    public static final String kGetAttributeMethodName = "getAttribute";
    public static final String kGetRequestURI = "getRequestURI";
    public static final String kGetSession = "getSession";
    public static final String kGetRequestedSessionIDMethodName = "getRequestedSessionId";
    private SessionWrapper fSessionWrapper;
    private Map fParameterMap = null;
    private Map fPostParameterMap;
    private String fCharacterEncoding;

    RequestWrapper(ServletObjectFactory interfaceCache, Object request) throws ClassNotFoundException {
        super(interfaceCache, request);
    }

    @Override
    public String getInterfaceClassName() {
        return kHttpServletRequestInterfaceName;
    }

    public String getRequestedSessionId() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeEmptyArgumentMethodOnObject(kGetRequestedSessionIDMethodName);
    }

    public String getRequestURI() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeEmptyArgumentMethodOnObject(kGetRequestURI);
    }

    public SessionWrapper getSession(boolean create) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        SessionWrapper wrapper;
        Object session;
        if (this.fSessionWrapper == null && (session = this.invokeMethodOnObject(kGetSession, kGetSessionParamClasses, new Object[]{create ? Boolean.TRUE : Boolean.FALSE})) != null && (wrapper = new SessionWrapper(this.getInterfaceCache(), session)).getInterfaceClass() != null) {
            this.fSessionWrapper = wrapper;
        }
        return this.fSessionWrapper;
    }

    public String getQueryString() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeEmptyArgumentMethodOnObject("getQueryString");
    }

    public String getAttribute(String name) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object obj = this.invokeMethodOnObject(kGetAttributeMethodName, new Class[]{String.class}, new Object[]{name});
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public String getContextPath() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeEmptyArgumentMethodOnObject("getContextPath");
    }

    public String getApplicationNameFromServlet(ServletWrapper servlet) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String result = null;
        try {
            result = servlet.getServletContext().getServletContextName();
        }
        catch (Exception exception) {}
        if (result == null && (result = this.getContextPath()) != null && result.startsWith("/")) {
            result = result.substring(1);
        }
        if (MetricNameUtils.containsMetricSeparatorChars(result)) {
            result = MetricNameUtils.substituteMetricSeparatorChars(result);
        }
        return result;
    }

    public String getRemoteUser() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeEmptyArgumentMethodOnObject("getRemoteUser");
    }

    public String getMethod() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeEmptyArgumentMethodOnObject("getMethod");
    }

    public String getHeader(String headerName) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeMethodOnObject("getHeader", this.getOneStringParameterClassArray(), new Object[]{headerName});
    }

    public Enumeration getHeaderNames() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (Enumeration)this.invokeMethodOnObject("getHeaderNames", null, null);
    }

    public Object[] getCookies() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] cookieObject = (Object[])this.invokeMethodOnObject("getCookies", null, null);
        return cookieObject;
    }

    public String getParameter(String name) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Map params = this.getParameterMap();
        String[] values = (String[])params.get(name);
        return values == null || values.length == 0 ? null : values[0];
    }

    public String getScheme() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeEmptyArgumentMethodOnObject("getScheme");
    }

    public String getHttpMethod() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeEmptyArgumentMethodOnObject("getMethod");
    }

    public int getRemotePort() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Integer port = (Integer)this.invokeEmptyArgumentMethodOnObject("getRemotePort");
        return port == null ? 0 : port;
    }

    public String getRemoteAddress() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeEmptyArgumentMethodOnObject("getRemoteAddr");
    }

    public String getServletPath() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeEmptyArgumentMethodOnObject("getServletPath");
    }

    public String getServerName() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeEmptyArgumentMethodOnObject("getServerName");
    }

    public String getLocalAddr() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeEmptyArgumentMethodOnObject("getLocalAddr");
    }

    public int getServerPort() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Integer port = (Integer)this.invokeEmptyArgumentMethodOnObject("getServerPort");
        return port == null ? 0 : port;
    }

    public String getProtocol() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeEmptyArgumentMethodOnObject("getProtocol");
    }

    public BufferedReader getReader() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (BufferedReader)this.invokeEmptyArgumentMethodOnObject("getReader");
    }

    public Map getParameterMap() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String queryString = this.getQueryString();
        if (this.fParameterMap == null) {
            Map localMap = new HashMap();
            try {
                String encoding = this.getSafeCharacterEncoding();
                TomcatUtil.parseParameters(localMap, queryString, encoding);
            }
            catch (Throwable throwable) {
                localMap = Collections.EMPTY_MAP;
            }
            this.fParameterMap = localMap;
        }
        return this.fParameterMap;
    }

    public Map getPostParameterMap2() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        HashMap<String, Object> postParams = new HashMap<String, Object>();
        Map localMap = (Map)this.invokeEmptyArgumentMethodOnObject("getParameterMap");
        if (localMap != null) {
            Map queryMap = this.getParameterMap();
            for (Map.Entry localEntry : localMap.entrySet()) {
                int i;
                String key = (String)localEntry.getKey();
                Object localVal = localEntry.getValue();
                Object queryVal = queryMap.get(key);
                if (queryVal == null) {
                    postParams.put(key, localVal);
                    continue;
                }
                if (localVal.equals(queryVal)) continue;
                HashSet<Object> postVals = new HashSet<Object>();
                if (localVal instanceof String) {
                    postVals.add(localVal);
                } else {
                    String[] localArray = (String[])localVal;
                    i = localArray.length - 1;
                    while (i >= 0) {
                        postVals.add(localArray[i]);
                        --i;
                    }
                }
                if (queryVal instanceof String) {
                    postVals.remove(queryVal);
                } else {
                    String[] queryArray = (String[])queryVal;
                    i = queryArray.length - 1;
                    while (i >= 0) {
                        postVals.remove(queryArray[i]);
                        --i;
                    }
                }
                String[] postArray = new String[postVals.size()];
                postVals.toArray(postArray);
                postParams.put(key, postArray);
            }
        }
        return postParams;
    }

    public Map getPostParameterMap() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.fPostParameterMap == null) {
            this.fPostParameterMap = new HashMap();
            Map localMap = new HashMap();
            localMap = (Map)this.invokeEmptyArgumentMethodOnObject("getParameterMap");
            if (localMap != null) {
                if (this.fParameterMap == null) {
                    this.getParameterMap();
                }
                for (Map.Entry localEntry : localMap.entrySet()) {
                    String queryValue;
                    String localKey = (String)localEntry.getKey();
                    String localValue = null;
                    Object localObjValue = localEntry.getValue();
                    if (localObjValue instanceof String) {
                        localValue = (String)localObjValue;
                    } else if (localObjValue instanceof String[]) {
                        localValue = ((String[])localObjValue)[0];
                    }
                    if (this.fParameterMap.get(localKey) == null) {
                        this.fPostParameterMap.put(localKey, localValue);
                        continue;
                    }
                    if (this.fParameterMap.get(localKey) instanceof String && !this.fParameterMap.get(localKey).equals(localValue)) {
                        this.fPostParameterMap.put(localKey, localValue);
                        continue;
                    }
                    if (!(this.fParameterMap.get(localKey) instanceof String[]) || localValue.equals(queryValue = ((String[])this.fParameterMap.get(localKey))[0])) continue;
                    this.fPostParameterMap.put(localKey, localValue);
                }
            }
        }
        return this.fPostParameterMap;
    }

    public String getSafeCharacterEncoding() {
        String encoding = null;
        try {
            encoding = this.getCharacterEncoding();
        }
        catch (Throwable throwable) {}
        encoding = encoding == null ? this.fCharacterEncoding : encoding;
        encoding = encoding == null ? kDefaultCharacterEncoding : encoding;
        return encoding;
    }

    public String getCharacterEncoding() throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (String)this.invokeEmptyArgumentMethodOnObject("getCharacterEncoding");
    }

    public void setCharacterEncoding(String encoding) throws SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.fCharacterEncoding = encoding;
    }
}

