/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.urlgroup;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public final class TomcatUtil {
    private static QueryStringParser parser;
    public static final String kstCharEncoding_USASCII = "US-ASCII";
    public static final String kstCharEncoding_UTF8 = "UTF-8";

    static {
        try {
            IAgent agent = AgentShim.getAgent();
            String sepator = agent.IAgent_getIndexedProperties().getProperty("introscope.agent.urlgroup.querystring.separator");
            parser = sepator == null ? new StandardQueryStringParser() : new CustomQueryStringParser(sepator.charAt(0));
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            parser = new StandardQueryStringParser();
        }
    }

    public static void parseParameters(Map map, String data, String encoding) throws UnsupportedEncodingException {
        parser.parseParameters(map, data, encoding);
    }

    public static void parseParameters(Map map, byte[] data, String encoding) throws UnsupportedEncodingException {
        parser.parseParameters(map, data, encoding);
    }

    private static void putMapEntry(Map map, String name, String value) {
        String[] newValues = null;
        String[] oldValues = (String[])map.get(name);
        if (oldValues == null) {
            newValues = new String[]{value};
        } else {
            newValues = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
            newValues[oldValues.length] = value;
        }
        map.put(name, newValues);
    }

    private static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }

    static class CustomQueryStringParser
    extends StandardQueryStringParser
    implements QueryStringParser {
        private final char separator;

        public CustomQueryStringParser(char separator) {
            this.separator = separator;
        }

        @Override
        public void parseParameters(Map map, byte[] data, String encoding) throws UnsupportedEncodingException {
            if (data != null && data.length > 0) {
                int ix = 0;
                int ox = 0;
                String key = null;
                String value = null;
                while (ix < data.length) {
                    byte c;
                    char currentChar;
                    if (this.separator == (currentChar = (char)(c = data[ix++]))) {
                        value = new String(data, 0, ox, encoding);
                        if (key != null) {
                            TomcatUtil.putMapEntry(map, key, value);
                            key = null;
                        }
                        ox = 0;
                        continue;
                    }
                    if ('=' == currentChar) {
                        if (key == null) {
                            key = new String(data, 0, ox, encoding);
                            ox = 0;
                            continue;
                        }
                        data[ox++] = c;
                        continue;
                    }
                    data[ox++] = '%' == currentChar ? (byte)((TomcatUtil.convertHexDigit(data[ix++]) << 4) + TomcatUtil.convertHexDigit(data[ix++])) : c;
                }
                if (key != null) {
                    value = new String(data, 0, ox, encoding);
                    TomcatUtil.putMapEntry(map, key, value);
                }
            }
        }
    }

    static interface QueryStringParser {
        public void parseParameters(Map var1, String var2, String var3) throws UnsupportedEncodingException;

        public void parseParameters(Map var1, byte[] var2, String var3) throws UnsupportedEncodingException;
    }

    static class StandardQueryStringParser
    implements QueryStringParser {
        StandardQueryStringParser() {
        }

        @Override
        public void parseParameters(Map map, String data, String encoding) throws UnsupportedEncodingException {
            if (data != null && data.length() > 0) {
                byte[] bytes = null;
                try {
                    bytes = encoding == null ? data.getBytes() : data.getBytes(encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                this.parseParameters(map, bytes, encoding);
            }
        }

        @Override
        public void parseParameters(Map map, byte[] data, String encoding) throws UnsupportedEncodingException {
            if (data != null && data.length > 0) {
                int ix = 0;
                int ox = 0;
                String key = null;
                String value = null;
                while (ix < data.length) {
                    byte c = data[ix++];
                    switch ((char)c) {
                        case '&': {
                            value = new String(data, 0, ox, encoding);
                            if (key != null) {
                                TomcatUtil.putMapEntry(map, key, value);
                                key = null;
                            }
                            ox = 0;
                            break;
                        }
                        case '=': {
                            if (key == null) {
                                key = new String(data, 0, ox, encoding);
                                ox = 0;
                                break;
                            }
                            data[ox++] = c;
                            break;
                        }
                        case '+': {
                            data[ox++] = 32;
                            break;
                        }
                        case '%': {
                            data[ox++] = (byte)((TomcatUtil.convertHexDigit(data[ix++]) << 4) + TomcatUtil.convertHexDigit(data[ix++]));
                            break;
                        }
                        default: {
                            data[ox++] = c;
                        }
                    }
                }
                if (key != null) {
                    value = new String(data, 0, ox, encoding);
                    TomcatUtil.putMapEntry(map, key, value);
                }
            }
        }
    }
}

