/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.util.WilyStringBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AgentConnectionOrderParser {
    private static final String listSeparator = ",";

    public static String buildConnectionOrder(List urls) throws Exception {
        int size = urls.size();
        if (size > 0) {
            try {
                ArrayList<Integer> connectionOrder = new ArrayList<Integer>(size);
                int i = 0;
                while (i < size) {
                    try {
                        String number;
                        Integer order;
                        String url = (String)urls.get(i);
                        int index = url.lastIndexOf(".");
                        if (index != -1 && index < url.length() - 1 && (order = new Integer(number = url.substring(index + 1).trim())) >= 1 && !connectionOrder.contains(order)) {
                            connectionOrder.add(order);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    ++i;
                }
                if (size > 1) {
                    Collections.sort(connectionOrder);
                }
                return AgentConnectionOrderParser.buildConnectionOrderString(connectionOrder);
            }
            catch (IndexOutOfBoundsException iob) {
                throw iob;
            }
            catch (Exception ex) {
                throw ex;
            }
        }
        return null;
    }

    private static String buildConnectionOrderString(List connectionOrder) {
        WilyStringBuilder builder = new WilyStringBuilder();
        int i = 0;
        while (i < connectionOrder.size()) {
            String order = ((Integer)connectionOrder.get(i)).toString();
            if (order != null && order.length() != 0) {
                builder.append(order);
                if (i < connectionOrder.size() - 1) {
                    builder.append(listSeparator);
                }
            }
            ++i;
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return null;
    }
}

