/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.api.instrument.DGRuntimeMethod;
import com.wily.introscope.util.SafeReflectionFactory;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DGRuntimeClass
implements IModeledClass {
    private final Class fRuntimeClass;
    private ClassName className;
    private ClassName superClassName;
    private List<IModeledMethod> fModeledMethods;
    private List<String> fImplementedInterfaceNames;
    private List<String> fDeclaredAnnotationNames;
    private static IModuleFeedbackChannel logger;
    private static Module kModule;

    static {
        try {
            logger = AgentShim.getAgent().IAgent_getModuleFeedback();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
        kModule = new Module("DGRuntimeClass");
    }

    public DGRuntimeClass(Class cls) throws InvalidClassNameException {
        this.fRuntimeClass = cls;
        this.className = ClassName.getClassName(this.fRuntimeClass.getName());
        if (this.fRuntimeClass.getSuperclass() != null) {
            this.superClassName = ClassName.getClassName(this.fRuntimeClass.getSuperclass().getName());
        }
        this.fModeledMethods = null;
        this.fImplementedInterfaceNames = null;
        this.fDeclaredAnnotationNames = null;
    }

    @Override
    public IClassName getClassName() {
        return this.className;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.fRuntimeClass.getClassLoader();
    }

    @Override
    public boolean hasSuperClass() {
        return this.superClassName != null;
    }

    @Override
    public IClassName getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public boolean isInterface() {
        return this.fRuntimeClass.isInterface();
    }

    @Override
    public boolean isValueType() {
        return this.fRuntimeClass.isPrimitive();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean inheritsDirectlyFromInterface(IClassName iClassName) {
        try {
            Class<?>[] intfs = null;
            try {
                intfs = this.fRuntimeClass.getInterfaces();
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
            if (intfs == null) {
                return false;
            }
            Class<?>[] classArray = intfs;
            int n = intfs.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                Class<?> intf = classArray[n2];
                try {
                    if (intf.getName().equals(iClassName.getReflectionFriendlyQualifiedNameString())) {
                        return true;
                    }
                }
                catch (Throwable t) {
                    logger.trace(kModule, "", t);
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        return false;
    }

    @Override
    public boolean isInstanceOf(IClassName iClassName) {
        try {
            Class<?> interfaceClass = Class.forName(iClassName.getReflectionFriendlyQualifiedNameString(), false, this.fRuntimeClass.getClassLoader());
            return interfaceClass.isAssignableFrom(this.fRuntimeClass);
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
            return false;
        }
    }

    @Override
    public Iterator getAllDeclaredMethods() {
        if (this.fModeledMethods == null) {
            int n;
            int n2;
            Executable[] executableArray;
            this.fModeledMethods = new ArrayList<IModeledMethod>();
            try {
                Method[] methods = this.fRuntimeClass.getDeclaredMethods();
                executableArray = methods;
                n2 = methods.length;
                n = 0;
                while (n < n2) {
                    Method m = executableArray[n];
                    try {
                        this.fModeledMethods.add(new DGRuntimeMethod(this, m));
                    }
                    catch (Throwable t) {
                        logger.trace(kModule, "Issue creating Runtime Method", t);
                    }
                    ++n;
                }
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
            try {
                Constructor<?>[] constructors = this.fRuntimeClass.getDeclaredConstructors();
                try {
                    Method classConstructorMockedToFitBytecode = SafeReflectionFactory.newMethod(this.fRuntimeClass, "<clinit>", new Class[0], Void.TYPE, new Class[0], 8, -1, "<clinit>", null, null, null);
                    this.fModeledMethods.add(new DGRuntimeMethod(this, classConstructorMockedToFitBytecode));
                }
                catch (Throwable t) {
                    logger.trace(kModule, "Issue creating class constructor", t);
                }
                if (constructors.length == 0) {
                    try {
                        Method instanceConstructorMockedToFitBytecode = SafeReflectionFactory.newMethod(this.fRuntimeClass, "<init>", new Class[0], Void.TYPE, new Class[0], 2, -1, "<init>", null, null, null);
                        this.fModeledMethods.add(new DGRuntimeMethod(this, instanceConstructorMockedToFitBytecode));
                    }
                    catch (Throwable t) {
                        logger.trace(kModule, "Issue creating default constructor", t);
                        return this.fModeledMethods.iterator();
                    }
                }
                executableArray = constructors;
                n2 = constructors.length;
                n = 0;
                while (n < n2) {
                    Executable c = executableArray[n];
                    try {
                        Field f = c.getClass().getDeclaredField("slot");
                        f.setAccessible(true);
                        Integer slot = (Integer)f.get(c);
                        Method getSignature = c.getClass().getDeclaredMethod("getSignature", new Class[0]);
                        getSignature.setAccessible(true);
                        Method getRawAnnotations = c.getClass().getDeclaredMethod("getRawAnnotations", new Class[0]);
                        getRawAnnotations.setAccessible(true);
                        Method getRawParameterAnnotations = c.getClass().getDeclaredMethod("getRawParameterAnnotations", new Class[0]);
                        getRawParameterAnnotations.setAccessible(true);
                        Method instanceConstructorMockedToFitBytecode = SafeReflectionFactory.newMethod(this.fRuntimeClass, "<init>", ((Constructor)c).getParameterTypes(), Void.TYPE, ((Constructor)c).getExceptionTypes(), ((Constructor)c).getModifiers(), slot, (String)getSignature.invoke((Object)c, new Object[0]), (byte[])getRawAnnotations.invoke((Object)c, new Object[0]), (byte[])getRawParameterAnnotations.invoke((Object)c, new Object[0]), null);
                        this.fModeledMethods.add(new DGRuntimeMethod(this, instanceConstructorMockedToFitBytecode));
                    }
                    catch (Throwable t) {
                        logger.trace(kModule, "Issue creating declared constructors", t);
                    }
                    ++n;
                }
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
        }
        return this.fModeledMethods.iterator();
    }

    @Override
    public List<String> getAllImplementedInterfaceNames() {
        if (this.fImplementedInterfaceNames == null) {
            this.fImplementedInterfaceNames = new ArrayList<String>();
            Class<?>[] classArray = this.fRuntimeClass.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> c = classArray[n2];
                String name = c.getName();
                if (name != null) {
                    this.fImplementedInterfaceNames.add(name);
                }
                ++n2;
            }
        }
        return new ArrayList<String>(this.fImplementedInterfaceNames);
    }

    @Override
    public List<String> getAllDeclaredAnnotationNames() {
        if (this.fDeclaredAnnotationNames == null) {
            this.fDeclaredAnnotationNames = new ArrayList<String>();
            Annotation[] annotationArray = this.fRuntimeClass.getDeclaredAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation a = annotationArray[n2];
                String name = a.annotationType().getName();
                if (name != null) {
                    this.fDeclaredAnnotationNames.add(name);
                }
                ++n2;
            }
        }
        return new ArrayList<String>(this.fDeclaredAnnotationNames);
    }

    @Override
    public boolean containsAnnotation(IClassName iClassName) {
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        try {
            annotations.addAll(Arrays.asList(this.fRuntimeClass.getAnnotations()));
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        try {
            annotations.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredAnnotations()));
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        String annotationName = iClassName.getReflectionFriendlyQualifiedNameString();
        for (Annotation annotation : annotations) {
            try {
                if (!annotation.annotationType().getName().equals(annotationName)) continue;
                return true;
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
        }
        return false;
    }

    @Override
    public boolean referencesClass(IClassName iClassName) {
        int n;
        if (this.isInstanceOf(iClassName)) {
            return true;
        }
        String reflectionName = iClassName.getReflectionFriendlyQualifiedNameString();
        HashSet classes = new HashSet();
        try {
            classes.addAll(Arrays.asList(this.fRuntimeClass.getClasses()));
        }
        catch (Throwable throwable) {
            logger.trace(kModule, "", throwable);
        }
        try {
            classes.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredClasses()));
        }
        catch (Throwable throwable) {
            logger.trace(kModule, "", throwable);
        }
        for (Class clazz : classes) {
            try {
                if (!clazz.getName().equals(reflectionName)) continue;
                return true;
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
        }
        classes.clear();
        HashSet<Field> hashSet = new HashSet<Field>();
        try {
            hashSet.addAll(Arrays.asList(this.fRuntimeClass.getFields()));
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        try {
            hashSet.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredFields()));
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        for (Field field : hashSet) {
            try {
                if (!field.getType().getName().equals(reflectionName)) continue;
                return true;
            }
            catch (Throwable throwable) {
                logger.trace(kModule, "", throwable);
            }
        }
        hashSet.clear();
        HashSet<Method> methods = new HashSet<Method>();
        try {
            methods.addAll(Arrays.asList(this.fRuntimeClass.getMethods()));
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        try {
            methods.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredMethods()));
        }
        catch (Throwable t) {
            logger.trace(kModule, "", t);
        }
        for (Method method : methods) {
            try {
                if (method.getReturnType().getName().equals(reflectionName)) {
                    return true;
                }
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
            Class<?>[] parameterTypes = null;
            try {
                parameterTypes = method.getParameterTypes();
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
            if (parameterTypes == null) continue;
            Class<?>[] classArray = parameterTypes;
            n = parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> parameter = classArray[n2];
                try {
                    if (parameter.getName().equals(reflectionName)) {
                        return true;
                    }
                }
                catch (Throwable t) {
                    logger.trace(kModule, "", t);
                }
                ++n2;
            }
        }
        methods.clear();
        HashSet constructors = new HashSet();
        try {
            constructors.addAll(Arrays.asList(this.fRuntimeClass.getConstructors()));
        }
        catch (Throwable throwable) {
            logger.trace(kModule, "", throwable);
        }
        try {
            constructors.addAll(Arrays.asList(this.fRuntimeClass.getDeclaredConstructors()));
        }
        catch (Throwable throwable) {
            logger.trace(kModule, "", throwable);
        }
        for (Constructor constructor : constructors) {
            Class<?>[] parameterTypes = null;
            try {
                parameterTypes = constructor.getParameterTypes();
            }
            catch (Throwable t) {
                logger.trace(kModule, "", t);
            }
            if (parameterTypes == null) continue;
            Class<?>[] classArray = parameterTypes;
            int n3 = parameterTypes.length;
            n = 0;
            while (n < n3) {
                Class<?> parameter = classArray[n];
                try {
                    if (parameter.getName().equals(reflectionName)) {
                        return true;
                    }
                }
                catch (Throwable t) {
                    logger.trace(kModule, "", t);
                }
                ++n;
            }
        }
        constructors.clear();
        return this.containsAnnotation(iClassName);
    }

    @Override
    public void debugDump(PrintWriter printWriter) {
    }
}

