/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.threaddump.common;

import com.wily.introscope.threaddump.common.IWilyThreadDump;
import com.wily.introscope.threaddump.common.ThreadDumpError;
import com.wily.util.clock.MasterClock;
import com.wily.wilyassert.Assertion;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;

public class WrapperWilyThreaddump
implements Externalizable {
    protected boolean fIsError;
    private String fAgentName;
    private String fCreationNote;
    private long fTimestamp;
    private String fClassName;
    private byte[] fThreadDump;
    private int byteLen;
    private int fColPort;
    private String fColHostName;
    private int fColId;
    private boolean fCollectorInfo;

    public WrapperWilyThreaddump() {
    }

    public WrapperWilyThreaddump(boolean isError, String agentName, String creationNote, IWilyThreadDump threadDump) {
        this.fIsError = isError;
        this.fAgentName = agentName;
        this.fCreationNote = creationNote;
        if (this.fCreationNote == null) {
            this.fCreationNote = "Manual";
        }
        this.fTimestamp = MasterClock.currentTimeMillis();
        this.fClassName = threadDump.getClass().getName();
        this.fCollectorInfo = false;
        this.serializeDump(threadDump);
    }

    public void setCollectorInfo(int id, int port, String HostName) {
        this.fColPort = port;
        this.fColHostName = HostName;
        this.fColId = id;
        this.fCollectorInfo = true;
    }

    public int getFColPort() {
        return this.fColPort;
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }

    public String getCreationNote() {
        return this.fCreationNote;
    }

    public String getAgentName() {
        return this.fAgentName;
    }

    public void setAgentName(String agentName) {
        Assertion.wilyAssert(this.fAgentName == null, "SetAgentName should only be called once on a thread dump");
        this.fAgentName = agentName;
    }

    public boolean getErrorFlag() {
        return this.fIsError;
    }

    public static WrapperWilyThreaddump createAnErrorTD(ThreadDumpError e) {
        return new WrapperWilyThreaddump(true, null, null, e);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.fIsError);
        out.writeLong(this.fTimestamp);
        out.writeUTF(this.fCreationNote);
        out.writeObject(this.fAgentName);
        out.writeUTF(this.fClassName);
        out.writeBoolean(this.fCollectorInfo);
        if (this.fCollectorInfo) {
            out.writeInt(this.fColId);
            out.writeInt(this.fColPort);
            out.writeUTF(this.fColHostName);
        }
        out.writeInt(this.byteLen);
        out.write(this.fThreadDump, 0, this.byteLen);
    }

    public void serializeDump(IWilyThreadDump threadDump) {
        block14: {
            ByteArrayOutputStream baos = null;
            ObjectOutputStream oos = null;
            try {
                try {
                    baos = new ByteArrayOutputStream();
                    oos = new ObjectOutputStream(baos);
                    threadDump.writeExternal(oos);
                    this.fThreadDump = baos.toByteArray();
                    this.byteLen = this.fThreadDump.length;
                    oos.flush();
                }
                catch (IOException iOException) {
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                        break block14;
                    }
                    catch (Exception exception) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fIsError = in.readBoolean();
        this.fTimestamp = in.readLong();
        this.fCreationNote = in.readUTF();
        this.fAgentName = (String)in.readObject();
        this.fClassName = in.readUTF();
        this.fCollectorInfo = in.readBoolean();
        if (this.fCollectorInfo) {
            this.fColId = in.readInt();
            this.fColPort = in.readInt();
            this.fColHostName = in.readUTF();
        }
        this.byteLen = in.readInt();
        this.fThreadDump = new byte[this.byteLen];
        in.readFully(this.fThreadDump, 0, this.byteLen);
    }

    /*
     * Exception decompiling
     */
    public IWilyThreadDump getWilyThreadDump() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getFColHostName() {
        return this.fColHostName;
    }

    public int getFColId() {
        return this.fColId;
    }

    public boolean isFCollectorInfo() {
        return this.fCollectorInfo;
    }
}

