/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.commons.httpclient.auth;

import com.wily.org.apache.commons.httpclient.auth.AuthChallengeException;
import com.wily.org.apache.commons.httpclient.auth.AuthPolicy;
import com.wily.org.apache.commons.httpclient.auth.AuthScheme;
import com.wily.org.apache.commons.httpclient.auth.AuthState;
import com.wily.org.apache.commons.httpclient.auth.AuthenticationException;
import com.wily.org.apache.commons.httpclient.auth.MalformedChallengeException;
import com.wily.org.apache.commons.httpclient.params.HttpParams;
import com.wily.org.apache.commons.logging.Log;
import com.wily.org.apache.commons.logging.LogFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public final class AuthChallengeProcessor {
    private static final Log LOG;
    private HttpParams params = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.org.apache.commons.httpclient.auth.AuthChallengeProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog(clazz);
    }

    public AuthChallengeProcessor(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("Parameter collection may not be null");
        }
        this.params = params;
    }

    public AuthScheme selectAuthScheme(Map challenges) throws AuthChallengeException {
        if (challenges == null) {
            throw new IllegalArgumentException("Challenge map may not be null");
        }
        Collection authPrefs = (Collection)this.params.getParameter("http.auth.scheme-priority");
        if (authPrefs == null || authPrefs.isEmpty()) {
            authPrefs = AuthPolicy.getDefaultAuthPrefs();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supported authentication schemes in the order of preference: " + authPrefs);
        }
        AuthScheme authscheme = null;
        String challenge = null;
        Iterator item = authPrefs.iterator();
        while (item.hasNext()) {
            String id = (String)item.next();
            challenge = (String)challenges.get(id.toLowerCase());
            if (challenge != null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.valueOf(id) + " authentication scheme selected");
                }
                try {
                    authscheme = AuthPolicy.getAuthScheme(id);
                    break;
                }
                catch (IllegalStateException e) {
                    throw new AuthChallengeException(e.getMessage());
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Challenge for " + id + " authentication scheme not available");
        }
        if (authscheme == null) {
            throw new AuthChallengeException("Unable to respond to any of these challenges: " + challenges);
        }
        return authscheme;
    }

    public AuthScheme processChallenge(AuthState state, Map challenges) throws MalformedChallengeException, AuthenticationException {
        String challenge;
        if (state == null) {
            throw new IllegalArgumentException("Authentication state may not be null");
        }
        if (challenges == null) {
            throw new IllegalArgumentException("Challenge map may not be null");
        }
        if (state.isPreemptive() || state.getAuthScheme() == null) {
            state.setAuthScheme(this.selectAuthScheme(challenges));
        }
        AuthScheme authscheme = state.getAuthScheme();
        String id = authscheme.getSchemeName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using authentication scheme: " + id);
        }
        if ((challenge = (String)challenges.get(id.toLowerCase())) == null) {
            throw new AuthenticationException(String.valueOf(id) + " authorization challenge expected, but not found");
        }
        authscheme.processChallenge(challenge);
        LOG.debug("Authorization challenge processed");
        return authscheme;
    }
}

