/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.parent.instrumentation.helper;

import com.ca.apm.parent.instrumentation.helper.ParentCandidateFilePersistenceHelper;
import com.ca.apm.parent.instrumentation.helper.ParentInstrumentationConfig;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.autoprobe.AutoProbeTransformer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public class ParentInstrumentationHelper {
    private static final Module module = new Module("ParentInstrumentationHelper");
    private IModuleFeedbackChannel feedback;
    private IAgent agent;
    private static ConcurrentHashMap<String, String[]> parentsToBePersisted = new ConcurrentHashMap();
    private static AtomicInteger parentInstrumentationCount = new AtomicInteger(0);

    public ParentInstrumentationHelper(IAgent agent) {
        this.agent = agent;
        this.feedback = agent.IAgent_getModuleFeedback();
    }

    public Class[] getAllClassesInVm() {
        TransformerAdministrator tAdm = this.agent.IAgent_getTransformerAdministrator();
        AutoProbeTransformer dit = (AutoProbeTransformer)tAdm.getDynamicInstrumentationTransformer();
        if (dit != null) {
            IClassRedefinitionDelegate.IRedefinedClassRepository rep = dit.getClasses();
            int size = rep.getAllClassInVM().length;
            Class[] allClassesInVm = new Class[size];
            int i = 0;
            while (i < size) {
                allClassesInVm[i] = rep.getAllClassInVM()[i];
                ++i;
            }
            return allClassesInVm;
        }
        return null;
    }

    public ArrayList getMatchingMethods(String classToFind, String methodName, Class[] allClassesInVm) {
        ArrayList<Method> list = new ArrayList<Method>();
        if (allClassesInVm == null) {
            return list;
        }
        this.feedback.debug(module, "Finding Matching Methods in VM :" + classToFind + ":" + methodName);
        Class clazz = null;
        boolean bFound = false;
        int i = 0;
        while (i < allClassesInVm.length) {
            clazz = allClassesInVm[i];
            String name = clazz.getName();
            if (classToFind.length() == name.length() && classToFind.equals(name)) {
                bFound = true;
                break;
            }
            ++i;
        }
        if (bFound) {
            Method[] methods = clazz.getDeclaredMethods();
            int j = 0;
            while (j < methods.length) {
                if (methods[j].getName().length() == methodName.length() && methods[j].getName().equals(methodName)) {
                    list.add(methods[j]);
                }
                ++j;
            }
        }
        this.feedback.debug(module, "Matching Methods count :" + list.size());
        return list;
    }

    public boolean persistParentCandidate(String key, String[] methodInfo) {
        boolean traceDirectivesClampHit = ParentInstrumentationHelper.getTraceClampStatus();
        boolean queueSizeClampHit = ParentInstrumentationHelper.getQueueClampStatus();
        if (traceDirectivesClampHit || queueSizeClampHit && !parentsToBePersisted.contains(key)) {
            return false;
        }
        if (parentsToBePersisted.putIfAbsent(key, methodInfo) == null) {
            parentInstrumentationCount.getAndIncrement();
        }
        return true;
    }

    public static int getParentInstQueueSize() {
        return parentInstrumentationCount.intValue();
    }

    public static void removeParentInst(String key) {
        if (parentsToBePersisted.remove(key) != null) {
            parentInstrumentationCount.getAndDecrement();
        }
    }

    public static String[] getParentInstValue(String key) {
        return parentsToBePersisted.get(key);
    }

    public static Set<String> getParentInstAllKeys() {
        return parentsToBePersisted.keySet();
    }

    public static void clearParentInstEntries(ArrayList<String> keysToDelete) {
        Iterator<String> itr = keysToDelete.iterator();
        while (itr.hasNext()) {
            if (parentsToBePersisted.remove(itr.next()) == null) continue;
            parentInstrumentationCount.getAndDecrement();
        }
    }

    public static int getDataCount() {
        return parentInstrumentationCount.get();
    }

    public static boolean getTraceClampStatus() {
        return ParentCandidateFilePersistenceHelper.getInstrumentedMethodsCountInPbd() >= ParentInstrumentationConfig.getPersistenceTraceDirectivesClampSize();
    }

    public static boolean getQueueClampStatus() {
        return parentInstrumentationCount.intValue() >= ParentInstrumentationConfig.getPersistenceQueueClampSize();
    }

    public static void clearAllParentInstEntries() {
        parentsToBePersisted.clear();
    }

    public static String convertToPackageRegex(String packageName) {
        return String.valueOf(packageName.replace(".", "\\.")) + ".*";
    }

    public static boolean doesPackgeMatchesPatterns(String pkg, Set<Pattern> pkgPatterns) {
        boolean matches = false;
        for (Pattern packagePattern : pkgPatterns) {
            if (!packagePattern.matcher(pkg).matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }
}

