/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.dataresolver;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpURLConnectionDataResolver;
import com.wily.introscope.agent.trace.backend.http.helper.HttpResponseHelper;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.utilities.UrlUtilities;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.Module;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;

public class OC4JHttpURLConnectionDataResolver
extends HttpURLConnectionDataResolver {
    private static Module module = new Module("OC4JHttpURLConnectionDataResolver");
    private static final HttpDataResolver instance = new OC4JHttpURLConnectionDataResolver();

    private OC4JHttpURLConnectionDataResolver() {
    }

    public static HttpDataResolver getInstance() {
        return instance;
    }

    @Override
    public URI getUri(IAgent agent, InvocationData data) {
        try {
            HttpURLConnection connection = (HttpURLConnection)data.getInvocationObject();
            URL url = HttpResponseHelper.getURL(connection);
            if (url != null) {
                String path = url.getPath();
                if (path != null && !path.isEmpty() && !path.startsWith("/")) {
                    if (agent.IAgent_getModuleFeedback().isDebugEnabled()) {
                        agent.IAgent_getModuleFeedback().debug("Path had no leading slash - would cause unknown host: " + url.toString());
                    }
                    url = new URL(url.getProtocol(), url.getHost(), url.getPort(), "/{invalid}");
                }
                return new URI(UrlUtilities.encodeSpecialChars(agent, url.toString()));
            }
        }
        catch (Exception e) {
            agent.IAgent_getModuleFeedback().error(module, "getURI(), Unable to get URL:" + e);
            agent.IAgent_getModuleFeedback().error((Throwable)e);
        }
        return BackendProtocolsConstants.UNKNOWN_URI;
    }

    @Override
    public int getHttpStatusCode(IAgent agent, InvocationData data) {
        int responseCode;
        block9: {
            Integer code;
            Object statusCode;
            Object object;
            Object httpResponse;
            block8: {
                boolean expected;
                if (!data.hasInvocationThrownException() || !(expected = super.isExpectedException(data.getInvocationThrownException()))) break block8;
                return -1;
            }
            HttpURLConnection connection = (HttpURLConnection)data.getInvocationObject();
            responseCode = HttpResponseHelper.getResponseCode(connection);
            if (responseCode != -1 || (httpResponse = ReflectionUtils.getFieldValueOfObject((object = data.getInvocationObject()).getClass(), (Object)object, (String)"resp")) == null || (statusCode = ReflectionUtils.getFieldValueOfObject(httpResponse.getClass(), (Object)httpResponse, (String)"StatusCode")) == null || !(statusCode instanceof Integer) || (responseCode = (code = (Integer)statusCode).intValue()) != 0) break block9;
            return -1;
        }
        try {
            return responseCode;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().debug(module, "getHttpStatusCode() Unable to get response code: " + t.toString());
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
            return -1;
        }
    }

    @Override
    public String getHttpStatusMessage(IAgent agent, InvocationData data) {
        try {
            Object statusCode;
            Object object;
            Object httpResponse;
            HttpURLConnection connection = (HttpURLConnection)data.getInvocationObject();
            String message = HttpResponseHelper.getResponseMessage(connection);
            if (message == null && (httpResponse = ReflectionUtils.getFieldValueOfObject((object = data.getInvocationObject()).getClass(), (Object)object, (String)"resp")) != null && (statusCode = ReflectionUtils.getFieldValueOfObject(httpResponse.getClass(), (Object)httpResponse, (String)"ReasonLine")) != null && statusCode instanceof String) {
                message = (String)statusCode;
            }
            return message;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().debug(module, "getHttpStatusMessage() Unable to get response status message: " + t.toString());
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
            return null;
        }
    }
}

