/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.jms.helper;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualElement;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.jms.nameformatter.JMSNameFormatter;
import com.wily.introscope.agent.util.ReflectionLookupException;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class JMSHelper {
    public static final Module module = new Module("JMSHelper");
    private static final char UNDERSCORE_CHAR = '_';
    private static IWeakIdentityMap consumersOrProducersInfo = null;
    private static Class jmsQueueClass = null;
    private static Class jmsTopicClass = null;
    private static Class jmsTemporaryQueueClass = null;
    private static Class jmsTemporaryTopicClass = null;
    private static Class jmsDestinationClass = null;
    private static volatile IModuleFeedbackChannel agentFeedBackChannel;
    private static boolean alreadyWarnedStackCorruption;

    static {
        alreadyWarnedStackCorruption = false;
        IAgent agent = null;
        try {
            agent = AgentShim.getAgent();
            agentFeedBackChannel = agent.IAgent_getModuleFeedback();
            consumersOrProducersInfo = agent.IAgent_getConcurrentMapFactory().getConcurrentCappedWeakIdentityMap("jmsConsumerToDestination");
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public static void populateConsumerOrProducerDetails(Object msgConsumerOrProducer, Object jmsDestination) {
        consumersOrProducersInfo.putWeak(msgConsumerOrProducer, jmsDestination);
    }

    public static Object getDestinationInfoFromSession(Object msgConsumerOrProducer) {
        return consumersOrProducersInfo.getWeak(msgConsumerOrProducer);
    }

    public static Object getConsumerDestinationInfoFromSession(Object msgConsumer) {
        Object destination = consumersOrProducersInfo.getWeak(msgConsumer);
        if (destination == null) {
            destination = JMSHelper.getConsumerDestination(msgConsumer);
            if (destination != null) {
                consumersOrProducersInfo.putWeak(msgConsumer, destination);
            } else {
                consumersOrProducersInfo.putWeak(msgConsumer, (Object)Boolean.FALSE);
            }
        }
        if (destination == Boolean.FALSE) {
            return null;
        }
        return destination;
    }

    public static Object getDestination(InvocationData data, IModuleFeedbackChannel logger) {
        Object dest = null;
        try {
            dest = ReflectionUtils.invokeMethodOnObject((Object)data.getInvocationParameterAsObject(0), (String)"getJMSDestination", (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Exception e) {
            logger.error(module, "Could not get Destination Object  Exception: " + e + " Cause: " + e.getCause());
            return null;
        }
        return dest;
    }

    public static Object getConsumerDestination(InvocationData data) {
        Object consumer = data.getInvocationObject();
        return JMSHelper.getConsumerDestination(consumer);
    }

    public static Object getConsumerDestination(Object consumer) {
        Object dest = null;
        try {
            dest = ReflectionUtils.invokeMethodOnObject((Object)consumer, (String)"getDestination", (boolean)false, (IModuleFeedbackChannel)agentFeedBackChannel);
        }
        catch (ReflectionLookupException reflectionLookupException) {
            try {
                dest = ReflectionUtils.invokeMethodOnObject((Object)consumer, (String)"getDestination", (boolean)true, (IModuleFeedbackChannel)agentFeedBackChannel);
            }
            catch (Exception e) {
                JMSHelper.debug(module, "Could not get Destination Object  Exception: " + e + " Cause: " + e.getCause());
                return null;
            }
        }
        catch (Exception e) {
            JMSHelper.debug(module, "Could not get Destination Object  Exception: " + e + " Cause: " + e.getCause());
            return null;
        }
        return dest;
    }

    public static boolean isQueue(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsQueueClass == null) {
                    jmsQueueClass = Class.forName("javax.jms.Queue", true, dest.getClass().getClassLoader());
                }
                result = jmsQueueClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for Queue  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    private static String getWeblogicDestinationType(Object dest, IModuleFeedbackChannel logger) {
        String destinationType = "Unknown";
        try {
            try {
                boolean isQueue = (Boolean)ReflectionUtils.invokeMethodOnObject((Object)dest, (String)"isQueue", (Class[])new Class[0], (Object[])new Object[0]);
                if (isQueue) {
                    destinationType = "Queues";
                } else {
                    boolean isTopic = (Boolean)ReflectionUtils.invokeMethodOnObject((Object)dest, (String)"isTopic", (Class[])new Class[0], (Object[])new Object[0]);
                    if (isTopic) {
                        destinationType = "Topics";
                    }
                }
            }
            catch (Exception exception) {
                logger.error("Failed to find if destination being used is a Weblogic Queue");
            }
        }
        catch (Throwable throwable) {}
        return destinationType;
    }

    public static boolean isTopic(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsTopicClass == null) {
                    jmsTopicClass = Class.forName("javax.jms.Topic", true, dest.getClass().getClassLoader());
                }
                result = jmsTopicClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for Queue  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    public static String getQueueName(Object queue, IModuleFeedbackChannel logger) {
        String queueName = "Unknown Queue";
        if (queue != null) {
            try {
                queueName = (String)ReflectionUtils.invokeMethodOnObject((Object)queue, (String)"getQueueName", (Class[])new Class[0], (Object[])new Object[0]);
                queueName = JMSHelper.stripQueryFromName(queueName);
            }
            catch (Exception e) {
                logger.error(module, "Unable to get Queue Name Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return queueName;
    }

    public static String getTopicName(Object topic, IModuleFeedbackChannel logger) {
        String topicName = "Unknown Topic";
        if (topic != null) {
            try {
                topicName = (String)ReflectionUtils.invokeMethodOnObject((Object)topic, (String)"getTopicName", (Class[])new Class[0], (Object[])new Object[0]);
                topicName = JMSHelper.stripQueryFromName(topicName);
            }
            catch (Exception e) {
                logger.error(module, "Unable to get Topic Name Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return topicName;
    }

    private static String stripQueryFromName(String name) {
        int queryIndex;
        if (name != null && (queryIndex = name.indexOf("?")) != -1) {
            return name.substring(0, queryIndex);
        }
        return name;
    }

    public static boolean isDestination(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsDestinationClass == null) {
                    jmsDestinationClass = Class.forName("javax.jms.Destination", true, dest.getClass().getClassLoader());
                }
                result = jmsDestinationClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for destination  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    public static String getDestinationType(Object destination, IModuleFeedbackChannel feedback, InvocationData data) {
        String destinationType = (String)data.get("jms.destination.type");
        if (destinationType != null) {
            return destinationType;
        }
        destinationType = "Unknown";
        if (destination == null) {
            return destinationType;
        }
        if (JMSHelper.isWeblogicDestination(destination)) {
            destinationType = JMSHelper.getWeblogicDestinationType(destination, feedback);
        } else if (JMSHelper.isQueue(destination, feedback)) {
            destinationType = "Queues";
        } else if (JMSHelper.isTopic(destination, feedback)) {
            destinationType = "Topics";
        }
        data.put("jms.destination.type", (Object)destinationType);
        return destinationType;
    }

    private static boolean isWeblogicDestination(Object destination) {
        if (destination != null) {
            return destination.getClass().getName().indexOf("weblogic") != -1;
        }
        return false;
    }

    public static String substituteMetricSeparatorChars(String metric) {
        String newMetric = null;
        newMetric = metric.replace(':', '_');
        newMetric = newMetric.replace('|', '_');
        return newMetric;
    }

    public static boolean isTempQueue(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsTemporaryQueueClass == null) {
                    jmsTemporaryQueueClass = Class.forName("javax.jms.TemporaryQueue", true, dest.getClass().getClassLoader());
                }
                result = jmsTemporaryQueueClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for destination  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    public static boolean isTempTopic(Object dest, IModuleFeedbackChannel logger) {
        boolean result = false;
        if (dest != null) {
            try {
                if (jmsTemporaryTopicClass == null) {
                    jmsTemporaryTopicClass = Class.forName("javax.jms.TemporaryTopic", true, dest.getClass().getClassLoader());
                }
                result = jmsTemporaryTopicClass.isAssignableFrom(dest.getClass());
            }
            catch (ClassNotFoundException e) {
                logger.error(module, "Could not get Class information for destination  Exception: " + e + " Cause: " + e.getCause());
            }
        }
        return result;
    }

    public static boolean isTempDestination(Object dest, IModuleFeedbackChannel logger) {
        return JMSHelper.isTempQueue(dest, logger) || JMSHelper.isTempTopic(dest, logger);
    }

    public static boolean isJMSDestinationPassedAsFirstArg(InvocationData data, IModuleFeedbackChannel logger) {
        Boolean isDestinationFirstArg = (Boolean)data.get("jms.dest.passed.as.first.arg");
        if (isDestinationFirstArg != null && isDestinationFirstArg.booleanValue()) {
            return true;
        }
        Object dest = data.getInvocationParameterAsObject(0);
        boolean isDestination = JMSHelper.isDestination(dest, logger);
        data.put("jms.dest.passed.as.first.arg", (Object)(isDestination ? Boolean.TRUE : Boolean.FALSE));
        return isDestination;
    }

    public static boolean isMessageRedeliverySet(Object jmsMsgObject, IModuleFeedbackChannel logger, InvocationData data) {
        try {
            Boolean msgReDelivered = (Boolean)ReflectionUtils.invokeMethodOnObject((Object)jmsMsgObject, (String)"getJMSRedelivered", (Class[])new Class[0], (Object[])new Object[0]);
            return msgReDelivered;
        }
        catch (Exception e) {
            logger.error(module, "Could not check for msgRedelivery property in the msg  Object  Exception: " + e + " Cause: " + e.getCause());
            return false;
        }
    }

    public static boolean shouldRunProducerTracers(InvocationData data, IModuleFeedbackChannel feedback) {
        Boolean shouldRun = (Boolean)data.get("should run");
        if (shouldRun != null) {
            return shouldRun;
        }
        String destinationNameUsingProducerAPI = JMSHelper.getDestinationNameUsingProducerAPI(data, feedback);
        shouldRun = destinationNameUsingProducerAPI != null && !"Unknown".equals(destinationNameUsingProducerAPI) || JMSHelper.getDestinationInfoFromSession(data.getInvocationObject()) != null || JMSHelper.isJMSDestinationPassedAsFirstArg(data, feedback);
        data.put("should run", (Object)shouldRun);
        return shouldRun;
    }

    public static boolean shouldRunFinishTraceOnSyncReceiver(InvocationData invocationData) {
        Boolean shouldRun = (Boolean)invocationData.get("jms.receiver.tracer.should.finish");
        if (shouldRun != null) {
            return shouldRun;
        }
        shouldRun = invocationData.getInvocationReturnValueAsObject() != null && JMSHelper.getConsumerDestinationInfoFromSession(invocationData.getInvocationObject()) != null;
        invocationData.put("jms.receiver.tracer.should.finish", (Object)shouldRun);
        return shouldRun;
    }

    public static boolean isCachedDestTypeATopic(InvocationData data) {
        String destType = (String)data.get("jms.destination.type");
        return destType != null && destType.equals("Topics");
    }

    public static boolean isCachedDestTypeAQueue(InvocationData data) {
        String destType = (String)data.get("jms.destination.type");
        return destType != null && destType.equals("Queues");
    }

    public static String getCachedDestinationName(InvocationData data) {
        String destinationName = (String)data.get("Jms.Destination.Key");
        if (destinationName != null) {
            return destinationName;
        }
        return "Unknown";
    }

    public static String getCachedHostName(InvocationData data) {
        String hostName = (String)data.get("Hostname");
        if (hostName != null) {
            return hostName;
        }
        return "Unknown";
    }

    public static String getCachedQueueManagerName(InvocationData data) {
        String destinationName = (String)data.get("QueueManager");
        if (destinationName != null) {
            return destinationName;
        }
        return "Unknown";
    }

    public static boolean isStackEmpty(InvocationData data) {
        IStackElement top;
        Boolean result = (Boolean)data.get("jms.perinterval.is.stack.empty.key");
        if (result != null) {
            return result;
        }
        IStackElement root = VirtualStack.getTransactionCache().getRoot();
        if (root == null) {
            top = VirtualStack.peek();
            if (top == null) {
                data.put("jms.perinterval.is.stack.empty.key", (Object)Boolean.TRUE);
                return true;
            }
            try {
                if (!alreadyWarnedStackCorruption) {
                    AgentShim.getAgent().IAgent_getModuleFeedback().warn(module, "Detected VirtualStack corruption, root is not set in an non-empty stack");
                    alreadyWarnedStackCorruption = true;
                    AgentShim.getAgent().IAgent_getModuleFeedback().info(module, "Location: ", (Throwable)new Exception("Virtual Stack Corrupt"));
                } else {
                    AgentShim.getAgent().IAgent_getModuleFeedback().debug(module, "Detected VirtualStack corruption, root is not set in an non-empty stack");
                    AgentShim.getAgent().IAgent_getModuleFeedback().debug(module, "Location: ", (Throwable)new Exception("Virtual Stack Corrupt"));
                }
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
            IStackElement element = top;
            while (element != null) {
                IStackElement next = element.getParent();
                if (next == null) {
                    VirtualStack.getTransactionCache().setRoot(element);
                }
                element = next;
            }
        }
        if (root == data) {
            data.put("jms.perinterval.is.stack.empty.key", (Object)Boolean.TRUE);
            return true;
        }
        top = VirtualStack.peek();
        IStackElement cur = top == data ? top.getParent() : top;
        boolean isStackNotEmpty = false;
        while (cur != null) {
            if (!(cur instanceof VirtualElement.Dummy) && cur != data) {
                isStackNotEmpty = true;
                break;
            }
            cur = cur.getParent();
        }
        result = isStackNotEmpty ? Boolean.FALSE : Boolean.TRUE;
        data.put("jms.perinterval.is.stack.empty.key", (Object)result);
        return result;
    }

    public static void trace(Module moduleName, String debugMsg) {
        if (agentFeedBackChannel.isTraceEnabled()) {
            agentFeedBackChannel.trace(moduleName, debugMsg);
        }
    }

    public static void debug(Module moduleName, String debugMsg) {
        if (agentFeedBackChannel.isDebugEnabled()) {
            agentFeedBackChannel.debug(moduleName, debugMsg);
        }
    }

    public static void info(Module moduleName, String msg) {
        agentFeedBackChannel.info(moduleName, msg);
    }

    public static void error(Module moduleName, String msg) {
        agentFeedBackChannel.error(moduleName, msg);
    }

    public static String getDestinationNameUsingProducerAPI(InvocationData producerInvocationData, IModuleFeedbackChannel logger) {
        try {
            String destinationName = (String)producerInvocationData.get("Jms.Destination.Key");
            if (destinationName != null) {
                return destinationName;
            }
            Object jmsDestionationAsObject = ReflectionUtils.invokeMethodOnObject((Object)producerInvocationData.getInvocationObject(), (String)"getDestination", (Class[])new Class[0], (Object[])new Object[0]);
            if (jmsDestionationAsObject != null) {
                String destinationType = JMSHelper.getDestinationType(jmsDestionationAsObject, logger, producerInvocationData);
                return JMSNameFormatter.checkTempDestAndReturn(producerInvocationData, jmsDestionationAsObject, destinationType);
            }
        }
        catch (Exception e) {
            logger.debug(module, "Could not get Destination Object using JMSProducer API  Exception: " + e + " Cause: " + e.getCause());
            return "Unknown";
        }
        return "Unknown";
    }

    public static String getQueueManagerWithHostname(InvocationData invocationData, IModuleFeedbackChannel logger, String destinationType) {
        try {
            String queueManagerName = (String)invocationData.get("QueueManager");
            Object jmsObject = invocationData.getInvocationObject();
            if (queueManagerName == null) {
                Object messageObject;
                Object sessionObject;
                logger.debug(module, "Appending queue manager name for IBM MQ JMS classes ");
                if (jmsObject.getClass() != null && jmsObject.getClass().getName().equals("com.ibm.mq.jms.MQMessageConsumer$FacadeMessageListener") && invocationData.getInvocationParameterCount() > 0 && (sessionObject = JMSHelper.getMessageSessionObject(messageObject = invocationData.getInvocationParameterAsObject(0), agentFeedBackChannel)) != null) {
                    jmsObject = sessionObject;
                }
                if (jmsObject != null && (queueManagerName = JMSHelper.getJMSObjectProperty(jmsObject, "XMSC_WMQ_QUEUE_MANAGER")) != "" && queueManagerName != null) {
                    invocationData.put("QueueManager", (Object)queueManagerName);
                }
            }
            if (queueManagerName != null && jmsObject != null) {
                String hostName = JMSHelper.getQueueManagerHostName(invocationData, logger, jmsObject);
                queueManagerName = hostName != "Unknown" && queueManagerName != "" ? (hostName = String.valueOf(destinationType) + " in " + queueManagerName + " hosted on " + hostName) : queueManagerName;
            }
            return queueManagerName;
        }
        catch (Exception e) {
            logger.debug(module, "Could not get queue manager name  Exception: " + e + " Cause: " + e.getCause());
            return "Unknown";
        }
    }

    private static String getQueueManagerHostName(InvocationData invocationData, IModuleFeedbackChannel logger, Object jmsMessageObject) {
        String hostName = (String)invocationData.get("Hostname");
        if (hostName == null) {
            try {
                hostName = JMSHelper.getJMSObjectProperty(jmsMessageObject, "XMSC_WMQ_CONNECTION_NAME_LIST_INT");
                if (hostName != "" && hostName != null) {
                    invocationData.put("Hostname", (Object)hostName);
                }
            }
            catch (Exception e) {
                logger.debug(module, "Could not get queue manager host name  Exception: " + e + " Cause: " + e.getCause());
                hostName = "Unknown";
            }
        }
        return hostName;
    }

    protected static String getJMSObjectProperty(Object jmsObject, String xmsc_wmq_propertyConstant) throws Exception {
        Object mJmsReadablePropertyContextImpl_getStringProperty = null;
        String xmsc_wmq_propertyValue = "";
        if (jmsObject != null) {
            Class<?> jmsObjectClass = jmsObject.getClass();
            if (mJmsReadablePropertyContextImpl_getStringProperty == null || !mJmsReadablePropertyContextImpl_getStringProperty.getClass().isInstance(jmsObjectClass)) {
                xmsc_wmq_propertyValue = (String)ReflectionUtils.invokeMethodOnObject((Object)jmsObject, (String)"getStringProperty", (Class[])new Class[]{String.class}, (Object[])new Object[]{xmsc_wmq_propertyConstant});
            }
            if (xmsc_wmq_propertyValue != null && "XMSC_WMQ_CONNECTION_NAME_LIST_INT".equals(xmsc_wmq_propertyConstant)) {
                xmsc_wmq_propertyValue = xmsc_wmq_propertyValue.substring(0, xmsc_wmq_propertyValue.indexOf("("));
            }
            if ((xmsc_wmq_propertyValue == null || xmsc_wmq_propertyValue.trim().length() == 0) && "XMSC_WMQ_QUEUE_MANAGER".equals(xmsc_wmq_propertyConstant)) {
                xmsc_wmq_propertyConstant = "XMSC_WMQ_RESOLVED_QUEUE_MANAGER";
                xmsc_wmq_propertyValue = (String)ReflectionUtils.invokeMethodOnObject((Object)jmsObject, (String)"getStringProperty", (Class[])new Class[]{String.class}, (Object[])new Object[]{xmsc_wmq_propertyConstant});
            }
        }
        return xmsc_wmq_propertyValue == null ? "" : xmsc_wmq_propertyValue.trim();
    }

    public static Object getMessageSessionObject(Object jmsTextMessageImpl, IModuleFeedbackChannel logger) throws Exception {
        Object jmstheSession = null;
        Field fJmsMessageImpl_theSession = null;
        try {
            if (jmsTextMessageImpl != null) {
                Class<?> jmsMessageImplClass;
                Class<?> clazz = jmsMessageImplClass = jmsTextMessageImpl.getClass() != null ? jmsTextMessageImpl.getClass().getSuperclass() : jmsTextMessageImpl.getClass();
                if (jmsMessageImplClass != null && jmsMessageImplClass.getName().equals("com.ibm.msg.client.jms.internal.JmsMessageImpl")) {
                    if (fJmsMessageImpl_theSession == null) {
                        fJmsMessageImpl_theSession = jmsMessageImplClass.getDeclaredField("theSession");
                        fJmsMessageImpl_theSession.setAccessible(true);
                    }
                    jmstheSession = fJmsMessageImpl_theSession.get(jmsTextMessageImpl);
                }
            }
        }
        catch (Exception exception) {
            logger.debug(module, "Could not get JMS session object from message impl class");
        }
        return jmstheSession;
    }

    public static Map getMessageProperties(Object jmsMessage, IModuleFeedbackChannel logger) {
        HashMap properties = new HashMap();
        try {
            Enumeration propertyNames = (Enumeration)ReflectionUtils.invokeMethodOnObject((Object)jmsMessage, (String)"getPropertyNames", (Class[])new Class[0], (Object[])new Object[0]);
            while (propertyNames.hasMoreElements()) {
                Object propertyName = propertyNames.nextElement();
                Object propertyValueAsObject = ReflectionUtils.invokeMethodOnObject((Object)jmsMessage, (String)"getObjectProperty", (Class[])new Class[]{String.class}, (Object[])new Object[]{propertyName});
                properties.put(propertyName, propertyValueAsObject);
            }
        }
        catch (Exception exception) {
            logger.debug(module, "Could not get JMS message properties using the JMS API: getObjectProperty() ");
        }
        return properties;
    }

    public static void clearProperties(Object jmsMessage, IModuleFeedbackChannel logger) {
        try {
            ReflectionUtils.invokeMethodOnObject((Object)jmsMessage, (String)"clearProperties", (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (Exception exception) {
            logger.debug(module, "Could not clear message properties using the JMS API: clearProperties() ");
        }
    }

    public static void restoreProperties(Object jmsMessage, Map properties, IModuleFeedbackChannel logger) {
        for (Object key : properties.keySet()) {
            Object value = properties.get(key);
            Class[] paramTypes = new Class[]{String.class, Object.class};
            Object[] paramvalues = new Object[]{(String)key, value};
            try {
                ReflectionUtils.invokeMethodOnObject((Object)jmsMessage, (String)"setObjectProperty", (Class[])paramTypes, (Object[])paramvalues);
            }
            catch (Exception exception) {
                logger.debug(module, "Could not restore message properties on the JMS message object: ");
            }
        }
    }
}

